/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.IParametersUsage;
import com.intellij.codeInspection.bytecodeAnalysis.asm.IParamsValue;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParametersCollector;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteAnalyzer;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParametersUsage;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParamsValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class LeakingParameters {
    public final Frame<Value>[] frames;
    public final boolean[] parameters;
    public final boolean[] nullableParameters;

    public LeakingParameters(Frame<Value>[] frames2, boolean[] parameters2, boolean[] nullableParameters) {
        this.frames = frames2;
        this.parameters = parameters2;
        this.nullableParameters = nullableParameters;
    }

    @NotNull
    public static LeakingParameters build(String className2, MethodNode methodNode, boolean jsr) throws AnalyzerException {
        Frame<ParamsValue>[] frames2 = jsr ? new Analyzer<ParamsValue>(new ParametersUsage(methodNode)).analyze(className2, methodNode) : new LiteAnalyzer<ParamsValue>(new ParametersUsage(methodNode)).analyze(className2, methodNode);
        InsnList insns = methodNode.instructions;
        LeakingParametersCollector collector2 = new LeakingParametersCollector(methodNode);
        block3: for (int i = 0; i < frames2.length; ++i) {
            AbstractInsnNode insnNode = insns.get(i);
            Frame<ParamsValue> frame = frames2[i];
            if (frame == null) continue;
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    continue block3;
                }
                default: {
                    new Frame<ParamsValue>(frame).execute(insnNode, collector2);
                }
            }
        }
        boolean[] notNullParameters = collector2.leaking;
        boolean[] nullableParameters = collector2.nullableLeaking;
        for (int i = 0; i < nullableParameters.length; ++i) {
            int n = i;
            nullableParameters[n] = nullableParameters[n] | notNullParameters[i];
        }
        LeakingParameters leakingParameters = new LeakingParameters(frames2, notNullParameters, nullableParameters);
        if (leakingParameters == null) {
            LeakingParameters.$$$reportNull$$$0(0);
        }
        return leakingParameters;
    }

    @NotNull
    public static LeakingParameters buildFast(String className2, MethodNode methodNode, boolean jsr) throws AnalyzerException {
        IParametersUsage parametersUsage = new IParametersUsage(methodNode);
        Frame<IParamsValue>[] frames2 = jsr ? new Analyzer<IParamsValue>(parametersUsage).analyze(className2, methodNode) : new LiteAnalyzer<IParamsValue>(parametersUsage).analyze(className2, methodNode);
        int leakingMask = parametersUsage.leaking;
        int nullableLeakingMask = parametersUsage.nullableLeaking;
        boolean[] notNullParameters = new boolean[parametersUsage.arity];
        boolean[] nullableParameters = new boolean[parametersUsage.arity];
        for (int i = 0; i < notNullParameters.length; ++i) {
            notNullParameters[i] = (leakingMask & 1 << i) != 0;
            nullableParameters[i] = ((leakingMask | nullableLeakingMask) & 1 << i) != 0;
        }
        LeakingParameters leakingParameters = new LeakingParameters(frames2, notNullParameters, nullableParameters);
        if (leakingParameters == null) {
            LeakingParameters.$$$reportNull$$$0(1);
        }
        return leakingParameters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/codeInspection/bytecodeAnalysis/asm/LeakingParameters";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "build";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFast";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

