/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ParametersUsage;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParamsValue;
import java.util.List;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

class LeakingParametersCollector
extends ParametersUsage {
    final boolean[] leaking;
    final boolean[] nullableLeaking;

    LeakingParametersCollector(MethodNode methodNode) {
        super(methodNode);
        this.leaking = new boolean[this.arity];
        this.nullableLeaking = new boolean[this.arity];
    }

    @Override
    public ParamsValue unaryOperation(AbstractInsnNode insn, ParamsValue value) {
        switch (insn.getOpcode()) {
            case 153: 
            case 154: 
            case 172: 
            case 176: 
            case 180: 
            case 190: 
            case 193: 
            case 194: 
            case 198: 
            case 199: {
                boolean[] params2 = value.params;
                for (int i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.leaking[n] = this.leaking[n] | params2[i];
                }
                break;
            }
        }
        return super.unaryOperation(insn, value);
    }

    @Override
    public ParamsValue binaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2) {
        switch (insn.getOpcode()) {
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                boolean[] params2 = value1.params;
                for (int i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.leaking[n] = this.leaking[n] | params2[i];
                }
                break;
            }
            case 181: {
                int i;
                boolean[] params3 = value1.params;
                for (i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.leaking[n] = this.leaking[n] | params3[i];
                }
                params3 = value2.params;
                for (i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.nullableLeaking[n] = this.nullableLeaking[n] | params3[i];
                }
                break;
            }
        }
        return super.binaryOperation(insn, value1, value2);
    }

    @Override
    public ParamsValue ternaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2, ParamsValue value3) {
        switch (insn.getOpcode()) {
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: {
                boolean[] params2 = value1.params;
                for (int i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.leaking[n] = this.leaking[n] | params2[i];
                }
                break;
            }
            case 83: {
                int i;
                boolean[] params3 = value1.params;
                for (i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.leaking[n] = this.leaking[n] | params3[i];
                }
                params3 = value3.params;
                for (i = 0; i < this.arity; ++i) {
                    int n = i;
                    this.nullableLeaking[n] = this.nullableLeaking[n] | params3[i];
                }
                break;
            }
        }
        return null;
    }

    @Override
    public ParamsValue naryOperation(AbstractInsnNode insn, List<? extends ParamsValue> values2) {
        switch (insn.getOpcode()) {
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                for (ParamsValue paramsValue : values2) {
                    boolean[] params2 = paramsValue.params;
                    for (int i = 0; i < this.arity; ++i) {
                        int n = i;
                        this.leaking[n] = this.leaking[n] | params2[i];
                    }
                }
                break;
            }
        }
        return super.naryOperation(insn, (List)values2);
    }
}

