/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.InterpreterExt;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Opcodes;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.BasicValue;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class LiteAnalyzerExt<V extends Value, Data, MyInterpreter extends Interpreter<V>>
implements Opcodes {
    private final MyInterpreter interpreter;
    private Frame<V>[] frames;
    private boolean[] queued;
    private int[] queue;
    private int top;
    private final Data[] data;

    public Data[] getData() {
        return this.data;
    }

    public LiteAnalyzerExt(MyInterpreter interpreter, Data[] data2, Data startData) {
        this.interpreter = interpreter;
        this.data = data2;
        if (data2.length > 0) {
            data2[0] = startData;
        }
    }

    public Frame<V>[] analyze(String owner, MethodNode m) throws AnalyzerException {
        if ((m.access & 0x500) != 0) {
            this.frames = new Frame[0];
            return this.frames;
        }
        BasicValue refV = BasicValue.REFERENCE_VALUE;
        int n = m.instructions.size();
        InsnList insns = m.instructions;
        List[] handlers2 = new List[n];
        this.frames = new Frame[n];
        this.queued = new boolean[n];
        this.queue = new int[n];
        this.top = 0;
        for (int i = 0; i < m.tryCatchBlocks.size(); ++i) {
            TryCatchBlockNode tcb = m.tryCatchBlocks.get(i);
            int begin = insns.indexOf(tcb.start);
            int end = insns.indexOf(tcb.end);
            for (int j = begin; j < end; ++j) {
                ArrayList<TryCatchBlockNode> insnHandlers = handlers2[j];
                if (insnHandlers == null) {
                    handlers2[j] = insnHandlers = new ArrayList<TryCatchBlockNode>();
                }
                insnHandlers.add(tcb);
            }
        }
        Frame<V> current = this.newFrame(m.maxLocals, m.maxStack);
        Frame<V> handler2 = this.newFrame(m.maxLocals, m.maxStack);
        current.setReturn(((Interpreter)this.interpreter).newValue(Type.getReturnType(m.desc)));
        Type[] args = Type.getArgumentTypes(m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType(owner);
            current.setLocal(local++, ((Interpreter)this.interpreter).newValue(ctype));
        }
        for (int i = 0; i < args.length; ++i) {
            current.setLocal(local++, ((Interpreter)this.interpreter).newValue(args[i]));
            if (args[i].getSize() != 2) continue;
            current.setLocal(local++, ((Interpreter)this.interpreter).newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, ((Interpreter)this.interpreter).newValue(null));
        }
        ((InterpreterExt)this.interpreter).init(this.data[0]);
        this.merge(0, current);
        while (this.top > 0) {
            int insn = this.queue[--this.top];
            Frame<V> f = this.frames[insn];
            this.queued[insn] = false;
            AbstractInsnNode insnNode = null;
            try {
                List insnHandlers;
                insnNode = m.instructions.get(insn);
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    ((InterpreterExt)this.interpreter).init(this.data[insn]);
                    this.merge(insn + 1, f);
                } else {
                    int j;
                    int jump;
                    ((InterpreterExt)this.interpreter).init(this.data[insn]);
                    current.init(f).execute(insnNode, (Interpreter<V>)this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        JumpInsnNode j2 = (JumpInsnNode)insnNode;
                        if (insnOpcode != 167 && insnOpcode != 168) {
                            this.merge(insn + 1, current);
                        }
                        jump = insns.indexOf(j2.label);
                        this.merge(jump, current);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        LookupSwitchInsnNode lsi = (LookupSwitchInsnNode)insnNode;
                        jump = insns.indexOf(lsi.dflt);
                        this.merge(jump, current);
                        for (j = 0; j < lsi.labels.size(); ++j) {
                            LabelNode label = lsi.labels.get(j);
                            jump = insns.indexOf(label);
                            this.merge(jump, current);
                        }
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        TableSwitchInsnNode tsi = (TableSwitchInsnNode)insnNode;
                        jump = insns.indexOf(tsi.dflt);
                        this.merge(jump, current);
                        for (j = 0; j < tsi.labels.size(); ++j) {
                            LabelNode label = tsi.labels.get(j);
                            jump = insns.indexOf(label);
                            this.merge(jump, current);
                        }
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.merge(insn + 1, current);
                    }
                }
                if ((insnHandlers = handlers2[insn]) == null) continue;
                for (int i = 0; i < insnHandlers.size(); ++i) {
                    TryCatchBlockNode tcb = (TryCatchBlockNode)insnHandlers.get(i);
                    int jump = insns.indexOf(tcb.handler);
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push(refV);
                    this.merge(jump, handler2);
                }
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(e.node, "Error at instruction " + insn + ": " + e.getMessage(), e);
            }
            catch (Exception e) {
                throw new AnalyzerException(insnNode, "Error at instruction " + insn + ": " + e.getMessage(), e);
            }
        }
        return this.frames;
    }

    public Frame<V>[] getFrames() {
        return this.frames;
    }

    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    protected Frame<V> newFrame(Frame<? extends V> src) {
        return new Frame<V>(src);
    }

    private void merge(int insn, Frame<V> frame) throws AnalyzerException {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, (Interpreter<V>)this.interpreter);
        }
        Data oldData = this.data[insn];
        Object newData = ((InterpreterExt)this.interpreter).getAfterData(insn);
        if (oldData == null) {
            this.data[insn] = newData;
            changes = true;
        } else if (newData != null) {
            Data mergedData;
            this.data[insn] = mergedData = ((InterpreterExt)this.interpreter).merge(oldData, newData);
            changes |= !oldData.equals(mergedData);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }
}

