/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.ASMUtils;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParamsValue;
import java.util.List;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.FieldInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LdcInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;

class ParametersUsage
extends Interpreter<ParamsValue> {
    final ParamsValue val1;
    final ParamsValue val2;
    int called = -1;
    final int rangeStart;
    final int rangeEnd;
    final int arity;
    final int shift;

    ParametersUsage(MethodNode methodNode) {
        super(393216);
        this.arity = Type.getArgumentTypes(methodNode.desc).length;
        boolean[] emptyParams = new boolean[this.arity];
        this.val1 = new ParamsValue(emptyParams, 1);
        this.val2 = new ParamsValue(emptyParams, 2);
        this.rangeStart = this.shift = (methodNode.access & 8) == 0 ? 2 : 1;
        this.rangeEnd = this.arity + this.shift;
    }

    @Override
    public ParamsValue newValue(Type type2) {
        if (type2 == null) {
            return this.val1;
        }
        ++this.called;
        if (type2 == Type.VOID_TYPE) {
            return null;
        }
        if (this.called < this.rangeEnd && this.rangeStart <= this.called && (ASMUtils.isReferenceType(type2) || ASMUtils.isBooleanType(type2))) {
            boolean[] params2 = new boolean[this.arity];
            params2[this.called - this.shift] = true;
            return type2.getSize() == 1 ? new ParamsValue(params2, 1) : new ParamsValue(params2, 2);
        }
        return type2.getSize() == 1 ? this.val1 : this.val2;
    }

    @Override
    public ParamsValue newOperation(AbstractInsnNode insn) {
        int size;
        switch (insn.getOpcode()) {
            case 9: 
            case 10: 
            case 14: 
            case 15: {
                size = 2;
                break;
            }
            case 18: {
                Object cst = ((LdcInsnNode)insn).cst;
                size = cst instanceof Long || cst instanceof Double ? 2 : 1;
                break;
            }
            case 178: {
                size = Type.getType(((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? this.val1 : this.val2;
    }

    @Override
    public ParamsValue copyOperation(AbstractInsnNode insn, ParamsValue value) {
        return value;
    }

    @Override
    public ParamsValue unaryOperation(AbstractInsnNode insn, ParamsValue value) {
        int size;
        switch (insn.getOpcode()) {
            case 192: {
                return value;
            }
            case 117: 
            case 119: 
            case 133: 
            case 135: 
            case 138: 
            case 140: 
            case 141: 
            case 143: {
                size = 2;
                break;
            }
            case 180: {
                size = Type.getType(((FieldInsnNode)insn).desc).getSize();
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? this.val1 : this.val2;
    }

    @Override
    public ParamsValue binaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2) {
        int size;
        switch (insn.getOpcode()) {
            case 47: 
            case 49: 
            case 97: 
            case 99: 
            case 101: 
            case 103: 
            case 105: 
            case 107: 
            case 109: 
            case 111: 
            case 113: 
            case 115: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                size = 2;
                break;
            }
            default: {
                size = 1;
            }
        }
        return size == 1 ? this.val1 : this.val2;
    }

    @Override
    public ParamsValue ternaryOperation(AbstractInsnNode insn, ParamsValue value1, ParamsValue value2, ParamsValue value3) {
        return null;
    }

    @Override
    public ParamsValue naryOperation(AbstractInsnNode insn, List<? extends ParamsValue> values2) {
        int size;
        int opcode = insn.getOpcode();
        if (opcode == 197) {
            size = 1;
        } else {
            String desc = opcode == 186 ? ((InvokeDynamicInsnNode)insn).desc : ((MethodInsnNode)insn).desc;
            size = Type.getReturnType(desc).getSize();
        }
        return size == 1 ? this.val1 : this.val2;
    }

    @Override
    public void returnOperation(AbstractInsnNode insn, ParamsValue value, ParamsValue expected) {
    }

    @Override
    public ParamsValue merge(ParamsValue v1, ParamsValue v2) {
        if (v1.equals(v2)) {
            return v1;
        }
        boolean[] params2 = new boolean[this.arity];
        boolean[] params1 = v1.params;
        boolean[] params22 = v2.params;
        for (int i = 0; i < this.arity; ++i) {
            params2[i] = params1[i] || params22[i];
        }
        return new ParamsValue(params2, Math.min(v1.size, v2.size));
    }
}

