/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInsight.intention.impl.AddNullableAnnotationFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SetInspectionOptionFix;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.CustomMethodHandlers;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaFactType;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.NullParameterConstraintChecker;
import com.intellij.codeInspection.dataFlow.NullabilityProblem;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.fix.RedundantInstanceofFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithConstantValueFix;
import com.intellij.codeInspection.dataFlow.fix.ReplaceWithObjectsEqualsFix;
import com.intellij.codeInspection.dataFlow.fix.SimplifyToAssignmentFix;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.nullable.NullableStuffInspectionBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.ComparisonUtils;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.DataFlowInspection");
    @NonNls
    private static final String SHORT_NAME = "ConstantConditions";
    public boolean SUGGEST_NULLABLE_ANNOTATIONS;
    public boolean DONT_REPORT_TRUE_ASSERT_STATEMENTS;
    public boolean TREAT_UNKNOWN_MEMBERS_AS_NULLABLE;
    public boolean IGNORE_ASSERT_STATEMENTS;
    public boolean REPORT_CONSTANT_REFERENCE_VALUES = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    public boolean REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL = true;
    public boolean REPORT_UNCHECKED_OPTIONALS = true;

    @Override
    public JComponent createOptionsPanel() {
        throw new RuntimeException("no UI in headless mode");
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(0);
        }
        node.addContent(new Element("option").setAttribute("name", "SUGGEST_NULLABLE_ANNOTATIONS").setAttribute("value", String.valueOf(this.SUGGEST_NULLABLE_ANNOTATIONS)));
        node.addContent(new Element("option").setAttribute("name", "DONT_REPORT_TRUE_ASSERT_STATEMENTS").setAttribute("value", String.valueOf(this.DONT_REPORT_TRUE_ASSERT_STATEMENTS)));
        if (this.IGNORE_ASSERT_STATEMENTS) {
            node.addContent(new Element("option").setAttribute("name", "IGNORE_ASSERT_STATEMENTS").setAttribute("value", "true"));
        }
        if (!this.REPORT_CONSTANT_REFERENCE_VALUES) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_CONSTANT_REFERENCE_VALUES").setAttribute("value", "false"));
        }
        if (this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE) {
            node.addContent(new Element("option").setAttribute("name", "TREAT_UNKNOWN_MEMBERS_AS_NULLABLE").setAttribute("value", "true"));
        }
        if (!this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER").setAttribute("value", "false"));
        }
        if (!this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL").setAttribute("value", "false"));
        }
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            node.addContent(new Element("option").setAttribute("name", "REPORT_UNCHECKED_OPTIONALS").setAttribute("value", "false"));
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(1);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitClass(PsiClass aClass2) {
                if (aClass2 instanceof PsiTypeParameter) {
                    return;
                }
                DataFlowInspectionBase.this.analyzeCodeBlock(aClass2, holder);
            }

            @Override
            public void visitMethod(PsiMethod method) {
                DataFlowInspectionBase.this.analyzeCodeBlock(method.getBody(), holder);
                DataFlowInspectionBase.this.analyzeNullLiteralMethodArguments(method, holder);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                PsiType returnType;
                PsiType methodReturnType;
                super.visitMethodReferenceExpression(expression2);
                PsiElement resolve2 = expression2.resolve();
                if (resolve2 instanceof PsiMethod && TypeConversionUtil.isPrimitiveWrapper(methodReturnType = ((PsiMethod)resolve2).getReturnType()) && NullableNotNullManager.isNullable((PsiMethod)resolve2) && TypeConversionUtil.isPrimitiveAndNotNull(returnType = LambdaUtil.getFunctionalInterfaceReturnType(expression2))) {
                    holder.registerProblem((PsiElement)expression2, InspectionsBundle.message("dataflow.message.unboxing.method.reference", new Object[0]), new LocalQuickFix[0]);
                }
            }

            @Override
            public void visitIfStatement(PsiIfStatement statement2) {
                PsiExpression condition = PsiUtil.skipParenthesizedExprDown(statement2.getCondition());
                if (BranchingInstruction.isBoolConst(condition)) {
                    LocalQuickFix fix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(condition, condition.textMatches("true"));
                    holder.registerProblem((PsiElement)condition, "Condition is always " + condition.getText(), fix);
                }
            }

            @Override
            public void visitWhileStatement(PsiWhileStatement statement2) {
                this.checkLoopCondition(statement2.getCondition());
            }

            @Override
            public void visitDoWhileStatement(PsiDoWhileStatement statement2) {
                this.checkLoopCondition(statement2.getCondition());
            }

            @Override
            public void visitForStatement(PsiForStatement statement2) {
                this.checkLoopCondition(statement2.getCondition());
            }

            private void checkLoopCondition(PsiExpression condition) {
                if ((condition = PsiUtil.skipParenthesizedExprDown(condition)) != null && condition.textMatches("false")) {
                    holder.registerProblem((PsiElement)condition, "Condition is always false", DataFlowInspectionBase.createSimplifyBooleanExpressionFix(condition, false));
                }
            }
        };
        if (javaElementVisitor == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(2);
        }
        return javaElementVisitor;
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private void analyzeNullLiteralMethodArguments(PsiMethod method, ProblemsHolder holder) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && holder.isOnTheFly()) {
            for (PsiParameter parameter : NullParameterConstraintChecker.checkMethodParameters(method)) {
                PsiIdentifier name = parameter.getNameIdentifier();
                if (name == null) continue;
                holder.registerProblem((PsiElement)name, InspectionsBundle.message("dataflow.method.fails.with.null.argument", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createNavigateToNullParameterUsagesFix(parameter));
            }
        }
    }

    private void analyzeCodeBlock(@Nullable PsiElement scope, ProblemsHolder holder) {
        if (scope == null) {
            return;
        }
        PsiClass containingClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType(scope, PsiClass.class);
        if (containingClass != null && PsiUtil.isLocalOrAnonymousClass(containingClass) && !(containingClass instanceof PsiEnumConstantInitializer)) {
            return;
        }
        StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(this.TREAT_UNKNOWN_MEMBERS_AS_NULLABLE, !DfaUtil.isInsideConstructorOrInitializer(scope));
        this.analyzeDfaWithNestedClosures(scope, holder, dfaRunner, Collections.singletonList(dfaRunner.createMemoryState()));
    }

    private void analyzeDfaWithNestedClosures(PsiElement scope, ProblemsHolder holder, StandardDataFlowRunner dfaRunner, Collection<DfaMemoryState> initialStates) {
        DataFlowInstructionVisitor visitor2 = new DataFlowInstructionVisitor();
        RunnerResult rc = dfaRunner.analyzeMethod(scope, visitor2, this.IGNORE_ASSERT_STATEMENTS, initialStates);
        if (rc == RunnerResult.OK) {
            this.createDescription(dfaRunner, holder, visitor2, scope);
            MultiMap<PsiElement, DfaMemoryState> nestedClosures = dfaRunner.getNestedClosures();
            for (PsiElement closure : nestedClosures.keySet()) {
                this.analyzeDfaWithNestedClosures(closure, holder, dfaRunner, nestedClosures.get(closure));
            }
        } else if (rc == RunnerResult.TOO_COMPLEX) {
            PsiIdentifier name = null;
            String message = null;
            if (scope.getParent() instanceof PsiMethod) {
                name = ((PsiMethod)scope.getParent()).getNameIdentifier();
                message = InspectionsBundle.message("dataflow.too.complex", new Object[0]);
            } else if (scope instanceof PsiClass) {
                name = ((PsiClass)scope).getNameIdentifier();
                message = InspectionsBundle.message("dataflow.too.complex.class", new Object[0]);
            }
            if (name != null) {
                holder.registerProblem((PsiElement)name, message, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    @NotNull
    protected List<LocalQuickFix> createNPEFixes(PsiExpression qualifier, PsiExpression expression2, boolean onTheFly) {
        List<LocalQuickFix> list2 = Collections.emptyList();
        if (list2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(3);
        }
        return list2;
    }

    protected List<LocalQuickFix> createMethodReferenceNPEFixes(PsiMethodReferenceExpression methodRef) {
        return Collections.emptyList();
    }

    @Nullable
    protected LocalQuickFix createIntroduceVariableFix(PsiExpression expression2) {
        return null;
    }

    protected LocalQuickFix createReplaceWithTrivialLambdaFix(Object value) {
        return null;
    }

    private void createDescription(StandardDataFlowRunner runner, ProblemsHolder holder, DataFlowInstructionVisitor visitor2, PsiElement scope) {
        Pair<Set<Instruction>, Set<Instruction>> constConditions = runner.getConstConditionalExpressions();
        Set<Instruction> trueSet = constConditions.getFirst();
        Set<Instruction> falseSet = constConditions.getSecond();
        ArrayList<Instruction> allProblems = new ArrayList<Instruction>();
        allProblems.addAll(trueSet);
        allProblems.addAll(falseSet);
        allProblems.addAll(visitor2.myCCEInstructions);
        allProblems.addAll(ContainerUtil.filter(runner.getInstructions(), instruction1 -> instruction1 instanceof InstanceofInstruction && visitor2.isInstanceofRedundant((InstanceofInstruction)instruction1)));
        HashSet<PsiElement> reportedAnchors = new HashSet<PsiElement>();
        for (PsiElement element : visitor2.getProblems(NullabilityProblem.callNPE)) {
            if (!reportedAnchors.add(element)) continue;
            if (element instanceof PsiMethodReferenceExpression) {
                holder.registerProblem(element, InspectionsBundle.message("dataflow.message.npe.methodref.invocation", new Object[0]), this.createMethodReferenceNPEFixes((PsiMethodReferenceExpression)element).toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            if (element instanceof PsiNewExpression) {
                List<LocalQuickFix> fixes = this.createNPEFixes(((PsiNewExpression)element).getQualifier(), (PsiExpression)element, holder.isOnTheFly());
                holder.registerProblem(DataFlowInspectionBase.getElementToHighlight((PsiCall)element), InspectionsBundle.message("dataflow.message.npe.inner.class.construction", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            this.reportCallMayProduceNpe(holder, (PsiMethodCallExpression)element);
        }
        for (PsiElement element : visitor2.getProblems(NullabilityProblem.fieldAccessNPE)) {
            if (!reportedAnchors.add(element)) continue;
            PsiElement parent2 = element.getParent();
            PsiElement fieldAccess = parent2 instanceof PsiArrayAccessExpression || parent2 instanceof PsiReferenceExpression ? parent2 : element;
            this.reportFieldAccessMayProduceNpe(holder, element, (PsiExpression)fieldAccess);
        }
        for (Instruction instruction : allProblems) {
            if (instruction instanceof TypeCastInstruction && reportedAnchors.add(((TypeCastInstruction)instruction).getCastExpression().getCastType())) {
                DataFlowInspectionBase.reportCastMayFail(holder, (TypeCastInstruction)instruction);
                continue;
            }
            if (!(instruction instanceof BranchingInstruction)) continue;
            this.handleBranchingInstruction(holder, visitor2, trueSet, falseSet, reportedAnchors, (BranchingInstruction)instruction);
        }
        DataFlowInspectionBase.reportAlwaysFailingCalls(holder, visitor2, reportedAnchors);
        this.reportConstantPushes(runner, holder, reportedAnchors);
        DataFlowInspectionBase.reportNullableFunctions(visitor2, holder, reportedAnchors);
        this.reportNullableArguments(visitor2, holder, reportedAnchors);
        this.reportNullableAssignments(visitor2, holder, reportedAnchors);
        DataFlowInspectionBase.reportUnboxedNullables(visitor2, holder, reportedAnchors);
        this.reportNullableReturns(visitor2, holder, reportedAnchors, scope);
        if (this.SUGGEST_NULLABLE_ANNOTATIONS) {
            this.reportNullableArgumentsPassedToNonAnnotated(visitor2, holder, reportedAnchors);
        }
        DataFlowInspectionBase.reportOptionalOfNullableImprovements(holder, reportedAnchors, visitor2.getOfNullableCalls());
        this.reportUncheckedOptionalGet(holder, visitor2.getOptionalCalls(), visitor2.getOptionalQualifiers());
        visitor2.getBooleanCalls().forEach((call2, state2) -> {
            if (state2 != ThreeState.UNSURE && reportedAnchors.add((PsiElement)call2)) {
                this.reportConstantCondition(holder, (PsiElement)call2, state2.toBoolean());
            }
        });
        this.reportMethodReferenceProblems(holder, visitor2);
        DataFlowInspectionBase.reportArrayAccessProblems(holder, visitor2);
        if (this.REPORT_CONSTANT_REFERENCE_VALUES) {
            this.reportConstantReferenceValues(holder, visitor2, reportedAnchors);
        }
        if (this.REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL && visitor2.isAlwaysReturnsNotNull(runner.getInstructions())) {
            this.reportAlwaysReturnsNotNull(holder, scope);
        }
    }

    private static void reportArrayAccessProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.outOfBoundsArrayAccesses().forEach(access -> {
            PsiExpression indexExpression = access.getIndexExpression();
            if (indexExpression != null) {
                holder.registerProblem((PsiElement)indexExpression, InspectionsBundle.message("dataflow.message.array.index.out.of.bounds", new Object[0]), new LocalQuickFix[0]);
            }
        });
    }

    private void reportMethodReferenceProblems(ProblemsHolder holder, DataFlowInstructionVisitor visitor2) {
        visitor2.getMethodReferenceResults().forEach((methodRef, dfaValue) -> {
            Object value;
            if (dfaValue instanceof DfaConstValue && (value = ((DfaConstValue)dfaValue).getValue()) instanceof Boolean) {
                holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message("dataflow.message.constant.method.reference", value), this.createReplaceWithTrivialLambdaFix(value));
            }
        });
    }

    private void reportUncheckedOptionalGet(ProblemsHolder holder, Map<PsiMethodCallExpression, ThreeState> calls, List<PsiExpression> qualifiers) {
        if (!this.REPORT_UNCHECKED_OPTIONALS) {
            return;
        }
        for (Map.Entry<PsiMethodCallExpression, ThreeState> entry : calls.entrySet()) {
            PsiExpression qualifier;
            PsiClass optionalClass;
            PsiMethodCallExpression call2;
            PsiMethod method;
            ThreeState state2 = entry.getValue();
            if (state2 != ThreeState.UNSURE || (method = (call2 = entry.getKey()).resolveMethod()) == null || (optionalClass = method.getContainingClass()) == null || (qualifier = PsiUtil.skipParenthesizedExprDown(call2.getMethodExpression().getQualifierExpression())) instanceof PsiMethodCallExpression && qualifiers.stream().anyMatch(q -> PsiEquivalenceUtil.areElementsEquivalent(q, qualifier))) continue;
            SetInspectionOptionFix fix = holder.isOnTheFly() ? new SetInspectionOptionFix(this, "REPORT_UNCHECKED_OPTIONALS", InspectionsBundle.message("inspection.data.flow.turn.off.unchecked.optional.get.quickfix", new Object[0]), false) : null;
            holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call2), InspectionsBundle.message("dataflow.message.optional.get.without.is.present", optionalClass.getName()), fix);
        }
    }

    private void reportAlwaysReturnsNotNull(ProblemsHolder holder, PsiElement scope) {
        if (!(scope.getParent() instanceof PsiMethod)) {
            return;
        }
        PsiMethod method = (PsiMethod)scope.getParent();
        if (PsiUtil.canBeOverridden(method)) {
            return;
        }
        PsiAnnotation nullableAnno = NullableNotNullManager.getInstance(scope.getProject()).getNullableAnnotation(method, false);
        if (nullableAnno == null || !nullableAnno.isPhysical()) {
            return;
        }
        PsiJavaCodeReferenceElement annoName = nullableAnno.getNameReferenceElement();
        assert (annoName != null);
        String msg = "@" + NullableStuffInspectionBase.getPresentableAnnoName(nullableAnno) + " method '" + method.getName() + "' always returns a non-null value";
        LocalQuickFix[] fixes = new LocalQuickFix[]{new AddNotNullAnnotationFix(method)};
        if (holder.isOnTheFly()) {
            fixes = ArrayUtil.append(fixes, new SetInspectionOptionFix(this, "REPORT_NULLABLE_METHODS_RETURNING_NOT_NULL", InspectionsBundle.message("inspection.data.flow.turn.off.nullable.returning.notnull.quickfix", new Object[0]), false));
        }
        holder.registerProblem((PsiElement)annoName, msg, fixes);
    }

    private static void reportAlwaysFailingCalls(ProblemsHolder holder, DataFlowInstructionVisitor visitor2, HashSet<PsiElement> reportedAnchors) {
        if (ProjectFileIndex.SERVICE.getInstance(holder.getProject()).isInTestSourceContent(holder.getFile().getViewProvider().getVirtualFile())) {
            return;
        }
        visitor2.getAlwaysFailingCalls().forEach((call2, contracts2) -> {
            PsiMethod method = call2.resolveMethod();
            if (method != null && reportedAnchors.add((PsiElement)call2)) {
                holder.registerProblem(DataFlowInspectionBase.getElementToHighlight(call2), DataFlowInspectionBase.getContractMessage(contracts2), new LocalQuickFix[0]);
            }
        });
    }

    @NotNull
    private static String getContractMessage(List<MethodContract> contracts2) {
        if (contracts2.stream().allMatch(mc -> mc.getConditions().stream().allMatch(cv -> cv.isBoundCheckingCondition()))) {
            String string = InspectionsBundle.message("dataflow.message.contract.fail.index", new Object[0]);
            if (string == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = InspectionsBundle.message("dataflow.message.contract.fail", new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PsiCall call2) {
        PsiJavaCodeReferenceElement ref;
        if (call2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(6);
        }
        if (call2 instanceof PsiNewExpression) {
            ref = ((PsiNewExpression)call2).getClassReference();
        } else if (call2 instanceof PsiMethodCallExpression) {
            ref = ((PsiMethodCallExpression)call2).getMethodExpression();
        } else {
            PsiCall psiCall = call2;
            if (psiCall == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(7);
            }
            return psiCall;
        }
        if (ref != null) {
            PsiElement name = ref.getReferenceNameElement();
            PsiElement psiElement = name != null ? name : ref;
            if (psiElement == null) {
                DataFlowInspectionBase.$$$reportNull$$$0(8);
            }
            return psiElement;
        }
        PsiCall psiCall = call2;
        if (psiCall == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(9);
        }
        return psiCall;
    }

    private void reportConstantPushes(StandardDataFlowRunner runner, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (Instruction instruction : runner.getInstructions()) {
            Object constant;
            if (!(instruction instanceof PushInstruction)) continue;
            PsiExpression place = ((PushInstruction)instruction).getPlace();
            DfaValue value = ((PushInstruction)instruction).getValue();
            Object object = constant = value instanceof DfaConstValue ? ((DfaConstValue)value).getValue() : null;
            if (!(place instanceof PsiPolyadicExpression) || !(constant instanceof Boolean) || DataFlowInspectionBase.isFlagCheck(place) || !reportedAnchors.add(place)) continue;
            this.reportConstantCondition(holder, place, (Boolean)constant);
        }
    }

    private static void reportOptionalOfNullableImprovements(ProblemsHolder holder, Set<PsiElement> reportedAnchors, Map<MethodCallInstruction, ThreeState> nullArgs) {
        nullArgs.forEach((call2, nullArg) -> {
            PsiElement arg = call2.getArgumentAnchor(0);
            if (reportedAnchors.add(arg)) {
                switch (nullArg) {
                    case YES: {
                        holder.registerProblem(arg, "Passing <code>null</code> argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithEmptyFix(arg));
                        break;
                    }
                    case NO: {
                        holder.registerProblem(arg, "Passing a non-null argument to <code>Optional</code>", DfaOptionalSupport.createReplaceOptionalOfNullableWithOfFix(arg));
                        break;
                    }
                }
            }
        });
    }

    private void reportConstantReferenceValues(ProblemsHolder holder, StandardInstructionVisitor visitor2, Set<PsiElement> reportedAnchors) {
        for (Pair<PsiReferenceExpression, DfaConstValue> pair : visitor2.getConstantReferenceValues()) {
            PsiReferenceExpression ref = (PsiReferenceExpression)pair.first;
            if (ref.getParent() instanceof PsiReferenceExpression || !reportedAnchors.add(ref)) continue;
            Object value = ((DfaConstValue)pair.second).getValue();
            PsiVariable constant = ((DfaConstValue)pair.second).getConstant();
            String presentableName2 = constant != null ? constant.getName() : String.valueOf(value);
            String exprText = String.valueOf(value);
            if (presentableName2 == null || exprText == null) continue;
            LocalQuickFix[] fixes = new LocalQuickFix[]{new ReplaceWithConstantValueFix(presentableName2, exprText)};
            if (holder.isOnTheFly()) {
                fixes = ArrayUtil.append(fixes, new SetInspectionOptionFix(this, "REPORT_CONSTANT_REFERENCE_VALUES", InspectionsBundle.message("inspection.data.flow.turn.off.constant.references.quickfix", new Object[0]), false));
            }
            holder.registerProblem((PsiElement)ref, "Value <code>#ref</code> #loc is always '" + presentableName2 + "'", fixes);
        }
    }

    private void reportNullableArgumentsPassedToNonAnnotated(DataFlowInstructionVisitor visitor2, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor2.getProblems(NullabilityProblem.passingNullableArgumentToNonAnnotatedParameter)) {
            PsiParameter[] parameters2;
            PsiMethod psiMethod;
            PsiElement gParent;
            int idx;
            if (reportedAnchors.contains(expr)) continue;
            if (expr.getParent() instanceof PsiMethodReferenceExpression) {
                holder.registerProblem(expr.getParent(), "Method reference argument might be null but passed to non annotated parameter", new LocalQuickFix[0]);
                continue;
            }
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? "Passing <code>null</code> argument to non annotated parameter" : "Argument <code>#ref</code> #loc might be null but passed to non annotated parameter";
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            PsiElement parent2 = expr.getParent();
            if (!(parent2 instanceof PsiExpressionList) || (idx = ArrayUtilRt.find(((PsiExpressionList)parent2).getExpressions(), expr)) <= -1 || !((gParent = parent2.getParent()) instanceof PsiCallExpression) || (psiMethod = ((PsiCallExpression)gParent).resolveMethod()) == null || !psiMethod.getManager().isInProject(psiMethod) || !AnnotationUtil.isAnnotatingApplicable(psiMethod) || idx >= (parameters2 = psiMethod.getParameterList().getParameters()).length) continue;
            fixes.add(new AddNullableAnnotationFix(parameters2[idx]));
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            reportedAnchors.add(expr);
        }
    }

    private void reportCallMayProduceNpe(ProblemsHolder holder, PsiMethodCallExpression callExpression) {
        PsiReferenceExpression methodExpression = callExpression.getMethodExpression();
        List<LocalQuickFix> fixes = this.createNPEFixes(methodExpression.getQualifierExpression(), callExpression, holder.isOnTheFly());
        ContainerUtil.addIfNotNull(fixes, ReplaceWithObjectsEqualsFix.createFix(callExpression, methodExpression));
        PsiElement toHighlight = DataFlowInspectionBase.getElementToHighlight(callExpression);
        holder.registerProblem(toHighlight, InspectionsBundle.message("dataflow.message.npe.method.invocation", new Object[0]), fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
    }

    private void reportFieldAccessMayProduceNpe(ProblemsHolder holder, PsiElement elementToAssert, @NotNull PsiExpression expression2) {
        if (expression2 == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(10);
        }
        LocalQuickFix[] fix = this.createNPEFixes((PsiExpression)elementToAssert, expression2, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY);
        if (expression2 instanceof PsiArrayAccessExpression) {
            holder.registerProblem((PsiElement)expression2, InspectionsBundle.message("dataflow.message.npe.array.access", new Object[0]), fix);
        } else {
            assert (elementToAssert != null);
            holder.registerProblem(elementToAssert, expression2.textMatches("null") ? InspectionsBundle.message("dataflow.message.npe.field.access.sure", new Object[0]) : InspectionsBundle.message("dataflow.message.npe.field.access", new Object[0]), fix);
        }
    }

    private static void reportCastMayFail(ProblemsHolder holder, TypeCastInstruction instruction) {
        PsiTypeCastExpression typeCast = instruction.getCastExpression();
        PsiExpression operand = typeCast.getOperand();
        PsiTypeElement castType = typeCast.getCastType();
        assert (castType != null);
        assert (operand != null);
        holder.registerProblem((PsiElement)castType, InspectionsBundle.message("dataflow.message.cce", operand.getText()), new LocalQuickFix[0]);
    }

    private void handleBranchingInstruction(ProblemsHolder holder, StandardInstructionVisitor visitor2, Set<Instruction> trueSet, Set<Instruction> falseSet, HashSet<PsiElement> reportedAnchors, BranchingInstruction instruction) {
        PsiElement psiAnchor = instruction.getPsiAnchor();
        if (instruction instanceof InstanceofInstruction && visitor2.isInstanceofRedundant((InstanceofInstruction)instruction)) {
            if (visitor2.canBeNull((BinopInstruction)instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.redundant.instanceof", new Object[0]), new RedundantInstanceofFix());
            } else {
                LocalQuickFix localQuickFix = DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, true);
                String message = InspectionsBundle.message(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition", Boolean.toString(true));
                holder.registerProblem(psiAnchor, message, localQuickFix);
            }
        } else if (psiAnchor instanceof PsiSwitchLabelStatement) {
            if (falseSet.contains(instruction)) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.unreachable.switch.label", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (psiAnchor != null && !reportedAnchors.contains(psiAnchor) && !DataFlowInspectionBase.isFlagCheck(psiAnchor)) {
            boolean evaluatesToTrue = trueSet.contains(instruction);
            PsiElement parent2 = psiAnchor.getParent();
            if (parent2 instanceof PsiAssignmentExpression && ((PsiAssignmentExpression)parent2).getLExpression() == psiAnchor) {
                holder.registerProblem(psiAnchor, InspectionsBundle.message("dataflow.message.pointless.assignment.expression", Boolean.toString(evaluatesToTrue)), this.createConditionalAssignmentFixes(evaluatesToTrue, (PsiAssignmentExpression)parent2, holder.isOnTheFly()));
            } else {
                this.reportConstantCondition(holder, psiAnchor, evaluatesToTrue);
            }
            reportedAnchors.add(psiAnchor);
        }
    }

    private void reportConstantCondition(ProblemsHolder holder, PsiElement psiAnchor, boolean evaluatesToTrue) {
        if (psiAnchor.getParent() instanceof PsiForeachStatement) {
            if (!evaluatesToTrue) {
                return;
            }
            boolean array = psiAnchor instanceof PsiExpression && ((PsiExpression)psiAnchor).getType() instanceof PsiArrayType;
            holder.registerProblem(psiAnchor, array ? InspectionsBundle.message("dataflow.message.loop.on.empty.array", new Object[0]) : InspectionsBundle.message("dataflow.message.loop.on.empty.collection", new Object[0]), new LocalQuickFix[0]);
        } else {
            boolean isAssertion = DataFlowInspectionBase.isAssertionEffectively(psiAnchor, evaluatesToTrue);
            if (!this.DONT_REPORT_TRUE_ASSERT_STATEMENTS || !isAssertion) {
                ArrayList<SetInspectionOptionFix> fixes = new ArrayList<SetInspectionOptionFix>();
                ContainerUtil.addIfNotNull(fixes, DataFlowInspectionBase.createSimplifyBooleanExpressionFix(psiAnchor, evaluatesToTrue));
                if (isAssertion && holder.isOnTheFly()) {
                    fixes.add(new SetInspectionOptionFix(this, "DONT_REPORT_TRUE_ASSERT_STATEMENTS", InspectionsBundle.message("inspection.data.flow.turn.off.true.asserts.quickfix", new Object[0]), true));
                }
                String message = InspectionsBundle.message(DataFlowInspectionBase.isAtRHSOfBooleanAnd(psiAnchor) ? "dataflow.message.constant.condition.when.reached" : "dataflow.message.constant.condition", Boolean.toString(evaluatesToTrue));
                holder.registerProblem(psiAnchor, message, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
            }
        }
    }

    protected LocalQuickFix[] createConditionalAssignmentFixes(boolean evaluatesToTrue, PsiAssignmentExpression parent2, boolean onTheFly) {
        return LocalQuickFix.EMPTY_ARRAY;
    }

    private static void reportNullableFunctions(DataFlowInstructionVisitor visitor2, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor2.getProblems(NullabilityProblem.nullableFunctionReturn)) {
            if (!reportedAnchors.add(expr)) continue;
            holder.registerProblem(expr, InspectionsBundle.message("dataflow.message.return.nullable.from.notnull.function", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private void reportNullableArguments(DataFlowInstructionVisitor visitor2, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor2.getProblems(NullabilityProblem.passingNullableToNotNullParameter)) {
            if (!reportedAnchors.add(expr)) continue;
            if (expr.getParent() instanceof PsiMethodReferenceExpression) {
                PsiMethodReferenceExpression methodRef = (PsiMethodReferenceExpression)expr.getParent();
                holder.registerProblem((PsiElement)methodRef, InspectionsBundle.message("dataflow.message.passing.nullable.argument.methodref", new Object[0]), this.createMethodReferenceNPEFixes(methodRef).toArray(LocalQuickFix.EMPTY_ARRAY));
                continue;
            }
            String text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.passing.null.argument", new Object[0]) : InspectionsBundle.message("dataflow.message.passing.nullable.argument", new Object[0]);
            List<LocalQuickFix> fixes = this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly());
            holder.registerProblem(expr, text2, fixes.toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private void reportNullableAssignments(DataFlowInstructionVisitor visitor2, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        String text2;
        for (PsiElement expr : visitor2.getProblems(NullabilityProblem.assigningToNotNull)) {
            if (!reportedAnchors.add(expr)) continue;
            assert (expr instanceof PsiExpression);
            text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.assigning.null", new Object[0]) : InspectionsBundle.message("dataflow.message.assigning.nullable", new Object[0]);
            holder.registerProblem(expr, text2, this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY));
        }
        for (PsiElement expr : visitor2.getProblems(NullabilityProblem.storingToNotNullArray)) {
            if (!reportedAnchors.add(expr)) continue;
            assert (expr instanceof PsiExpression);
            text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.storing.array.null", new Object[0]) : InspectionsBundle.message("dataflow.message.storing.array.nullable", new Object[0]);
            holder.registerProblem(expr, text2, this.createNPEFixes((PsiExpression)expr, (PsiExpression)expr, holder.isOnTheFly()).toArray(LocalQuickFix.EMPTY_ARRAY));
        }
    }

    private static void reportUnboxedNullables(DataFlowInstructionVisitor visitor2, ProblemsHolder holder, Set<PsiElement> reportedAnchors) {
        for (PsiElement expr : visitor2.getProblems(NullabilityProblem.unboxingNullable)) {
            if (!reportedAnchors.add(expr)) continue;
            holder.registerProblem(expr, InspectionsBundle.message("dataflow.message.unboxing", new Object[0]), new LocalQuickFix[0]);
        }
    }

    @Nullable
    private static PsiMethod getScopeMethod(PsiElement block) {
        PsiElement parent2 = block.getParent();
        if (parent2 instanceof PsiMethod) {
            return (PsiMethod)parent2;
        }
        if (parent2 instanceof PsiLambdaExpression) {
            return LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)parent2).getFunctionalInterfaceType());
        }
        return null;
    }

    private void reportNullableReturns(DataFlowInstructionVisitor visitor2, ProblemsHolder holder, Set<PsiElement> reportedAnchors, @NotNull PsiElement block) {
        PsiMethod method;
        if (block == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(11);
        }
        if ((method = DataFlowInspectionBase.getScopeMethod(block)) == null || NullableStuffInspectionBase.isNullableNotInferred(method, true)) {
            return;
        }
        PsiAnnotation notNullAnno = NullableNotNullManager.getInstance(method.getProject()).getNotNullAnnotation(method, true);
        if (notNullAnno == null && (!this.SUGGEST_NULLABLE_ANNOTATIONS || block.getParent() instanceof PsiLambdaExpression)) {
            return;
        }
        PsiType returnType = method.getReturnType();
        if (block instanceof PsiExpression && block.getParent() instanceof PsiLambdaExpression && PsiType.VOID.equals(returnType)) {
            return;
        }
        if (returnType == null || returnType.equalsToText("java.lang.Void")) {
            return;
        }
        for (PsiElement statement2 : visitor2.getProblems(NullabilityProblem.nullableReturn)) {
            LocalQuickFix[] localQuickFixArray;
            String text2;
            assert (statement2 instanceof PsiExpression);
            PsiExpression expr = (PsiExpression)statement2;
            if (!reportedAnchors.add(expr)) continue;
            if (notNullAnno != null) {
                String presentable = NullableStuffInspectionBase.getPresentableAnnoName(notNullAnno);
                String text3 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.return.null.from.notnull", presentable) : InspectionsBundle.message("dataflow.message.return.nullable.from.notnull", presentable);
                holder.registerProblem((PsiElement)expr, text3, new LocalQuickFix[0]);
                continue;
            }
            if (!AnnotationUtil.isAnnotatingApplicable(statement2)) continue;
            NullableNotNullManager manager = NullableNotNullManager.getInstance(expr.getProject());
            String defaultNullable = manager.getDefaultNullable();
            String presentableNullable = StringUtil.getShortName(defaultNullable);
            String string = text2 = DataFlowInspectionBase.isNullLiteralExpression(expr) ? InspectionsBundle.message("dataflow.message.return.null.from.notnullable", presentableNullable) : InspectionsBundle.message("dataflow.message.return.nullable.from.notnullable", presentableNullable);
            if (PsiTreeUtil.getParentOfType((PsiElement)expr, PsiMethod.class, PsiLambdaExpression.class) instanceof PsiLambdaExpression) {
                localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
            } else {
                LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                localQuickFixArray = localQuickFixArray2;
                localQuickFixArray2[0] = new AnnotateMethodFix(defaultNullable, ArrayUtil.toStringArray(manager.getNotNulls()));
            }
            LocalQuickFix[] fixes = localQuickFixArray;
            holder.registerProblem((PsiElement)expr, text2, fixes);
        }
    }

    private static boolean isAssertionEffectively(PsiElement psiAnchor, boolean evaluatesToTrue) {
        PsiStatement thenBranch;
        PsiElement parent2 = PsiUtil.skipParenthesizedExprUp(psiAnchor.getParent());
        if (parent2 instanceof PsiAssertStatement) {
            return evaluatesToTrue;
        }
        if (parent2 instanceof PsiIfStatement && psiAnchor == ((PsiIfStatement)parent2).getCondition() && (thenBranch = ControlFlowUtils.stripBraces(((PsiIfStatement)parent2).getThenBranch())) instanceof PsiThrowStatement) {
            return !evaluatesToTrue;
        }
        return false;
    }

    private static boolean isAtRHSOfBooleanAnd(PsiElement expr) {
        PsiElement cur = expr;
        while (cur != null && !(cur instanceof PsiMember)) {
            PsiElement parent2 = cur.getParent();
            if (parent2 instanceof PsiBinaryExpression && cur == ((PsiBinaryExpression)parent2).getROperand()) {
                return true;
            }
            cur = parent2;
        }
        return false;
    }

    private static boolean isFlagCheck(PsiElement element) {
        PsiExpression topExpression;
        Object scope = PsiTreeUtil.getParentOfType(element, PsiStatement.class, PsiVariable.class);
        PsiExpression psiExpression = scope instanceof PsiIfStatement ? ((PsiIfStatement)scope).getCondition() : (topExpression = scope instanceof PsiVariable ? ((PsiVariable)scope).getInitializer() : null);
        if (!PsiTreeUtil.isAncestor(topExpression, element, false)) {
            return false;
        }
        return StreamEx.ofTree((Object)topExpression, e -> StreamEx.of((Object[])e.getChildren())).anyMatch(DataFlowInspectionBase::isCompileTimeFlagCheck);
    }

    private static boolean isCompileTimeFlagCheck(PsiElement element) {
        PsiBinaryExpression binOp;
        if (element instanceof PsiBinaryExpression && ComparisonUtils.isComparisonOperation((binOp = (PsiBinaryExpression)element).getOperationTokenType())) {
            PsiBinaryExpression subOp;
            PsiExpression comparedWith = null;
            if (ExpressionUtils.isLiteral(binOp.getROperand())) {
                comparedWith = binOp.getLOperand();
            } else if (ExpressionUtils.isLiteral(binOp.getLOperand())) {
                comparedWith = binOp.getROperand();
            }
            comparedWith = PsiUtil.skipParenthesizedExprDown(comparedWith);
            if (DataFlowInspectionBase.isConstantOfType(comparedWith, PsiType.INT, PsiType.LONG)) {
                return true;
            }
            if (comparedWith instanceof PsiBinaryExpression && (subOp = (PsiBinaryExpression)comparedWith).getOperationTokenType().equals(JavaTokenType.AND)) {
                PsiExpression left = PsiUtil.skipParenthesizedExprDown(subOp.getLOperand());
                PsiExpression right = PsiUtil.skipParenthesizedExprDown(subOp.getROperand());
                if (DataFlowInspectionBase.isConstantOfType(left, PsiType.INT, PsiType.LONG) || DataFlowInspectionBase.isConstantOfType(right, PsiType.INT, PsiType.LONG)) {
                    return true;
                }
            }
        }
        return DataFlowInspectionBase.isConstantOfType(element, PsiType.BOOLEAN);
    }

    private static boolean isConstantOfType(PsiElement element, PsiPrimitiveType ... types) {
        PsiElement resolved;
        PsiElement psiElement = resolved = element instanceof PsiReferenceExpression ? ((PsiReferenceExpression)element).resolve() : null;
        if (!(resolved instanceof PsiField)) {
            return false;
        }
        PsiVariable field = (PsiVariable)resolved;
        return field.hasModifierProperty("static") && PsiUtil.isCompileTimeConstant(field) && ArrayUtil.contains(field.getType(), types);
    }

    private static boolean isNullLiteralExpression(PsiElement expr) {
        if (expr instanceof PsiLiteralExpression) {
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            return PsiType.NULL.equals(literalExpression.getType());
        }
        return false;
    }

    @Nullable
    private static LocalQuickFix createSimplifyBooleanExpressionFix(PsiElement element, final boolean value) {
        SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(element, value);
        if (fix == null) {
            return null;
        }
        final String text2 = fix.getText();
        return new LocalQuickFix(){

            @Override
            @NotNull
            public String getName() {
                String string = text2;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PsiElement psiElement;
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((psiElement = descriptor2.getPsiElement()) == null) {
                    return;
                }
                SimplifyBooleanExpressionFix fix = DataFlowInspectionBase.createIntention(psiElement, value);
                if (fix == null) {
                    return;
                }
                try {
                    LOG.assertTrue(psiElement.isValid());
                    fix.applyFix();
                }
                catch (IncorrectOperationException e) {
                    LOG.error(e);
                }
            }

            @Override
            @NotNull
            public String getFamilyName() {
                String string = InspectionsBundle.message("inspection.data.flow.simplify.boolean.expression.quickfix", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(3);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase$2";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    protected static LocalQuickFix createSimplifyToAssignmentFix() {
        SimplifyToAssignmentFix simplifyToAssignmentFix = new SimplifyToAssignmentFix();
        if (simplifyToAssignmentFix == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(12);
        }
        return simplifyToAssignmentFix;
    }

    private static SimplifyBooleanExpressionFix createIntention(PsiElement element, boolean value) {
        if (!(element instanceof PsiExpression)) {
            return null;
        }
        if (PsiTreeUtil.findChildOfType(element, PsiAssignmentExpression.class) != null) {
            return null;
        }
        PsiExpression expression2 = (PsiExpression)element;
        while (element.getParent() instanceof PsiExpression) {
            element = element.getParent();
        }
        SimplifyBooleanExpressionFix fix = new SimplifyBooleanExpressionFix(expression2, value);
        if (!fix.isAvailable() || SimplifyBooleanExpressionFix.canBeSimplified((PsiExpression)element)) {
            return null;
        }
        return fix;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.data.flow.display.name", new Object[0]);
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(13);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            DataFlowInspectionBase.$$$reportNull$$$0(15);
        }
        return SHORT_NAME;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowInspectionBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createNPEFixes";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getContractMessage";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createSimplifyToAssignmentFix";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportFieldAccessMayProduceNpe";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "reportNullableReturns";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DataFlowInstructionVisitor
    extends StandardInstructionVisitor {
        private final MultiMap<NullabilityProblem, PsiElement> myProblems = new MultiMap();
        private final Map<Pair<NullabilityProblem, PsiElement>, StateInfo> myStateInfos = ContainerUtil.newHashMap();
        private final Set<Instruction> myCCEInstructions = ContainerUtil.newHashSet();
        private final Map<MethodCallInstruction, Boolean> myFailingCalls = new HashMap<MethodCallInstruction, Boolean>();
        private final Map<PsiMethodCallExpression, ThreeState> myOptionalCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
        private final Map<PsiMethodCallExpression, ThreeState> myBooleanCalls = new HashMap<PsiMethodCallExpression, ThreeState>();
        private final Map<MethodCallInstruction, ThreeState> myOfNullableCalls = new HashMap<MethodCallInstruction, ThreeState>();
        private final Map<PsiMethodReferenceExpression, DfaValue> myMethodReferenceResults = new HashMap<PsiMethodReferenceExpression, DfaValue>();
        private final Map<PsiArrayAccessExpression, ThreeState> myOutOfBoundsArrayAccesses = new HashMap<PsiArrayAccessExpression, ThreeState>();
        private final List<PsiExpression> myOptionalQualifiers = new ArrayList<PsiExpression>();
        private boolean myAlwaysReturnsNotNull = true;

        private DataFlowInstructionVisitor() {
        }

        @Override
        protected void onInstructionProducesCCE(TypeCastInstruction instruction) {
            this.myCCEInstructions.add(instruction);
        }

        Collection<PsiElement> getProblems(NullabilityProblem kind) {
            return ContainerUtil.filter(this.myProblems.get(kind), psiElement -> {
                StateInfo info = this.myStateInfos.get(Pair.create(kind, psiElement));
                return info.normalNpe || info.ephemeralNpe && !info.normalOk;
            });
        }

        Map<PsiMethodCallExpression, ThreeState> getOptionalCalls() {
            return this.myOptionalCalls;
        }

        Map<MethodCallInstruction, ThreeState> getOfNullableCalls() {
            return this.myOfNullableCalls;
        }

        Map<PsiMethodCallExpression, ThreeState> getBooleanCalls() {
            return this.myBooleanCalls;
        }

        Map<PsiMethodReferenceExpression, DfaValue> getMethodReferenceResults() {
            return this.myMethodReferenceResults;
        }

        Stream<PsiArrayAccessExpression> outOfBoundsArrayAccesses() {
            return StreamEx.ofKeys(this.myOutOfBoundsArrayAccesses, ThreeState.YES::equals);
        }

        List<PsiExpression> getOptionalQualifiers() {
            return this.myOptionalQualifiers;
        }

        Map<PsiCall, List<MethodContract>> getAlwaysFailingCalls() {
            return StreamEx.ofKeys(this.myFailingCalls, v -> v).mapToEntry(MethodCallInstruction::getCallExpression, MethodCallInstruction::getContracts).toMap();
        }

        boolean isAlwaysReturnsNotNull(Instruction[] instructions) {
            return this.myAlwaysReturnsNotNull && ContainerUtil.exists(instructions, i -> i instanceof ReturnInstruction && ((ReturnInstruction)i).getAnchor() instanceof PsiReturnStatement);
        }

        @Override
        public DfaInstructionState[] visitMethodCall(MethodCallInstruction instruction, DataFlowRunner runner, DfaMemoryState memState) {
            PsiMethodCallExpression call2 = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
            if (call2 != null) {
                String methodName = call2.getMethodExpression().getReferenceName();
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown(call2.getMethodExpression().getQualifierExpression());
                if (qualifier != null && TypeUtils.isOptional(qualifier.getType())) {
                    if ("isPresent".equals(methodName) && qualifier instanceof PsiMethodCallExpression) {
                        this.myOptionalQualifiers.add(qualifier);
                    } else if (DfaOptionalSupport.isOptionalGetMethodName(methodName)) {
                        Boolean fact = memState.getValueFact(DfaFactType.OPTIONAL_PRESENCE, memState.peek());
                        ThreeState state2 = fact == null ? ThreeState.UNSURE : ThreeState.fromBoolean(fact);
                        this.myOptionalCalls.merge(call2, state2, ThreeState::merge);
                    }
                }
            }
            if (instruction.matches(DfaOptionalSupport.OPTIONAL_OF_NULLABLE)) {
                DfaValue arg = memState.peek();
                ThreeState nullArg = memState.isNull(arg) ? ThreeState.YES : (memState.isNotNull(arg) ? ThreeState.NO : ThreeState.UNSURE);
                this.myOfNullableCalls.merge(instruction, nullArg, ThreeState::merge);
            }
            DfaInstructionState[] states = super.visitMethodCall(instruction, runner, memState);
            if (DataFlowInstructionVisitor.hasNonTrivialFailingContracts(instruction)) {
                DfaConstValue fail = runner.getFactory().getConstFactory().getContractFail();
                boolean allFail = Arrays.stream(states).allMatch(s -> s.getMemoryState().peek() == fail);
                this.myFailingCalls.merge(instruction, allFail, Boolean::logicalAnd);
            }
            this.handleBooleanCalls(instruction, states);
            return states;
        }

        void handleBooleanCalls(MethodCallInstruction instruction, DfaInstructionState[] states) {
            if (!DataFlowInstructionVisitor.hasNonTrivialBooleanContracts(instruction)) {
                return;
            }
            PsiMethod method = instruction.getTargetMethod();
            if (method == null || !ControlFlowAnalyzer.isPure(method)) {
                return;
            }
            PsiMethodCallExpression call2 = ObjectUtils.tryCast(instruction.getCallExpression(), PsiMethodCallExpression.class);
            if (call2 == null || this.myBooleanCalls.get(call2) == ThreeState.UNSURE) {
                return;
            }
            PsiElement parent2 = call2.getParent();
            if (parent2 instanceof PsiExpressionStatement) {
                return;
            }
            if (parent2 instanceof PsiLambdaExpression && PsiType.VOID.equals(LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)parent2))) {
                return;
            }
            for (DfaInstructionState s : states) {
                Object value;
                DfaValue val = s.getMemoryState().peek();
                ThreeState state2 = ThreeState.UNSURE;
                if (val instanceof DfaConstValue && (value = ((DfaConstValue)val).getValue()) instanceof Boolean) {
                    state2 = ThreeState.fromBoolean((Boolean)value);
                }
                this.myBooleanCalls.merge(call2, state2, ThreeState::merge);
            }
        }

        @Override
        protected void processArrayAccess(PsiArrayAccessExpression expression2, boolean alwaysOutOfBounds) {
            this.myOutOfBoundsArrayAccesses.merge(expression2, ThreeState.fromBoolean(alwaysOutOfBounds), ThreeState::merge);
        }

        @Override
        protected void processMethodReferenceResult(PsiMethodReferenceExpression methodRef, List<? extends MethodContract> contracts2, DfaValue res2) {
            if (contracts2.isEmpty() || !contracts2.get(0).isTrivial()) {
                this.myMethodReferenceResults.merge(methodRef, res2, (a, b) -> a == b ? a : DfaUnknownValue.getInstance());
            }
        }

        private static boolean hasNonTrivialFailingContracts(MethodCallInstruction instruction) {
            List<MethodContract> contracts2 = instruction.getContracts();
            return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> contract.getReturnValue() == MethodContract.ValueConstraint.THROW_EXCEPTION && !contract.isTrivial());
        }

        private static boolean hasNonTrivialBooleanContracts(MethodCallInstruction instruction) {
            if (CustomMethodHandlers.find(instruction) != null) {
                return true;
            }
            List<MethodContract> contracts2 = instruction.getContracts();
            return !contracts2.isEmpty() && contracts2.stream().anyMatch(contract -> (contract.getReturnValue() == MethodContract.ValueConstraint.FALSE_VALUE || contract.getReturnValue() == MethodContract.ValueConstraint.TRUE_VALUE) && !contract.isTrivial());
        }

        @Override
        protected boolean checkNotNullable(DfaMemoryState state2, DfaValue value, NullabilityProblem problem, PsiElement anchor2) {
            boolean ok;
            if (problem == NullabilityProblem.nullableReturn && !state2.isNotNull(value)) {
                this.myAlwaysReturnsNotNull = false;
            }
            if (!(ok = super.checkNotNullable(state2, value, problem, anchor2)) && anchor2 != null) {
                if (!(problem != NullabilityProblem.callNPE || anchor2 instanceof PsiNewExpression || anchor2 instanceof PsiMethodReferenceExpression || anchor2 instanceof PsiMethodCallExpression)) {
                    throw new IllegalArgumentException("Invalid anchor for callNPE problem: " + anchor2);
                }
                this.myProblems.putValue(problem, anchor2);
            }
            Pair<NullabilityProblem, PsiElement> key = Pair.create(problem, anchor2);
            StateInfo info = this.myStateInfos.computeIfAbsent(key, k -> new StateInfo());
            if (state2.isEphemeral() && !ok) {
                info.ephemeralNpe = true;
            } else if (!state2.isEphemeral()) {
                if (ok) {
                    info.normalOk = true;
                } else {
                    info.normalNpe = true;
                }
            }
            return ok;
        }

        private static class StateInfo {
            boolean ephemeralNpe;
            boolean normalNpe;
            boolean normalOk;

            private StateInfo() {
            }
        }
    }
}

