/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaMemoryStateImpl;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.DfaUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StateQueue;
import com.intellij.codeInspection.dataFlow.instructions.BranchingInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataFlowRunner {
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.dataFlow.DataFlowRunner");
    private Instruction[] myInstructions;
    private final MultiMap<PsiElement, DfaMemoryState> myNestedClosures = new MultiMap();
    @NotNull
    private final DfaValueFactory myValueFactory;
    private boolean myInlining = true;
    static final int MAX_STATES_PER_BRANCH = 300;

    protected DataFlowRunner() {
        this(false, true);
    }

    protected DataFlowRunner(boolean unknownMembersAreNullable, boolean honorFieldInitializers) {
        this.myValueFactory = new DfaValueFactory(honorFieldInitializers, unknownMembersAreNullable);
    }

    @NotNull
    public DfaValueFactory getFactory() {
        DfaValueFactory dfaValueFactory = this.myValueFactory;
        if (dfaValueFactory == null) {
            DataFlowRunner.$$$reportNull$$$0(0);
        }
        return dfaValueFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Collection<DfaMemoryState> createInitialStates(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor2) {
        PsiElement block;
        Object container2;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(1);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(2);
        }
        if ((container2 = PsiTreeUtil.getParentOfType(psiBlock, PsiClass.class, PsiLambdaExpression.class)) != null && (!(container2 instanceof PsiClass) || PsiUtil.isLocalOrAnonymousClass((PsiClass)container2)) && (block = DfaPsiUtil.getTopmostBlockInSameClass(container2.getParent())) != null) {
            Collection<DfaMemoryState> closureStates;
            RunnerResult result2;
            try {
                this.myInlining = false;
                result2 = this.analyzeMethod(block, visitor2);
            }
            finally {
                this.myInlining = true;
            }
            if (result2 == RunnerResult.OK && !(closureStates = this.myNestedClosures.get(DfaPsiUtil.getTopmostBlockInSameClass(psiBlock))).isEmpty()) {
                return closureStates;
            }
            return null;
        }
        return Collections.singletonList(this.createMemoryState());
    }

    @NotNull
    public final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor2) {
        Collection<DfaMemoryState> initialStates;
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(3);
        }
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(4);
        }
        RunnerResult runnerResult = (initialStates = this.createInitialStates(psiBlock, visitor2)) == null ? RunnerResult.NOT_APPLICABLE : this.analyzeMethod(psiBlock, visitor2, false, initialStates);
        if (runnerResult == null) {
            DataFlowRunner.$$$reportNull$$$0(5);
        }
        return runnerResult;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    final RunnerResult analyzeMethod(@NotNull PsiElement psiBlock, @NotNull InstructionVisitor visitor, boolean ignoreAssertions, @NotNull Collection<DfaMemoryState> initialStates) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 10[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private static DfaValue makeInitialValue(DfaVariableValue var, PsiElement block) {
        if (var.getQualifier() != null) {
            return null;
        }
        PsiField field = ObjectUtils.tryCast(var.getPsiVariable(), PsiField.class);
        if (field == null || DfaUtil.hasInitializationHacks(field)) {
            return null;
        }
        return DfaUtil.getPossiblyNonInitializedValue(var.getFactory(), field, block);
    }

    private static boolean containsState(Collection<DfaMemoryState> processed2, DfaInstructionState instructionState) {
        if (processed2.contains(instructionState.getMemoryState())) {
            return true;
        }
        for (DfaMemoryState state2 : processed2) {
            if (!((DfaMemoryStateImpl)state2).isSuperStateOf((DfaMemoryStateImpl)instructionState.getMemoryState())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private void handleStepOutOfLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> processedStates, @NotNull MultiMap<BranchingInstruction, DfaMemoryState> incomingStates, @NotNull List<DfaInstructionState> inFlightStates, @NotNull DfaInstructionState[] afterStates, @NotNull StateQueue queue) {
        void var11_15;
        if (prevInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(15);
        }
        if (nextInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(16);
        }
        if (loopNumber == null) {
            DataFlowRunner.$$$reportNull$$$0(17);
        }
        if (processedStates == null) {
            DataFlowRunner.$$$reportNull$$$0(18);
        }
        if (incomingStates == null) {
            DataFlowRunner.$$$reportNull$$$0(19);
        }
        if (inFlightStates == null) {
            DataFlowRunner.$$$reportNull$$$0(20);
        }
        if (afterStates == null) {
            DataFlowRunner.$$$reportNull$$$0(21);
        }
        if (queue == null) {
            DataFlowRunner.$$$reportNull$$$0(22);
        }
        if (loopNumber[prevInstruction.getIndex()] == 0 || DataFlowRunner.inSameLoop(prevInstruction, nextInstruction, loopNumber)) {
            return;
        }
        for (DfaInstructionState state3 : inFlightStates) {
            Instruction instruction = state3.getInstruction();
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) continue;
            return;
        }
        DfaInstructionState[] dfaInstructionStateArray = afterStates;
        int n = dfaInstructionStateArray.length;
        boolean bl = false;
        while (var11_15 < n) {
            DfaInstructionState state4 = dfaInstructionStateArray[var11_15];
            Instruction instruction = state4.getInstruction();
            if (DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber)) {
                return;
            }
            ++var11_15;
        }
        if (!queue.processAll(state2 -> {
            Instruction instruction;
            if (prevInstruction == null) {
                DataFlowRunner.$$$reportNull$$$0(38);
            }
            if (loopNumber == null) {
                DataFlowRunner.$$$reportNull$$$0(39);
            }
            return !DataFlowRunner.inSameLoop(prevInstruction, instruction = state2.getInstruction(), loopNumber);
        })) {
            return;
        }
        THashSet<BranchingInstruction> mayRemoveStatesFor = new THashSet<BranchingInstruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!DataFlowRunner.inSameLoop(prevInstruction, instruction, loopNumber) || !(instruction instanceof BranchingInstruction)) continue;
            mayRemoveStatesFor.add((BranchingInstruction)instruction);
        }
        for (Instruction instruction : mayRemoveStatesFor) {
            processedStates.remove((BranchingInstruction)instruction);
            incomingStates.remove((BranchingInstruction)instruction);
        }
    }

    private static boolean inSameLoop(@NotNull Instruction prevInstruction, @NotNull Instruction nextInstruction, @NotNull int[] loopNumber) {
        if (prevInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(23);
        }
        if (nextInstruction == null) {
            DataFlowRunner.$$$reportNull$$$0(24);
        }
        if (loopNumber == null) {
            DataFlowRunner.$$$reportNull$$$0(25);
        }
        return loopNumber[nextInstruction.getIndex()] == loopNumber[prevInstruction.getIndex()];
    }

    @NotNull
    protected DfaInstructionState[] acceptInstruction(@NotNull InstructionVisitor visitor2, @NotNull DfaInstructionState instructionState) {
        if (visitor2 == null) {
            DataFlowRunner.$$$reportNull$$$0(26);
        }
        if (instructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(27);
        }
        Instruction instruction = instructionState.getInstruction();
        DfaInstructionState[] states = instruction.accept(this, instructionState.getMemoryState(), visitor2);
        PsiElement closure = DfaUtil.getClosureInside(instruction);
        if (closure instanceof PsiClass) {
            this.registerNestedClosures(instructionState, (PsiClass)closure);
        } else if (closure instanceof PsiLambdaExpression) {
            this.registerNestedClosures(instructionState, (PsiLambdaExpression)closure);
        }
        if (states == null) {
            DataFlowRunner.$$$reportNull$$$0(28);
        }
        return states;
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiClass nestedClass) {
        if (instructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(29);
        }
        if (nestedClass == null) {
            DataFlowRunner.$$$reportNull$$$0(30);
        }
        DfaMemoryState state2 = instructionState.getMemoryState();
        for (PsiMethod psiMethod : nestedClass.getMethods()) {
            PsiCodeBlock body = psiMethod.getBody();
            if (body == null) continue;
            this.createClosureState(body, state2);
        }
        for (PsiMember psiMember : nestedClass.getInitializers()) {
            this.createClosureState(psiMember.getBody(), state2);
        }
        for (PsiMember psiMember : nestedClass.getFields()) {
            this.createClosureState(psiMember, state2);
        }
    }

    private void registerNestedClosures(@NotNull DfaInstructionState instructionState, @NotNull PsiLambdaExpression expr) {
        if (instructionState == null) {
            DataFlowRunner.$$$reportNull$$$0(31);
        }
        if (expr == null) {
            DataFlowRunner.$$$reportNull$$$0(32);
        }
        DfaMemoryState state2 = instructionState.getMemoryState();
        PsiElement body = expr.getBody();
        if (body != null) {
            this.createClosureState(body, state2);
        }
    }

    private void createClosureState(PsiElement anchor2, DfaMemoryState state2) {
        this.myNestedClosures.putValue(anchor2, state2.createClosureState());
    }

    @NotNull
    protected DfaMemoryState createMemoryState() {
        DfaMemoryStateImpl dfaMemoryStateImpl = new DfaMemoryStateImpl(this.myValueFactory);
        if (dfaMemoryStateImpl == null) {
            DataFlowRunner.$$$reportNull$$$0(33);
        }
        return dfaMemoryStateImpl;
    }

    @NotNull
    public Instruction[] getInstructions() {
        if (this.myInstructions == null) {
            DataFlowRunner.$$$reportNull$$$0(34);
        }
        return this.myInstructions;
    }

    @NotNull
    public Instruction getInstruction(int index2) {
        Instruction instruction = this.myInstructions[index2];
        if (instruction == null) {
            DataFlowRunner.$$$reportNull$$$0(35);
        }
        return instruction;
    }

    @NotNull
    MultiMap<PsiElement, DfaMemoryState> getNestedClosures() {
        MultiMap<PsiElement, DfaMemoryState> multiMap = new MultiMap<PsiElement, DfaMemoryState>(this.myNestedClosures);
        if (multiMap == null) {
            DataFlowRunner.$$$reportNull$$$0(36);
        }
        return multiMap;
    }

    @NotNull
    public Pair<Set<Instruction>, Set<Instruction>> getConstConditionalExpressions() {
        BranchingInstruction branchingInstruction;
        HashSet<BranchingInstruction> trueSet = new HashSet<BranchingInstruction>();
        HashSet<BranchingInstruction> falseSet = new HashSet<BranchingInstruction>();
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction) || (branchingInstruction = (BranchingInstruction)instruction).getPsiAnchor() == null || !branchingInstruction.isConditionConst()) continue;
            if (!branchingInstruction.isTrueReachable()) {
                falseSet.add(branchingInstruction);
            }
            if (branchingInstruction.isFalseReachable()) continue;
            trueSet.add(branchingInstruction);
        }
        for (Instruction instruction : this.myInstructions) {
            if (!(instruction instanceof BranchingInstruction)) continue;
            branchingInstruction = (BranchingInstruction)instruction;
            if (branchingInstruction.isTrueReachable()) {
                falseSet.remove(branchingInstruction);
            }
            if (!branchingInstruction.isFalseReachable()) continue;
            trueSet.remove(branchingInstruction);
        }
        Pair<Set<Instruction>, Set<Instruction>> pair = Pair.create(trueSet, falseSet);
        if (pair == null) {
            DataFlowRunner.$$$reportNull$$$0(37);
        }
        return pair;
    }

    private static /* synthetic */ DfaValue lambda$analyzeMethod$0(@NotNull PsiElement psiBlock, DfaVariableValue var) {
        if (psiBlock == null) {
            DataFlowRunner.$$$reportNull$$$0(40);
        }
        return DataFlowRunner.makeInitialValue(var, psiBlock);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/DataFlowRunner";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiBlock";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialStates";
                break;
            }
            case 15: 
            case 23: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prevInstruction";
                break;
            }
            case 16: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nextInstruction";
                break;
            }
            case 17: 
            case 25: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loopNumber";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processedStates";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "incomingStates";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inFlightStates";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterStates";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionState";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nestedClass";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/DataFlowRunner";
                break;
            }
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "analyzeMethod";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "acceptInstruction";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createMemoryState";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstructions";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstruction";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getNestedClosures";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstConditionalExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createInitialStates";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "analyzeMethod";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "handleStepOutOfLoop";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inSameLoop";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "acceptInstruction";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "registerNestedClosures";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$handleStepOutOfLoop$1";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$analyzeMethod$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

