/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractValue;
import com.intellij.codeInspection.dataFlow.DfaOptionalSupport;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.SpecialField;
import com.intellij.codeInspection.dataFlow.StandardMethodContract;
import com.intellij.codeInspection.dataFlow.value.DfaRelationValue;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HardcodedContracts {
    private static final Pattern FIRST_OR_LAST = Pattern.compile("first|last");
    private static final Pattern CONTAINS_KEY_VALUE = Pattern.compile("containsKey|containsValue");
    private static final Pattern ARRAY_RANGED_METHODS = Pattern.compile("binarySearch|fill|parallelPrefix|parallelSort|sort|spliterator|stream");
    private static final List<MethodContract> ARRAY_RANGE_CONTRACTS = ContainerUtil.immutableList(HardcodedContracts.nonnegativeArgumentContract(1), HardcodedContracts.nonnegativeArgumentContract(2), MethodContract.singleConditionContract(ContractValue.argument(1), DfaRelationValue.RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.singleConditionContract(ContractValue.argument(2), DfaRelationValue.RelationType.GT, ContractValue.argument(0).specialField(SpecialField.ARRAY_LENGTH), MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.singleConditionContract(ContractValue.argument(1), DfaRelationValue.RelationType.GT, ContractValue.argument(2), MethodContract.ValueConstraint.THROW_EXCEPTION));

    public static List<MethodContract> getHardcodedContracts(@NotNull PsiMethod method, @Nullable PsiMethodCallExpression call2) {
        PsiClass owner;
        if (method == null) {
            HardcodedContracts.$$$reportNull$$$0(0);
        }
        if ((owner = method.getContainingClass()) == null || InjectedLanguageManager.getInstance(owner.getProject()).isInjectedFragment(owner.getContainingFile())) {
            return Collections.emptyList();
        }
        int paramCount = method.getParameterList().getParametersCount();
        String className2 = owner.getQualifiedName();
        if (className2 == null) {
            return Collections.emptyList();
        }
        String methodName = method.getName();
        if ("java.lang.System".equals(className2)) {
            if ("exit".equals(methodName)) {
                return Collections.singletonList(new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("com.google.common.base.Preconditions".equals(className2)) {
            if ("checkNotNull".equals(methodName) && paramCount > 0) {
                return HardcodedContracts.failIfNull(0, paramCount);
            }
            if (("checkArgument".equals(methodName) || "checkState".equals(methodName)) && paramCount > 0) {
                MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        } else if ("java.util.Objects".equals(className2)) {
            if ("requireNonNull".equals(methodName) && paramCount > 0) {
                return HardcodedContracts.failIfNull(0, paramCount);
            }
        } else if ("java.lang.String".equals(className2)) {
            if (("charAt".equals(methodName) || "codePointAt".equals(methodName)) && paramCount == 1) {
                return Arrays.asList(HardcodedContracts.nonnegativeArgumentContract(0), HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LT, SpecialField.STRING_LENGTH));
            }
            if (("substring".equals(methodName) || "subSequence".equals(methodName)) && paramCount <= 2) {
                ArrayList<MethodContract> contracts2 = new ArrayList<MethodContract>(5);
                contracts2.add(HardcodedContracts.nonnegativeArgumentContract(0));
                contracts2.add(HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LE, SpecialField.STRING_LENGTH));
                if (paramCount == 2) {
                    contracts2.add(HardcodedContracts.nonnegativeArgumentContract(1));
                    contracts2.add(HardcodedContracts.specialFieldRangeContract(1, DfaRelationValue.RelationType.LE, SpecialField.STRING_LENGTH));
                    contracts2.add(MethodContract.singleConditionContract(ContractValue.argument(0), DfaRelationValue.RelationType.LE.getNegated(), ContractValue.argument(1), MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
                return contracts2;
            }
            if ("isEmpty".equals(methodName) && paramCount == 0) {
                return SpecialField.STRING_LENGTH.getEmptyContracts();
            }
        } else {
            if (MethodUtils.methodMatches(method, "java.util.Collection", (PsiType)PsiType.BOOLEAN, "isEmpty", new PsiType[0])) {
                return SpecialField.COLLECTION_SIZE.getEmptyContracts();
            }
            if (MethodUtils.methodMatches(method, "java.util.Collection", (PsiType)PsiType.BOOLEAN, "contains", new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.Set", (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{null}) || MethodUtils.methodMatches(method, "java.util.List", (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(SpecialField.COLLECTION_SIZE), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.List", null, "get", PsiType.INT)) {
                return Arrays.asList(HardcodedContracts.nonnegativeArgumentContract(0), HardcodedContracts.specialFieldRangeContract(0, DfaRelationValue.RelationType.LT, SpecialField.COLLECTION_SIZE));
            }
            if (MethodUtils.methodMatches(method, "java.util.SortedSet", null, FIRST_OR_LAST, new PsiType[0])) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.COLLECTION_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
            if (MethodUtils.methodMatches(method, "java.util.Map", (PsiType)PsiType.BOOLEAN, "isEmpty", new PsiType[0])) {
                return SpecialField.MAP_SIZE.getEmptyContracts();
            }
            if (MethodUtils.methodMatches(method, "java.util.Map", (PsiType)PsiType.BOOLEAN, CONTAINS_KEY_VALUE, new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.MAP_SIZE), DfaRelationValue.RelationType.EQ, ContractValue.zero(), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.Map", (PsiType)PsiType.BOOLEAN, "equals", new PsiType[]{null})) {
                return Collections.singletonList(MethodContract.singleConditionContract(ContractValue.qualifier().specialField(SpecialField.MAP_SIZE), DfaRelationValue.RelationType.NE, ContractValue.argument(0).specialField(SpecialField.MAP_SIZE), MethodContract.ValueConstraint.FALSE_VALUE));
            }
            if (MethodUtils.methodMatches(method, "java.util.Arrays", null, ARRAY_RANGED_METHODS, (PsiType[])null) && paramCount >= 3) {
                return ARRAY_RANGE_CONTRACTS;
            }
            if ("org.apache.commons.lang.Validate".equals(className2) || "org.apache.commons.lang3.Validate".equals(className2) || "org.springframework.util.Assert".equals(className2)) {
                if (("isTrue".equals(methodName) || "state".equals(methodName)) && paramCount > 0) {
                    MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                    constraints[0] = MethodContract.ValueConstraint.FALSE_VALUE;
                    return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
                if ("notNull".equals(methodName) && paramCount > 0) {
                    MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
                    constraints[0] = MethodContract.ValueConstraint.NULL_VALUE;
                    return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
            } else {
                if (HardcodedContracts.isJunit(className2) || HardcodedContracts.isTestng(className2) || className2.startsWith("com.google.common.truth.") || className2.startsWith("org.assertj.core.api.")) {
                    return HardcodedContracts.handleTestFrameworks(paramCount, className2, methodName, call2);
                }
                if (TypeUtils.isOptional(owner)) {
                    if (DfaOptionalSupport.isOptionalGetMethodName(methodName) || "orElseThrow".equals(methodName)) {
                        return Arrays.asList(HardcodedContracts.optionalAbsentContract(MethodContract.ValueConstraint.THROW_EXCEPTION), MethodContract.trivialContract(MethodContract.ValueConstraint.NOT_NULL_VALUE));
                    }
                    if ("isPresent".equals(methodName)) {
                        return Arrays.asList(HardcodedContracts.optionalAbsentContract(MethodContract.ValueConstraint.FALSE_VALUE), MethodContract.trivialContract(MethodContract.ValueConstraint.TRUE_VALUE));
                    }
                }
            }
        }
        return Collections.emptyList();
    }

    static MethodContract optionalAbsentContract(MethodContract.ValueConstraint returnValue) {
        return MethodContract.singleConditionContract(ContractValue.qualifier(), DfaRelationValue.RelationType.IS, ContractValue.optionalValue(false), returnValue);
    }

    static MethodContract nonnegativeArgumentContract(int argNumber) {
        return MethodContract.singleConditionContract(ContractValue.argument(argNumber), DfaRelationValue.RelationType.LT, ContractValue.zero(), MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    static MethodContract specialFieldRangeContract(int index2, DfaRelationValue.RelationType type2, SpecialField specialField) {
        return MethodContract.singleConditionContract(ContractValue.argument(index2), type2.getNegated(), ContractValue.qualifier().specialField(specialField), MethodContract.ValueConstraint.THROW_EXCEPTION);
    }

    private static boolean isJunit(String className2) {
        return className2.startsWith("junit.framework.") || className2.startsWith("org.junit.") || className2.equals("org.testng.AssertJUnit");
    }

    private static boolean isJunit5(String className2) {
        return className2.startsWith("org.junit.jupiter.");
    }

    private static boolean isTestng(String className2) {
        return className2.startsWith("org.testng.") && !className2.equals("org.testng.AssertJUnit");
    }

    private static boolean isNotNullMatcher(PsiExpression expr) {
        if (expr instanceof PsiMethodCallExpression) {
            PsiExpression[] args;
            PsiExpression[] equalArgs;
            PsiExpression[] notArgs;
            String calledName = ((PsiMethodCallExpression)expr).getMethodExpression().getReferenceName();
            if ("notNullValue".equals(calledName)) {
                return true;
            }
            if ("not".equals(calledName) && (notArgs = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1 && notArgs[0] instanceof PsiMethodCallExpression && "equalTo".equals(((PsiMethodCallExpression)notArgs[0]).getMethodExpression().getReferenceName()) && (equalArgs = ((PsiMethodCallExpression)notArgs[0]).getArgumentList().getExpressions()).length == 1 && ExpressionUtils.isNullLiteral(equalArgs[0])) {
                return true;
            }
            if ("is".equals(calledName) && (args = ((PsiMethodCallExpression)expr).getArgumentList().getExpressions()).length == 1) {
                return HardcodedContracts.isNotNullMatcher(args[0]);
            }
        }
        return false;
    }

    private static List<MethodContract> handleTestFrameworks(int paramCount, String className2, String methodName, @Nullable PsiMethodCallExpression call2) {
        if (("assertThat".equals(methodName) || "assumeThat".equals(methodName) || "that".equals(methodName)) && call2 != null) {
            return HardcodedContracts.handleAssertThat(paramCount, call2);
        }
        if (!HardcodedContracts.isJunit(className2) && !HardcodedContracts.isTestng(className2)) {
            return Collections.emptyList();
        }
        boolean testng = HardcodedContracts.isTestng(className2);
        if ("fail".equals(methodName)) {
            return Collections.singletonList(new StandardMethodContract(StandardMethodContract.createConstraintArray(paramCount), MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if (paramCount == 0) {
            return Collections.emptyList();
        }
        int checkedParam = testng || HardcodedContracts.isJunit5(className2) ? 0 : paramCount - 1;
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(paramCount);
        if ("assertTrue".equals(methodName) || "assumeTrue".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.FALSE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertFalse".equals(methodName) || "assumeFalse".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.TRUE_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNull".equals(methodName)) {
            constraints[checkedParam] = MethodContract.ValueConstraint.NOT_NULL_VALUE;
            return Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        }
        if ("assertNotNull".equals(methodName) || "assumeNotNull".equals(methodName)) {
            return HardcodedContracts.failIfNull(checkedParam, paramCount);
        }
        return Collections.emptyList();
    }

    @NotNull
    private static List<MethodContract> handleAssertThat(int paramCount, @NotNull PsiMethodCallExpression call2) {
        PsiExpression[] args;
        if (call2 == null) {
            HardcodedContracts.$$$reportNull$$$0(1);
        }
        if ((args = call2.getArgumentList().getExpressions()).length == paramCount) {
            for (int i = 1; i < args.length; ++i) {
                if (!HardcodedContracts.isNotNullMatcher(args[i])) continue;
                List<MethodContract> list2 = HardcodedContracts.failIfNull(i - 1, paramCount);
                if (list2 == null) {
                    HardcodedContracts.$$$reportNull$$$0(2);
                }
                return list2;
            }
            if (args.length == 1 && HardcodedContracts.hasNotNullChainCall(call2)) {
                List<MethodContract> list3 = HardcodedContracts.failIfNull(0, 1);
                if (list3 == null) {
                    HardcodedContracts.$$$reportNull$$$0(3);
                }
                return list3;
            }
        }
        List<MethodContract> list4 = Collections.emptyList();
        if (list4 == null) {
            HardcodedContracts.$$$reportNull$$$0(4);
        }
        return list4;
    }

    private static boolean hasNotNullChainCall(PsiMethodCallExpression call2) {
        JBIterable<PsiElement> exprParents = SyntaxTraverser.psiApi().parents(call2).takeWhile(e -> !(e instanceof PsiStatement) && !(e instanceof PsiMember));
        return ContainerUtil.exists(exprParents, HardcodedContracts::isNotNullCall);
    }

    private static boolean isNotNullCall(PsiElement ref) {
        return ref instanceof PsiReferenceExpression && "isNotNull".equals(((PsiReferenceExpression)ref).getReferenceName()) && ref.getParent() instanceof PsiMethodCallExpression;
    }

    @NotNull
    private static List<MethodContract> failIfNull(int argIndex, int argCount) {
        MethodContract.ValueConstraint[] constraints = StandardMethodContract.createConstraintArray(argCount);
        constraints[argIndex] = MethodContract.ValueConstraint.NULL_VALUE;
        List<MethodContract> list2 = Collections.singletonList(new StandardMethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
        if (list2 == null) {
            HardcodedContracts.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public static boolean isHardcodedPure(PsiMethod method) {
        PsiParameter[] parameters2;
        PsiClass aClass2 = method.getContainingClass();
        if (aClass2 == null) {
            return false;
        }
        String className2 = aClass2.getQualifiedName();
        if (className2 == null) {
            return false;
        }
        String name = method.getName();
        if ("java.util.Objects".equals(className2) && "requireNonNull".equals(name) && (parameters2 = method.getParameterList().getParameters()).length == 2 && parameters2[1].getType().getCanonicalText().contains("Supplier")) {
            return false;
        }
        if ("java.lang.System".equals(className2)) {
            return false;
        }
        if ("java.util.Arrays".equals(className2)) {
            return name.equals("binarySearch") || name.equals("spliterator") || name.equals("stream");
        }
        return true;
    }

    public static boolean hasHardcodedContracts(@Nullable PsiElement element) {
        if (element instanceof PsiMethod) {
            return !HardcodedContracts.getHardcodedContracts((PsiMethod)element, null).isEmpty();
        }
        if (element instanceof PsiParameter) {
            PsiElement parent2 = element.getParent();
            return parent2 != null && HardcodedContracts.hasHardcodedContracts(parent2.getParent());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/dataFlow/HardcodedContracts";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "handleAssertThat";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "failIfNull";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getHardcodedContracts";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleAssertThat";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

