/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInspection.dataFlow.ContractInferenceIndexKt;
import com.intellij.codeInspection.dataFlow.ExpressionRange;
import com.intellij.codeInspection.dataFlow.InferenceFromSourceUtil;
import com.intellij.codeInspection.dataFlow.MethodData;
import com.intellij.codeInspection.dataFlow.NullityInferenceResult;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.JavaLightTreeUtil;
import com.intellij.psi.impl.source.PsiMethodImpl;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullityInference {
    public static Nullness inferNullity(PsiMethodImpl method) {
        if (!InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullness.UNKNOWN;
        }
        PsiType type2 = method.getReturnType();
        if (type2 == null || type2 instanceof PsiPrimitiveType) {
            return Nullness.UNKNOWN;
        }
        return (Nullness)((Object)CachedValuesManager.getCachedValue(method, () -> {
            Nullness nullness;
            MethodData data2 = ContractInferenceIndexKt.getIndexedData(method);
            NullityInferenceResult result2 = data2 == null ? null : data2.getNullity();
            Nullness nullness2 = nullness = result2 == null ? null : RecursionManager.doPreventingRecursion(method, true, () -> result2.getNullness(method, data2.methodBody(method)));
            if (nullness == null) {
                nullness = Nullness.UNKNOWN;
            }
            return CachedValueProvider.Result.create(nullness, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }));
    }

    public static Nullness inferNullity(PsiParameter parameter) {
        if (!parameter.isPhysical() || parameter.getType() instanceof PsiPrimitiveType) {
            return Nullness.UNKNOWN;
        }
        PsiParameterList parent2 = ObjectUtils.tryCast(parameter.getParent(), PsiParameterList.class);
        if (parent2 == null) {
            return Nullness.UNKNOWN;
        }
        PsiMethodImpl method = ObjectUtils.tryCast(parent2.getParent(), PsiMethodImpl.class);
        if (method == null || !InferenceFromSourceUtil.shouldInferFromSource(method)) {
            return Nullness.UNKNOWN;
        }
        return (Nullness)((Object)CachedValuesManager.getCachedValue(parameter, () -> {
            int index2;
            BitSet notNullParameters;
            Nullness nullness = Nullness.UNKNOWN;
            MethodData data2 = ContractInferenceIndexKt.getIndexedData(method);
            if (data2 != null && !(notNullParameters = data2.getNotNullParameters()).isEmpty() && notNullParameters.get(index2 = ArrayUtil.indexOf(parent2.getParameters(), parameter))) {
                nullness = Nullness.NOT_NULL;
            }
            return CachedValueProvider.Result.create(nullness, method, PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
        }));
    }

    static class NullityInferenceVisitor {
        private final LighterAST tree;
        private final LighterASTNode body;
        private boolean hasErrors;
        private boolean hasNotNulls;
        private boolean hasNulls;
        private boolean hasUnknowns;
        MultiMap<String, ExpressionRange> delegates = MultiMap.create();

        NullityInferenceVisitor(LighterAST tree, LighterASTNode body) {
            this.tree = tree;
            this.body = body;
        }

        void visitNode(LighterASTNode element) {
            IElementType type2 = element.getTokenType();
            if (type2 == TokenType.ERROR_ELEMENT) {
                this.hasErrors = true;
            } else if (type2 == JavaElementType.RETURN_STATEMENT) {
                LighterASTNode value = JavaLightTreeUtil.findExpressionChild(this.tree, element);
                if (value == null) {
                    this.hasErrors = true;
                } else {
                    this.visitReturnedValue(value);
                }
            }
        }

        private void visitReturnedValue(LighterASTNode expr) {
            IElementType type2 = expr.getTokenType();
            while (type2 == JavaElementType.PARENTH_EXPRESSION) {
                if ((expr = JavaLightTreeUtil.findExpressionChild(this.tree, expr)) == null) {
                    this.hasUnknowns = true;
                    return;
                }
                type2 = expr.getTokenType();
            }
            if (this.containsNulls(expr)) {
                this.hasNulls = true;
            } else if (type2 == JavaElementType.LAMBDA_EXPRESSION || type2 == JavaElementType.NEW_EXPRESSION || type2 == JavaElementType.METHOD_REF_EXPRESSION || type2 == JavaElementType.LITERAL_EXPRESSION || type2 == JavaElementType.BINARY_EXPRESSION || type2 == JavaElementType.POLYADIC_EXPRESSION) {
                this.hasNotNulls = true;
            } else if (type2 == JavaElementType.METHOD_CALL_EXPRESSION) {
                String calledMethod = JavaLightTreeUtil.getNameIdentifierText(this.tree, this.tree.getChildren(expr).get(0));
                if (calledMethod != null) {
                    this.delegates.putValue(calledMethod, ExpressionRange.create(expr, this.body.getStartOffset()));
                }
            } else if (type2 == JavaElementType.CONDITIONAL_EXPRESSION) {
                List<LighterASTNode> expressionChildren = JavaLightTreeUtil.getExpressionChildren(this.tree, expr);
                if (expressionChildren.size() == 3) {
                    this.visitReturnedValue(expressionChildren.get(1));
                    this.visitReturnedValue(expressionChildren.get(2));
                } else {
                    this.hasUnknowns = true;
                }
            } else if (type2 == JavaElementType.TYPE_CAST_EXPRESSION) {
                LighterASTNode child = JavaLightTreeUtil.findExpressionChild(this.tree, expr);
                if (child != null) {
                    this.visitReturnedValue(child);
                } else {
                    this.hasUnknowns = true;
                }
            } else {
                this.hasUnknowns = true;
            }
        }

        private boolean containsNulls(@NotNull LighterASTNode value) {
            if (value == null) {
                NullityInferenceVisitor.$$$reportNull$$$0(0);
            }
            return value.getTokenType() == JavaElementType.LITERAL_EXPRESSION && this.tree.getChildren(value).get(0).getTokenType() == JavaTokenType.NULL_KEYWORD;
        }

        @Nullable
        NullityInferenceResult getResult() {
            if (this.hasNulls) {
                return new NullityInferenceResult.Predefined(Nullness.NULLABLE);
            }
            if (this.hasErrors || this.hasUnknowns || this.delegates.size() > 1) {
                return null;
            }
            if (this.delegates.size() == 1) {
                return new NullityInferenceResult.FromDelegate(ContainerUtil.newArrayList(this.delegates.get(this.delegates.keySet().iterator().next())));
            }
            if (this.hasNotNulls) {
                return new NullityInferenceResult.Predefined(Nullness.NOT_NULL);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/codeInspection/dataFlow/NullityInference$NullityInferenceVisitor", "containsNulls"));
        }
    }
}

