/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;

public class FinishElementInstruction
extends Instruction {
    private final Set<DfaVariableValue> myVarsToFlush = ContainerUtil.newHashSet();
    private final PsiElement myElement;

    public FinishElementInstruction(PsiElement element) {
        this.myElement = element;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState state2, InstructionVisitor visitor2) {
        if (!this.myVarsToFlush.isEmpty()) {
            for (DfaVariableValue value : this.myVarsToFlush) {
                state2.flushVariable(value);
            }
        }
        state2.cleanUpTempVariables();
        return this.nextInstruction(runner, state2);
    }

    public String toString() {
        return "Finish " + this.myElement + "; flushing " + this.myVarsToFlush;
    }

    public Set<DfaVariableValue> getVarsToFlush() {
        return this.myVarsToFlush;
    }
}

