/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.value;

import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnboxedValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DfaBoxedValue
extends DfaValue {
    private final DfaValue myWrappedValue;

    private DfaBoxedValue(DfaValue valueToWrap, DfaValueFactory factory2) {
        super(factory2);
        this.myWrappedValue = valueToWrap;
    }

    @NonNls
    public String toString() {
        return "Boxed " + this.myWrappedValue.toString();
    }

    public DfaValue getWrappedValue() {
        return this.myWrappedValue;
    }

    public static class Factory {
        private final Map<Object, DfaBoxedValue> cachedValues = new HashMap<Object, DfaBoxedValue>();
        private final DfaValueFactory myFactory;
        private final Map<DfaVariableValue, DfaUnboxedValue> cachedUnboxedValues = ContainerUtil.newTroveMap();

        public Factory(DfaValueFactory factory2) {
            this.myFactory = factory2;
        }

        @Nullable
        public DfaValue createBoxed(DfaValue valueToWrap) {
            Object o;
            if (valueToWrap instanceof DfaUnboxedValue) {
                return ((DfaUnboxedValue)valueToWrap).getVariable();
            }
            Object object = valueToWrap instanceof DfaConstValue ? ((DfaConstValue)valueToWrap).getValue() : (o = valueToWrap instanceof DfaVariableValue ? valueToWrap : null);
            if (o == null) {
                return null;
            }
            DfaBoxedValue boxedValue = this.cachedValues.get(o);
            if (boxedValue == null) {
                boxedValue = new DfaBoxedValue(valueToWrap, this.myFactory);
                this.cachedValues.put(o, boxedValue);
            }
            return boxedValue;
        }

        @NotNull
        public DfaValue createUnboxed(DfaValue value) {
            if (value instanceof DfaBoxedValue) {
                DfaValue dfaValue = ((DfaBoxedValue)value).getWrappedValue();
                if (dfaValue == null) {
                    Factory.$$$reportNull$$$0(0);
                }
                return dfaValue;
            }
            if (value instanceof DfaConstValue) {
                if (value == value.myFactory.getConstFactory().getNull()) {
                    DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
                    if (dfaUnknownValue == null) {
                        Factory.$$$reportNull$$$0(1);
                    }
                    return dfaUnknownValue;
                }
                DfaValue dfaValue = value;
                if (dfaValue == null) {
                    Factory.$$$reportNull$$$0(2);
                }
                return dfaValue;
            }
            if (value instanceof DfaVariableValue) {
                DfaVariableValue var = (DfaVariableValue)value;
                DfaUnboxedValue result2 = this.cachedUnboxedValues.get(var);
                if (result2 == null) {
                    result2 = new DfaUnboxedValue(var, this.myFactory);
                    this.cachedUnboxedValues.put(var, result2);
                }
                DfaUnboxedValue dfaUnboxedValue = result2;
                if (dfaUnboxedValue == null) {
                    Factory.$$$reportNull$$$0(3);
                }
                return dfaUnboxedValue;
            }
            DfaUnknownValue dfaUnknownValue = DfaUnknownValue.getInstance();
            if (dfaUnknownValue == null) {
                Factory.$$$reportNull$$$0(4);
            }
            return dfaUnknownValue;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/value/DfaBoxedValue$Factory", "createUnboxed"));
        }
    }
}

