/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.ToolsImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tJ\u001a\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\n\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014JH\u0010\u000e\u001a8\u00124\u00122\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00110\u0011\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\u00130\u0013 \u0012*\r\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0010\u00a8\u0006\u00010\u0010\u00a8\u0006\u00010\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014J\u0016\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0006\u0010\u0019\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0016J\u0010\u0010\u001c\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u001d\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020\u0005J\b\u0010 \u001a\u00020\u0016H\u0016J\u0014\u0010\b\u001a\u00020\t*\u00020\u00012\u0006\u0010!\u001a\u00020\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\""}, d2={"Lcom/intellij/codeInspection/ex/InspectionProfileModifiableModel;", "Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "source", "(Lcom/intellij/codeInspection/ex/InspectionProfileImpl;)V", "modified", "", "getSource", "()Lcom/intellij/codeInspection/ex/InspectionProfileImpl;", "commit", "", "copyToolsConfigurations", "profile", "project", "Lcom/intellij/openapi/project/Project;", "createTools", "", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "Lcom/intellij/codeInspection/InspectionProfileEntry;", "kotlin.jvm.PlatformType", "Lcom/intellij/codeInspection/InspectionEP;", "disableTool", "toolShortName", "", "element", "Lcom/intellij/psi/PsiElement;", "isChanged", "isProperSetting", "toolId", "resetToBase", "resetToEmpty", "setModified", "value", "toString", "model", "analysis-impl"})
public class InspectionProfileModifiableModel
extends InspectionProfileImpl {
    private boolean modified;
    @NotNull
    private final InspectionProfileImpl source;

    public final boolean isChanged() {
        return this.modified || this.source.myLockedProfile != this.myLockedProfile;
    }

    public final void setModified(boolean value) {
        this.modified = value;
    }

    @Override
    protected void copyToolsConfigurations(@Nullable Project project) {
        this.copyToolsConfigurations(this.source, project);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<InspectionToolWrapper<InspectionProfileEntry, InspectionEP>> createTools(@Nullable Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = (Iterable)this.source.getDefaultStates(project);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ScopeToolState scopeToolState = (ScopeToolState)item$iv$iv;
            Collection collection = destination$iv$iv;
            InspectionToolWrapper inspectionToolWrapper = it.getTool();
            collection.add(inspectionToolWrapper);
        }
        return (List)destination$iv$iv;
    }

    private final void copyToolsConfigurations(InspectionProfileImpl profile2, Project project) {
        try {
            for (ToolsImpl toolList : profile2.myTools.values()) {
                Object v = this.myTools.get(toolList.getShortName());
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                ToolsImpl tools = (ToolsImpl)v;
                ScopeToolState defaultState = toolList.getDefaultState();
                tools.setDefaultState(InspectionProfileImpl.copyToolSettings(defaultState.getTool()), defaultState.isEnabled(), defaultState.getLevel());
                tools.removeAllScopes();
                List<ScopeToolState> nonDefaultToolStates = toolList.getNonDefaultTools();
                if (nonDefaultToolStates != null) {
                    for (ScopeToolState state2 : nonDefaultToolStates) {
                        InspectionToolWrapper toolWrapper = InspectionProfileImpl.copyToolSettings(state2.getTool());
                        NamedScope scope = state2.getScope(project);
                        if (scope == null) {
                            tools.addTool(state2.getScopeName(), toolWrapper, state2.isEnabled(), state2.getLevel());
                            continue;
                        }
                        tools.addTool(scope, toolWrapper, state2.isEnabled(), state2.getLevel());
                    }
                }
                tools.setEnabled(toolList.isEnabled());
            }
        }
        catch (WriteExternalException e) {
            InspectionProfileImpl.LOG.error(e);
        }
        catch (InvalidDataException e) {
            InspectionProfileImpl.LOG.error(e);
        }
    }

    public final boolean isProperSetting(@NotNull String toolId) {
        Intrinsics.checkParameterIsNotNull(toolId, "toolId");
        if (this.myBaseProfile != null) {
            ToolsImpl tools = this.myBaseProfile.getToolsOrNull(toolId, null);
            ToolsImpl currentTools = (ToolsImpl)this.myTools.get(toolId);
            return Intrinsics.areEqual(tools, currentTools) ^ true;
        }
        return false;
    }

    public final void resetToBase(@Nullable Project project) {
        this.initInspectionTools(project);
        InspectionProfileImpl inspectionProfileImpl = this.myBaseProfile;
        Intrinsics.checkExpressionValueIsNotNull(inspectionProfileImpl, "myBaseProfile");
        this.copyToolsConfigurations(inspectionProfileImpl, project);
        this.myChangedToolNames = null;
    }

    public final void commit() {
        this.commit(this.source, this);
        this.modified = false;
    }

    public final void resetToEmpty(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull(project, "project");
        this.initInspectionTools(project);
        InspectionToolWrapper[] inspectionToolWrapperArray = this.getInspectionTools(null);
        for (int i = 0; i < inspectionToolWrapperArray.length; ++i) {
            InspectionToolWrapper toolWrapper = inspectionToolWrapperArray[i];
            String string = toolWrapper.getShortName();
            Intrinsics.checkExpressionValueIsNotNull(string, "toolWrapper.shortName");
            this.setToolEnabled(string, false, project, false);
        }
    }

    private final void commit(@NotNull InspectionProfileImpl $receiver, InspectionProfileImpl model) {
        $receiver.setName(model.getName());
        $receiver.setDescription(model.getDescription());
        $receiver.setProjectLevel(model.isProjectLevel());
        $receiver.myLockedProfile = model.myLockedProfile;
        $receiver.myChangedToolNames = model.myChangedToolNames;
        $receiver.myTools = model.myTools;
        $receiver.setProfileManager(model.getProfileManager());
    }

    public final void disableTool(@NotNull String toolShortName, @NotNull PsiElement element) {
        Intrinsics.checkParameterIsNotNull(toolShortName, "toolShortName");
        Intrinsics.checkParameterIsNotNull(element, "element");
        this.getTools(toolShortName, element.getProject()).disableTool(element);
    }

    @Override
    @NotNull
    public String toString() {
        return "" + this.getName() + " (copy)";
    }

    @NotNull
    public final InspectionProfileImpl getSource() {
        return this.source;
    }

    public InspectionProfileModifiableModel(@NotNull InspectionProfileImpl source) {
        Intrinsics.checkParameterIsNotNull(source, "source");
        super(source.getName(), source.myToolSupplier, source.getProfileManager(), source.myBaseProfile, null);
        this.source = source;
        Map<String, Element> map2 = this.source.myUninitializedSettings;
        Intrinsics.checkExpressionValueIsNotNull(map2, "source.myUninitializedSettings");
        this.myUninitializedSettings.putAll(map2);
        this.setProjectLevel(this.source.isProjectLevel());
        this.myLockedProfile = this.source.myLockedProfile;
        this.copyFrom(this.source);
    }
}

