/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.javaDoc;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.javaDoc.JavadocHighlightUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.JavadocManager;
import com.intellij.psi.javadoc.JavadocTagInfo;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.javadoc.PsiInlineDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaDocReferenceInspectionBase
extends LocalInspectionTool {
    private static final String SHORT_NAME = "JavadocReference";

    private void visitRefInDocTag(PsiDocTag tag, JavadocManager manager, PsiElement context, ProblemsHolder holder, boolean isOnTheFly) {
        PsiDocCommentOwner commentOwner;
        PsiReference reference;
        String message;
        PsiDocTagValue value = tag.getValueElement();
        if (value == null) {
            return;
        }
        String tagName = tag.getName();
        JavadocTagInfo info = manager.getTagInfo(tagName);
        if (info != null && !info.isValidInContext(context)) {
            return;
        }
        if (info != null && info.isInline() && (message = info.checkTagValue(value)) != null) {
            holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)value, message, isOnTheFly, null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL));
        }
        if ((reference = value.getReference()) == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (element != null) {
            return;
        }
        int textOffset = value.getTextOffset();
        if (textOffset == value.getTextRange().getEndOffset()) {
            return;
        }
        PsiDocTagValue valueElement = tag.getValueElement();
        if (valueElement == null) {
            return;
        }
        CharSequence paramName = value.getContainingFile().getViewProvider().getContents().subSequence(textOffset, value.getTextRange().getEndOffset());
        String params2 = "<code>" + paramName + "</code>";
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        if (isOnTheFly && "param".equals(tagName) && (commentOwner = PsiTreeUtil.getParentOfType((PsiElement)tag, PsiDocCommentOwner.class)) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)commentOwner;
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            PsiDocTag[] tags = tag.getContainingComment().getTags();
            HashSet<String> unboundParams = new HashSet<String>();
            for (PsiParameter parameter : parameters2) {
                if (JavadocHighlightUtil.hasTagForParameter(tags, parameter)) continue;
                unboundParams.add(parameter.getName());
            }
            if (!unboundParams.isEmpty()) {
                fixes.add(this.createRenameReferenceQuickFix(unboundParams));
            }
        }
        fixes.add(new RemoveTagFix(tagName, paramName));
        LocalQuickFix[] array = fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
        holder.registerProblem(holder.getManager().createProblemDescriptor((PsiElement)valueElement, reference.getRangeInElement(), JavaDocReferenceInspectionBase.cannotResolveSymbolMessage(params2), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly, array));
    }

    protected LocalQuickFix createRenameReferenceQuickFix(Set<String> unboundParams) {
        return null;
    }

    private static String cannotResolveSymbolMessage(String params2) {
        return InspectionsBundle.message("inspection.javadoc.problem.cannot.resolve", params2);
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    protected LocalQuickFix createAddQualifierFix(PsiJavaCodeReferenceElement reference) {
        return null;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.javadoc.ref.display.name", new Object[0]);
        if (string == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = InspectionsBundle.message("group.names.javadoc.issues", new Object[0]);
        if (string == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(4);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitJavaFile(PsiJavaFile file2) {
                if ("package-info.java".equals(file2.getName())) {
                    JavaDocReferenceInspectionBase.this.checkComment(PsiTreeUtil.getChildOfType(file2, PsiDocComment.class), file2, holder, isOnTheFly);
                }
            }

            @Override
            public void visitModule(PsiJavaModule module2) {
                JavaDocReferenceInspectionBase.this.checkComment(module2.getDocComment(), module2, holder, isOnTheFly);
            }

            @Override
            public void visitClass(PsiClass aClass2) {
                JavaDocReferenceInspectionBase.this.checkComment(aClass2.getDocComment(), aClass2, holder, isOnTheFly);
            }

            @Override
            public void visitField(PsiField field) {
                JavaDocReferenceInspectionBase.this.checkComment(field.getDocComment(), field, holder, isOnTheFly);
            }

            @Override
            public void visitMethod(PsiMethod method) {
                JavaDocReferenceInspectionBase.this.checkComment(method.getDocComment(), method, holder, isOnTheFly);
            }
        };
        if (javaElementVisitor == null) {
            JavaDocReferenceInspectionBase.$$$reportNull$$$0(5);
        }
        return javaElementVisitor;
    }

    private void checkComment(PsiDocComment comment, final PsiElement context, final ProblemsHolder holder, final boolean isOnTheFly) {
        if (comment == null) {
            return;
        }
        final JavadocManager javadocManager = JavadocManager.SERVICE.getInstance(holder.getProject());
        comment.accept(new JavaElementVisitor(){

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.visitElement(expression2);
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                JavaResolveResult result2 = reference.advancedResolve(false);
                if (result2.getElement() == null && !result2.isPackagePrefixPackageReference()) {
                    PsiElement referenceNameElement = reference.getReferenceNameElement();
                    PsiElement element = referenceNameElement != null ? referenceNameElement : reference;
                    String message = JavaDocReferenceInspectionBase.cannotResolveSymbolMessage("<code>" + reference.getText() + "</code>");
                    LocalQuickFix fix = isOnTheFly ? JavaDocReferenceInspectionBase.this.createAddQualifierFix(reference) : null;
                    holder.registerProblem(holder.getManager().createProblemDescriptor(element, message, fix, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, isOnTheFly));
                }
            }

            @Override
            public void visitDocTag(PsiDocTag tag) {
                super.visitDocTag(tag);
                JavadocTagInfo info = javadocManager.getTagInfo(tag.getName());
                if (info == null || !info.isInline()) {
                    JavaDocReferenceInspectionBase.this.visitRefInDocTag(tag, javadocManager, context, holder, isOnTheFly);
                }
            }

            @Override
            public void visitInlineDocTag(PsiInlineDocTag tag) {
                super.visitInlineDocTag(tag);
                JavaDocReferenceInspectionBase.this.visitRefInDocTag(tag, javadocManager, context, holder, isOnTheFly);
            }

            @Override
            public void visitElement(PsiElement element) {
                for (PsiElement child : element.getChildren()) {
                    child.accept(this);
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveTagFix
    implements LocalQuickFix {
        private final String myTagName;
        private final CharSequence myParamName;

        public RemoveTagFix(String tagName, CharSequence paramName) {
            this.myTagName = tagName;
            this.myParamName = paramName;
        }

        @Override
        @NotNull
        public String getName() {
            String string = "Remove @" + this.myTagName + " " + this.myParamName;
            if (string == null) {
                RemoveTagFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFamilyName() {
            if ("Remove tag" == null) {
                RemoveTagFix.$$$reportNull$$$0(1);
            }
            return "Remove tag";
        }

        @Override
        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiDocTag myTag;
            if (project == null) {
                RemoveTagFix.$$$reportNull$$$0(2);
            }
            if (descriptor2 == null) {
                RemoveTagFix.$$$reportNull$$$0(3);
            }
            if ((myTag = PsiTreeUtil.getParentOfType(descriptor2.getPsiElement(), PsiDocTag.class)) != null) {
                myTag.delete();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/javaDoc/JavaDocReferenceInspectionBase$RemoveTagFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

