/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.IntArrayList;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousMethodCallUtil {
    private static final CallMatcher.Simple SINGLETON_COLLECTION = CallMatcher.staticCall("java.util.Collections", "singletonList", "singleton").parameterCount(1);

    static void setupPatternMethods(PsiManager manager, GlobalSearchScope searchScope, List<PsiMethod> patternMethods, IntArrayList indices) {
        PsiClass concurrentMapClass;
        PsiClass mapClass;
        PsiClass listClass;
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance(manager.getProject());
        PsiClass collectionClass = javaPsiFacade.findClass("java.util.Collection", searchScope);
        PsiType[] javaLangObject = new PsiType[]{PsiType.getJavaLangObject(manager, searchScope)};
        MethodSignature removeSignature = MethodSignatureUtil.createMethodSignature("remove", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
        if (collectionClass != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature(collectionClass, removeSignature, false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, indices);
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature("contains", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature(collectionClass, containsSignature, false);
            SuspiciousMethodCallUtil.addMethod(contains, 0, patternMethods, indices);
            if (PsiUtil.isLanguageLevel5OrHigher(collectionClass)) {
                PsiClassType wildcardCollection = javaPsiFacade.getElementFactory().createType(collectionClass, (PsiType)PsiWildcardType.createUnbounded(manager));
                MethodSignature removeAllSignature = MethodSignatureUtil.createMethodSignature("removeAll", new PsiType[]{wildcardCollection}, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                PsiMethod removeAll = MethodSignatureUtil.findMethodBySignature(collectionClass, removeAllSignature, false);
                SuspiciousMethodCallUtil.addMethod(removeAll, 0, patternMethods, indices);
            }
        }
        if ((listClass = javaPsiFacade.findClass("java.util.List", searchScope)) != null) {
            MethodSignature indexofSignature = MethodSignatureUtil.createMethodSignature("indexOf", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod indexof = MethodSignatureUtil.findMethodBySignature(listClass, indexofSignature, false);
            SuspiciousMethodCallUtil.addMethod(indexof, 0, patternMethods, indices);
            MethodSignature lastindexofSignature = MethodSignatureUtil.createMethodSignature("lastIndexOf", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod lastindexof = MethodSignatureUtil.findMethodBySignature(listClass, lastindexofSignature, false);
            SuspiciousMethodCallUtil.addMethod(lastindexof, 0, patternMethods, indices);
        }
        if ((mapClass = javaPsiFacade.findClass("java.util.Map", searchScope)) != null) {
            PsiMethod remove = MethodSignatureUtil.findMethodBySignature(mapClass, removeSignature, false);
            SuspiciousMethodCallUtil.addMethod(remove, 0, patternMethods, indices);
            MethodSignature getSignature = MethodSignatureUtil.createMethodSignature("get", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod get2 = MethodSignatureUtil.findMethodBySignature(mapClass, getSignature, false);
            SuspiciousMethodCallUtil.addMethod(get2, 0, patternMethods, indices);
            PsiTypeParameter[] typeParameters2 = mapClass.getTypeParameters();
            if (typeParameters2.length > 0) {
                MethodSignature getOrDefaultSignature = MethodSignatureUtil.createMethodSignature("getOrDefault", new PsiType[]{PsiType.getJavaLangObject(manager, searchScope), PsiSubstitutor.EMPTY.substitute(typeParameters2[1])}, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
                PsiMethod getOrDefault = MethodSignatureUtil.findMethodBySignature(mapClass, getOrDefaultSignature, false);
                SuspiciousMethodCallUtil.addMethod(getOrDefault, 0, patternMethods, indices);
            }
            MethodSignature removeWithDefaultSignature = MethodSignatureUtil.createMethodSignature("remove", new PsiType[]{PsiType.getJavaLangObject(manager, searchScope), PsiType.getJavaLangObject(manager, searchScope)}, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod removeWithDefault = MethodSignatureUtil.findMethodBySignature(mapClass, removeWithDefaultSignature, false);
            SuspiciousMethodCallUtil.addMethod(removeWithDefault, 0, patternMethods, indices);
            MethodSignature containsKeySignature = MethodSignatureUtil.createMethodSignature("containsKey", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod containsKey = MethodSignatureUtil.findMethodBySignature(mapClass, containsKeySignature, false);
            SuspiciousMethodCallUtil.addMethod(containsKey, 0, patternMethods, indices);
            MethodSignature containsValueSignature = MethodSignatureUtil.createMethodSignature("containsValue", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod containsValue = MethodSignatureUtil.findMethodBySignature(mapClass, containsValueSignature, false);
            SuspiciousMethodCallUtil.addMethod(containsValue, 1, patternMethods, indices);
        }
        if ((concurrentMapClass = javaPsiFacade.findClass("java.util.concurrent.ConcurrentHashMap", searchScope)) != null) {
            MethodSignature containsSignature = MethodSignatureUtil.createMethodSignature("contains", javaLangObject, PsiTypeParameter.EMPTY_ARRAY, PsiSubstitutor.EMPTY);
            PsiMethod contains = MethodSignatureUtil.findMethodBySignature(concurrentMapClass, containsSignature, false);
            SuspiciousMethodCallUtil.addMethod(contains, 1, patternMethods, indices);
        }
    }

    private static void addMethod(PsiMethod patternMethod, int typeParamIndex, List<PsiMethod> patternMethods, IntArrayList indices) {
        if (patternMethod != null) {
            patternMethods.add(patternMethod);
            indices.add(typeParamIndex);
        }
    }

    static boolean isInheritorOrSelf(PsiMethod inheritorCandidate, PsiMethod base) {
        PsiClass aClass2 = inheritorCandidate.getContainingClass();
        PsiClass bClass = base.getContainingClass();
        if (aClass2 == null || bClass == null) {
            return false;
        }
        PsiSubstitutor substitutor2 = TypeConversionUtil.getClassSubstitutor(bClass, aClass2, PsiSubstitutor.EMPTY);
        return substitutor2 != null && MethodSignatureUtil.findMethodBySignature(bClass, inheritorCandidate.getSignature(substitutor2), false) == base;
    }

    @Nullable
    public static String getSuspiciousMethodCallMessage(@NotNull PsiMethodCallExpression methodCall, PsiExpression arg, PsiType argType, boolean reportConvertibleMethodCalls, @NotNull List<PsiMethod> patternMethods, @NotNull IntArrayList indices) {
        if (methodCall == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(0);
        }
        if (patternMethods == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(1);
        }
        if (indices == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(2);
        }
        PsiReferenceExpression methodExpression = methodCall.getMethodExpression();
        if (arg instanceof PsiConditionalExpression && argType != null && argType.equalsToText("java.lang.Object") && PsiPolyExpressionUtil.isPolyExpression(arg)) {
            return null;
        }
        return SuspiciousMethodCallUtil.getSuspiciousMethodCallMessage(methodExpression, argType, reportConvertibleMethodCalls, patternMethods, indices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getSuspiciousMethodCallMessage(PsiReferenceExpression methodExpression, PsiType argType, boolean reportConvertibleMethodCalls, @NotNull List<PsiMethod> patternMethods, @NotNull IntArrayList indices) {
        PsiExpression qualifier;
        if (patternMethods == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(3);
        }
        if (indices == null) {
            SuspiciousMethodCallUtil.$$$reportNull$$$0(4);
        }
        if ((qualifier = methodExpression.getQualifierExpression()) == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
            return null;
        }
        if (argType instanceof PsiPrimitiveType) {
            argType = ((PsiPrimitiveType)argType).getBoxedType(methodExpression);
        }
        if (argType == null) {
            return null;
        }
        JavaResolveResult resolveResult = methodExpression.advancedResolve(false);
        PsiElement element = resolveResult.getElement();
        if (!(element instanceof PsiMethod)) {
            return null;
        }
        PsiMethod calleeMethod = (PsiMethod)element;
        PsiMethod contextMethod = PsiTreeUtil.getParentOfType((PsiElement)methodExpression, PsiMethod.class);
        List<PsiMethod> list2 = patternMethods;
        synchronized (list2) {
            if (patternMethods.isEmpty()) {
                SuspiciousMethodCallUtil.setupPatternMethods(methodExpression.getManager(), methodExpression.getResolveScope(), patternMethods, indices);
            }
        }
        for (int i = 0; i < patternMethods.size(); ++i) {
            PsiType paramType;
            PsiMethod patternMethod = patternMethods.get(i);
            if (!patternMethod.getName().equals(methodExpression.getReferenceName())) continue;
            int index2 = indices.get(i);
            if (contextMethod != null && SuspiciousMethodCallUtil.isInheritorOrSelf(contextMethod, patternMethod)) {
                return null;
            }
            PsiClass calleeClass = calleeMethod.getContainingClass();
            PsiSubstitutor substitutor2 = resolveResult.getSubstitutor();
            PsiClass patternClass = patternMethod.getContainingClass();
            assert (patternClass != null);
            assert (calleeClass != null);
            if ((substitutor2 = TypeConversionUtil.getClassSubstitutor(patternClass, calleeClass, substitutor2)) == null || !patternMethod.getSignature(substitutor2).equals(calleeMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
            PsiTypeParameter[] typeParameters2 = patternClass.getTypeParameters();
            if (typeParameters2.length <= index2) {
                return null;
            }
            PsiTypeParameter typeParameter = typeParameters2[index2];
            PsiType typeParamMapping = substitutor2.substitute(typeParameter);
            if (typeParamMapping == null) {
                return null;
            }
            PsiParameter[] parameters2 = patternMethod.getParameterList().getParameters();
            if (parameters2.length == 1 && "removeAll".equals(patternMethod.getName()) && InheritanceUtil.isInheritor(paramType = parameters2[0].getType(), "java.util.Collection")) {
                PsiType qualifierType = qualifier.getType();
                if (qualifierType != null) {
                    PsiType itemType = JavaGenericsUtil.getCollectionItemType(argType, calleeMethod.getResolveScope());
                    PsiType qualifierItemType = JavaGenericsUtil.getCollectionItemType(qualifierType, calleeMethod.getResolveScope());
                    if (qualifierItemType != null && itemType != null && !qualifierItemType.isAssignableFrom(itemType)) {
                        if (TypeUtils.isJavaLangObject(itemType) && SuspiciousMethodCallUtil.hasNullCollectionArg(methodExpression)) {
                            return null;
                        }
                        if (qualifierItemType.isConvertibleFrom(itemType) && !reportConvertibleMethodCalls) {
                            return null;
                        }
                        return InspectionsBundle.message("inspection.suspicious.collections.method.calls.problem.descriptor", PsiFormatUtil.formatType(qualifierType, 0, PsiSubstitutor.EMPTY), PsiFormatUtil.formatType(itemType, 0, PsiSubstitutor.EMPTY));
                    }
                }
                return null;
            }
            String message = null;
            if (typeParamMapping instanceof PsiCapturedWildcardType) {
                typeParamMapping = ((PsiCapturedWildcardType)typeParamMapping).getWildcard();
            }
            if (!typeParamMapping.isAssignableFrom(argType)) {
                if (typeParamMapping.isConvertibleFrom(argType)) {
                    if (reportConvertibleMethodCalls) {
                        message = InspectionsBundle.message("inspection.suspicious.collections.method.calls.problem.descriptor1", PsiFormatUtil.formatMethod(calleeMethod, substitutor2, 4097, 2));
                    }
                } else {
                    PsiType qualifierType = qualifier.getType();
                    if (qualifierType != null) {
                        message = InspectionsBundle.message("inspection.suspicious.collections.method.calls.problem.descriptor", PsiFormatUtil.formatType(qualifierType, 0, PsiSubstitutor.EMPTY), PsiFormatUtil.formatType(argType, 0, PsiSubstitutor.EMPTY));
                    }
                }
            }
            return message;
        }
        return null;
    }

    private static boolean hasNullCollectionArg(PsiReferenceExpression methodExpression) {
        PsiExpression arg;
        PsiMethodCallExpression argCall;
        PsiMethodCallExpression call2 = ObjectUtils.tryCast(methodExpression.getParent(), PsiMethodCallExpression.class);
        return call2 != null && SINGLETON_COLLECTION.test(argCall = ObjectUtils.tryCast(PsiUtil.skipParenthesizedExprDown(arg = ExpressionUtils.resolveExpression(ArrayUtil.getFirstElement(call2.getArgumentList().getExpressions()))), PsiMethodCallExpression.class)) && ExpressionUtils.isNullLiteral(argCall.getArgumentList().getExpressions()[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "methodCall";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "patternMethods";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "indices";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInspection/miscGenerics/SuspiciousMethodCallUtil";
        objectArray[2] = "getSuspiciousMethodCallMessage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

