/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.JavaNullMethodArgumentUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NullableStuffInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    public boolean IGNORE_EXTERNAL_SUPER_NOTNULL;
    public boolean REQUIRE_NOTNULL_FIELDS_INITIALIZED = true;
    public boolean REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    public boolean REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER = true;
    private static final Logger LOG = Logger.getInstance("#com.intellij.codeInspection.nullable.NullableStuffInspectionBase");

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(0);
        }
        super.writeSettings(node);
        for (Element child : new ArrayList<Element>(node.getChildren())) {
            String name = child.getAttributeValue("name");
            String value = child.getAttributeValue("value");
            if (!("IGNORE_EXTERNAL_SUPER_NOTNULL".equals(name) && "false".equals(value) || "REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED".equals(name) && "false".equals(value) || "REQUIRE_NOTNULL_FIELDS_INITIALIZED".equals(name) && "true".equals(value)) && (!"REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER".equals(name) || !"true".equals(value))) continue;
            node.removeContent(child);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file2;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(1);
        }
        if (!PsiUtil.isLanguageLevel5OrHigher(file2 = holder.getFile()) || NullableStuffInspectionBase.nullabilityAnnotationsNotAvailable(file2)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                NullableStuffInspectionBase.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder, isOnTheFly);
            }

            @Override
            public void visitMethodReferenceExpression(PsiMethodReferenceExpression expression2) {
                NullableStuffInspectionBase.this.checkMethodReference(expression2, holder);
                JavaResolveResult result2 = expression2.advancedResolve(false);
                PsiElement target = result2.getElement();
                if (target instanceof PsiMethod) {
                    this.checkCollectionNullityOnAssignment((PsiElement)expression2, LambdaUtil.getFunctionalInterfaceReturnType(expression2), result2.getSubstitutor().substitute(((PsiMethod)target).getReturnType()));
                }
            }

            @Override
            public void visitField(PsiField field) {
                PsiType type2 = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check(field, holder, type2);
                if (TypeConversionUtil.isPrimitiveAndNotNull(type2)) {
                    return;
                }
                Project project = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance(project);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    List<String> annoToRemove;
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List<String> list2 = annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    if (!NullableStuffInspectionBase.checkNonStandardAnnotations(field, annotated, manager, anno, holder)) {
                        return;
                    }
                    NullableStuffInspectionBase.this.checkAccessors(field, annotated, project, manager, anno, annoToRemove, holder);
                    NullableStuffInspectionBase.this.checkConstructorParameters(field, annotated, manager, anno, annoToRemove, holder);
                }
                if (NullableStuffInspectionBase.this.REQUIRE_NOTNULL_FIELDS_INITIALIZED && !annotated.isDeclaredNullable) {
                    NullableStuffInspectionBase.checkNotNullFieldsInitialized(field, manager, holder);
                }
            }

            @Override
            public void visitParameter(PsiParameter parameter) {
                NullableStuffInspectionBase.check(parameter, holder, parameter.getType());
            }

            @Override
            public void visitTypeElement(PsiTypeElement type2) {
                NullableNotNullManager manager = NullableNotNullManager.getInstance(type2.getProject());
                List<PsiAnnotation> annotations2 = this.getExclusiveAnnotations(type2);
                NullableStuffInspectionBase.checkType(null, holder, type2.getType(), (PsiAnnotation)((Object)ContainerUtil.find(annotations2, a -> manager.getNotNulls().contains(a.getQualifiedName()))), (PsiAnnotation)((Object)ContainerUtil.find(annotations2, a -> manager.getNullables().contains(a.getQualifiedName()))));
            }

            private List<PsiAnnotation> getExclusiveAnnotations(PsiTypeElement type2) {
                PsiModifierList modifierList;
                ArrayList<PsiAnnotation> annotations2 = ContainerUtil.newArrayList(type2.getAnnotations());
                PsiTypeElement topMost = Objects.requireNonNull(SyntaxTraverser.psiApi().parents(type2).filter(PsiTypeElement.class).last());
                PsiElement parent2 = topMost.getParent();
                if (parent2 instanceof PsiModifierListOwner && type2.getType().equals(topMost.getType().getDeepComponentType()) && (modifierList = ((PsiModifierListOwner)parent2).getModifierList()) != null) {
                    PsiAnnotation.TargetType[] targets = ArrayUtil.remove(AnnotationTargetUtil.getTargetsForLocation(modifierList), PsiAnnotation.TargetType.TYPE_USE);
                    annotations2.addAll(ContainerUtil.filter(modifierList.getAnnotations(), a -> AnnotationTargetUtil.isTypeAnnotation(a) && AnnotationTargetUtil.findAnnotationTarget(a, targets) == null));
                }
                return annotations2;
            }

            @Override
            public void visitAnnotation(PsiAnnotation annotation2) {
                PsiClass psiClass;
                if (!"org.jetbrains.annotations.NotNull".equals(annotation2.getQualifiedName())) {
                    return;
                }
                PsiAnnotationMemberValue value = annotation2.findDeclaredAttributeValue("exception");
                if (value instanceof PsiClassObjectAccessExpression && (psiClass = PsiUtil.resolveClassInClassTypeOnly(((PsiClassObjectAccessExpression)value).getOperand().getType())) != null && !this.hasStringConstructor(psiClass)) {
                    holder.registerProblem((PsiElement)value, "Custom exception class should have a constructor with a single message parameter of String type", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean hasStringConstructor(PsiClass aClass2) {
                for (PsiMethod method : aClass2.getConstructors()) {
                    PsiParameterList list2 = method.getParameterList();
                    if (list2.getParametersCount() != 1 || !list2.getParameters()[0].getType().equalsToText("java.lang.String")) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                super.visitReferenceElement(reference);
                this.checkNullableNotNullInstantiationConflict(reference);
            }

            private void checkNullableNotNullInstantiationConflict(PsiJavaCodeReferenceElement reference) {
                PsiElement element = reference.resolve();
                if (element instanceof PsiClass) {
                    PsiTypeParameter[] typeParameters2 = ((PsiClass)element).getTypeParameters();
                    PsiTypeElement[] typeArguments2 = this.getReferenceTypeArguments(reference);
                    if (typeParameters2.length > 0 && typeParameters2.length == typeArguments2.length && !(typeArguments2[0].getType() instanceof PsiDiamondType)) {
                        for (int i = 0; i < typeParameters2.length; ++i) {
                            if (DfaPsiUtil.getTypeNullability(JavaPsiFacade.getElementFactory(element.getProject()).createType(typeParameters2[i])) != Nullness.NOT_NULL || DfaPsiUtil.getTypeNullability(typeArguments2[i].getType()) == Nullness.NOT_NULL) continue;
                            holder.registerProblem((PsiElement)typeArguments2[i], "Non-null type argument is expected", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                        }
                    }
                }
            }

            private PsiTypeElement[] getReferenceTypeArguments(PsiJavaCodeReferenceElement reference) {
                PsiReferenceParameterList typeArgList = reference.getParameterList();
                return typeArgList == null ? PsiTypeElement.EMPTY_ARRAY : typeArgList.getTypeParameterElements();
            }

            @Override
            public void visitAssignmentExpression(PsiAssignmentExpression expression2) {
                this.checkCollectionNullityOnAssignment((PsiElement)expression2.getOperationSign(), expression2.getLExpression().getType(), expression2.getRExpression());
            }

            @Override
            public void visitLocalVariable(PsiLocalVariable variable2) {
                PsiIdentifier identifier = variable2.getNameIdentifier();
                if (identifier != null) {
                    this.checkCollectionNullityOnAssignment((PsiElement)identifier, variable2.getType(), variable2.getInitializer());
                }
            }

            @Override
            public void visitReturnStatement(PsiReturnStatement statement2) {
                PsiExpression returnValue = statement2.getReturnValue();
                if (returnValue == null) {
                    return;
                }
                this.checkCollectionNullityOnAssignment((PsiElement)statement2.getReturnValue(), PsiTypesUtil.getMethodReturnType(statement2), returnValue);
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                super.visitLambdaExpression(lambda2);
                PsiElement body = lambda2.getBody();
                if (body instanceof PsiExpression) {
                    this.checkCollectionNullityOnAssignment(body, LambdaUtil.getFunctionalInterfaceReturnType(lambda2), (PsiExpression)body);
                }
            }

            @Override
            public void visitCallExpression(PsiCallExpression callExpression) {
                PsiExpressionList argList = callExpression.getArgumentList();
                JavaResolveResult result2 = callExpression.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)result2.getElement();
                if (method == null || argList == null) {
                    return;
                }
                PsiSubstitutor substitutor2 = result2.getSubstitutor();
                PsiParameter[] parameters2 = method.getParameterList().getParameters();
                PsiExpression[] arguments2 = argList.getExpressions();
                for (int i = 0; i < arguments2.length; ++i) {
                    PsiExpression argument = arguments2[i];
                    if (i >= parameters2.length || i >= parameters2.length - 1 && MethodCallInstruction.isVarArgCall(method, substitutor2, arguments2, parameters2)) continue;
                    this.checkCollectionNullityOnAssignment((PsiElement)argument, substitutor2.substitute(parameters2[i].getType()), argument);
                }
            }

            private void checkCollectionNullityOnAssignment(@NotNull PsiElement errorElement, @Nullable PsiType expectedType2, @Nullable PsiExpression assignedExpression) {
                if (errorElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (assignedExpression == null) {
                    return;
                }
                this.checkCollectionNullityOnAssignment(errorElement, expectedType2, assignedExpression.getType());
            }

            private void checkCollectionNullityOnAssignment(@NotNull PsiElement errorElement, @Nullable PsiType expectedType2, @Nullable PsiType assignedType) {
                if (errorElement == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (this.isNullableNotNullCollectionConflict(errorElement, expectedType2, assignedType, new HashSet<Couple<PsiType>>())) {
                    holder.registerProblem(errorElement, "Assigning a collection of nullable elements into a collection of non-null elements", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
            }

            private boolean isNullableNotNullCollectionConflict(PsiElement place, @Nullable PsiType expectedType2, @Nullable PsiType assignedType, @NotNull Set<Couple<PsiType>> visited2) {
                if (visited2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!visited2.add(Couple.of(expectedType2, assignedType))) {
                    return false;
                }
                if (this.isNullityConflict(JavaGenericsUtil.getCollectionItemType(expectedType2, place.getResolveScope()), JavaGenericsUtil.getCollectionItemType(assignedType, place.getResolveScope()))) {
                    return true;
                }
                for (int i = 0; i <= 1; ++i) {
                    PsiType assignedArg;
                    PsiType expectedArg = PsiUtil.substituteTypeParameter(expectedType2, "java.util.Map", i, false);
                    if (!this.isNullityConflict(expectedArg, assignedArg = PsiUtil.substituteTypeParameter(assignedType, "java.util.Map", i, false)) && (expectedArg == null || assignedArg == null || !this.isNullableNotNullCollectionConflict(place, expectedArg, assignedArg, visited2))) continue;
                    return true;
                }
                return false;
            }

            private boolean isNullityConflict(PsiType expected, PsiType assigned) {
                return DfaPsiUtil.getTypeNullability(expected) == Nullness.NOT_NULL && DfaPsiUtil.getTypeNullability(assigned) == Nullness.NULLABLE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorElement";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visited";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkCollectionNullityOnAssignment";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isNullableNotNullCollectionConflict";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (javaElementVisitor == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(3);
        }
        return javaElementVisitor;
    }

    private void checkMethodReference(PsiMethodReferenceExpression expression2, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(4);
        }
        PsiMethod superMethod = LambdaUtil.getFunctionalInterfaceMethod(expression2);
        PsiMethod targetMethod = ObjectUtils.tryCast(expression2.resolve(), PsiMethod.class);
        if (superMethod == null || targetMethod == null) {
            return;
        }
        PsiElement refName = expression2.getReferenceNameElement();
        assert (refName != null);
        if (this.isNullableOverridingNotNull(NullableStuffInspectionBase.check(targetMethod, holder, expression2.getType()), superMethod)) {
            holder.registerProblem(refName, InspectionsBundle.message("inspection.nullable.problems.Nullable.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(targetMethod), NullableStuffInspectionBase.getPresentableAnnoName(superMethod)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        } else if (this.isNonAnnotatedOverridingNotNull(targetMethod, superMethod)) {
            holder.registerProblem(refName, "Not annotated method is used as an override for a method annotated with " + NullableStuffInspectionBase.getPresentableAnnoName(superMethod), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createFixForNonAnnotatedOverridesNotNull(targetMethod, superMethod));
        }
    }

    protected LocalQuickFix createNavigateToNullParameterUsagesFix(PsiParameter parameter) {
        return null;
    }

    private static boolean nullabilityAnnotationsNotAvailable(PsiFile file2) {
        Project project = file2.getProject();
        GlobalSearchScope scope = GlobalSearchScope.allScope(project);
        JavaPsiFacade facade = JavaPsiFacade.getInstance(project);
        return ContainerUtil.find(NullableNotNullManager.getInstance(project).getNullables(), s -> facade.findClass((String)s, scope) != null) == null;
    }

    private static boolean checkNonStandardAnnotations(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, @NotNull ProblemsHolder holder) {
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(5);
        }
        if (!AnnotationUtil.isAnnotatingApplicable(field, anno)) {
            PsiAnnotation annotation2;
            PsiAnnotation notNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, manager.getNotNulls());
            PsiAnnotation nullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, manager.getNullables());
            String message = "Not '";
            if (annotated.isDeclaredNullable) {
                message = message + nullable.getQualifiedName();
                annotation2 = nullable;
            } else {
                message = message + notNull.getQualifiedName();
                annotation2 = notNull;
            }
            message = message + "' but '" + anno + "' would be used for code generation.";
            PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation2.getNameReferenceElement();
            holder.registerProblem(annotationNameReferenceElement != null && annotationNameReferenceElement.isPhysical() ? annotationNameReferenceElement : field.getNameIdentifier(), message, ProblemHighlightType.WEAK_WARNING, new ChangeNullableDefaultsFix(notNull, nullable, manager));
            return false;
        }
        return true;
    }

    private void checkAccessors(PsiField field, Annotated annotated, Project project, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        PsiClass containingClass;
        PsiMethod setter2;
        PsiIdentifier nameIdentifier;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(6);
        }
        String propName = JavaCodeStyleManager.getInstance(project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
        boolean isStatic = field.hasModifierProperty("static");
        PsiMethod getter2 = PropertyUtilBase.findPropertyGetter(field.getContainingClass(), propName, isStatic, false);
        PsiIdentifier psiIdentifier = nameIdentifier = getter2 == null ? null : getter2.getNameIdentifier();
        if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.isSimpleGetter(getter2)) {
            AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtil.toStringArray(annoToRemove));
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability(getter2) && !TypeConversionUtil.isPrimitiveAndNotNull(getter2.getReturnType())) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message("inspection.nullable.problems.annotated.field.getter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(field)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, getterAnnoFix);
            }
            if (annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred(getter2, false) || annotated.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred(getter2, false, false)) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message("inspection.nullable.problems.annotated.field.getter.conflict", NullableStuffInspectionBase.getPresentableAnnoName(field), NullableStuffInspectionBase.getPresentableAnnoName(getter2)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, getterAnnoFix);
            }
        }
        if ((setter2 = PropertyUtilBase.findPropertySetter(containingClass = field.getContainingClass(), propName, isStatic, false)) != null && setter2.isPhysical() && PropertyUtil.isSimpleSetter(setter2)) {
            PsiIdentifier nameIdentifier1;
            PsiParameter[] parameters2 = setter2.getParameterList().getParameters();
            assert (parameters2.length == 1) : setter2.getText();
            PsiParameter parameter = parameters2[0];
            LOG.assertTrue(parameter != null, setter2.getText());
            AddAnnotationPsiFix addAnnoFix = NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter);
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability(parameter) && !TypeConversionUtil.isPrimitiveAndNotNull(parameter.getType())) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter2, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message("inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(field)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, addAnnoFix);
            }
            if (PropertyUtil.isSimpleSetter(setter2) && annotated.isDeclaredNotNull && NullableStuffInspectionBase.isNullableNotInferred(parameter, false)) {
                nameIdentifier1 = parameter.getNameIdentifier();
                NullableStuffInspectionBase.assertValidElement(setter2, parameter, nameIdentifier1);
                holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message("inspection.nullable.problems.annotated.field.setter.parameter.conflict", NullableStuffInspectionBase.getPresentableAnnoName(field), NullableStuffInspectionBase.getPresentableAnnoName(parameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, addAnnoFix);
            }
        }
    }

    @NotNull
    private static AddAnnotationPsiFix createAddAnnotationFix(String anno, List<String> annoToRemove, PsiParameter parameter) {
        AddAnnotationPsiFix addAnnotationPsiFix = new AddAnnotationPsiFix(anno, parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray(annoToRemove));
        if (addAnnotationPsiFix == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(7);
        }
        return addAnnotationPsiFix;
    }

    private static void assertValidElement(PsiMethod setter2, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
        LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), setter2.getText());
        LOG.assertTrue(parameter.isPhysical(), setter2.getText());
    }

    private static void checkNotNullFieldsInitialized(PsiField field, NullableNotNullManager manager, @NotNull ProblemsHolder holder) {
        PsiAnnotation annotation2;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(8);
        }
        if ((annotation2 = manager.getNotNullAnnotation(field, false)) == null || HighlightControlFlowUtil.isFieldInitializedAfterObjectConstruction(field)) {
            return;
        }
        boolean byDefault = manager.isContainerAnnotation(annotation2);
        PsiJavaCodeReferenceElement name = annotation2.getNameReferenceElement();
        holder.registerProblem(annotation2.isPhysical() && !byDefault ? annotation2 : field.getNameIdentifier(), (byDefault && name != null ? "@" + name.getReferenceName() : "Not-null") + " fields must be initialized", new LocalQuickFix[0]);
    }

    private void checkConstructorParameters(PsiField field, Annotated annotated, NullableNotNullManager manager, String anno, List<String> annoToRemove, @NotNull ProblemsHolder holder) {
        List<PsiExpression> initializers;
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(9);
        }
        if ((initializers = DfaPsiUtil.findAllConstructorInitializers(field)).isEmpty()) {
            return;
        }
        ArrayList notNullParams = ContainerUtil.newArrayList();
        boolean isFinal = field.hasModifierProperty("final");
        for (PsiExpression rhs : initializers) {
            PsiIdentifier nameIdentifier;
            PsiElement target;
            if (!(rhs instanceof PsiReferenceExpression) || !NullableStuffInspectionBase.isConstructorParameter(target = ((PsiReferenceExpression)rhs).resolve()) || !target.isPhysical()) continue;
            PsiParameter parameter = (PsiParameter)target;
            if (this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability(parameter) && !TypeConversionUtil.isPrimitiveAndNotNull(parameter.getType()) && (nameIdentifier = parameter.getNameIdentifier()) != null && nameIdentifier.isPhysical()) {
                holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message("inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(field)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.createAddAnnotationFix(anno, annoToRemove, parameter));
                continue;
            }
            if (!isFinal || !annotated.isDeclaredNullable || !NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false)) continue;
            notNullParams.add(parameter);
        }
        if (notNullParams.size() != initializers.size()) {
            return;
        }
        PsiIdentifier nameIdentifier = field.getNameIdentifier();
        if (nameIdentifier.isPhysical()) {
            holder.registerProblem((PsiElement)nameIdentifier, "@" + NullableStuffInspectionBase.getPresentableAnnoName(field) + " field is always initialized not-null", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new AddNotNullAnnotationFix(field));
        }
    }

    private static boolean isConstructorParameter(@Nullable PsiElement parameter) {
        return parameter instanceof PsiParameter && ((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement(PsiParameterList.class).withParent(PsiJavaPatterns.psiMethod().constructor(true))).accepts(parameter.getParent());
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(10);
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance(owner.getProject());
        HashSet<String> names2 = ContainerUtil.newHashSet(manager.getNullables());
        names2.addAll(manager.getNotNulls());
        PsiAnnotation annotation2 = AnnotationUtil.findAnnotationInHierarchy(owner, names2);
        if (annotation2 != null) {
            String string = NullableStuffInspectionBase.getPresentableAnnoName(annotation2);
            if (string == null) {
                NullableStuffInspectionBase.$$$reportNull$$$0(11);
            }
            return string;
        }
        String anno = manager.getNotNull(owner);
        String string = StringUtil.getShortName(anno != null ? anno : StringUtil.notNullize(manager.getNullable(owner), "???"));
        if (string == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(12);
        }
        return string;
    }

    public static String getPresentableAnnoName(@NotNull PsiAnnotation annotation2) {
        if (annotation2 == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(13);
        }
        return StringUtil.getShortName(StringUtil.notNullize(annotation2.getQualifiedName(), "???"));
    }

    private static Annotated check(PsiModifierListOwner owner, ProblemsHolder holder, PsiType type2) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance(holder.getProject());
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation(owner, manager.getNotNulls());
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation(owner, manager.getNullables());
        NullableStuffInspectionBase.checkType(owner, holder, type2, isDeclaredNotNull, isDeclaredNullable);
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void checkType(@Nullable PsiModifierListOwner listOwner, ProblemsHolder holder, PsiType type2, @Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable) {
        if (nullable != null && notNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, listOwner, nullable, notNull);
        }
        if ((notNull != null || nullable != null) && type2 != null && TypeConversionUtil.isPrimitive(type2.getCanonicalText())) {
            PsiAnnotation annotation2 = notNull == null ? nullable : notNull;
            NullableStuffInspectionBase.reportPrimitiveType(holder, annotation2, listOwner);
        }
        if (listOwner instanceof PsiParameter) {
            NullableStuffInspectionBase.checkLoopParameterNullability(holder, notNull, nullable, DfaPsiUtil.inferParameterNullability((PsiParameter)listOwner));
        }
    }

    private static void checkLoopParameterNullability(ProblemsHolder holder, @Nullable PsiAnnotation notNull, @Nullable PsiAnnotation nullable, Nullness expectedNullability) {
        if (notNull != null && expectedNullability == Nullness.NULLABLE) {
            holder.registerProblem((PsiElement)notNull, "Parameter can be null", new RemoveAnnotationQuickFix(notNull, null));
        } else if (nullable != null && expectedNullability == Nullness.NOT_NULL) {
            holder.registerProblem((PsiElement)nullable, "Parameter is always not-null", new RemoveAnnotationQuickFix(nullable, null));
        }
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiAnnotation annotation2, @Nullable PsiModifierListOwner listOwner) {
        holder.registerProblem(!annotation2.isPhysical() && listOwner != null ? listOwner.getNavigationElement() : annotation2, InspectionsBundle.message("inspection.nullable.problems.primitive.type.annotation", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveAnnotationQuickFix(annotation2, listOwner));
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.nullable.problems.display.name", new Object[0]);
        if (string == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if ("NullableProblems" == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(16);
        }
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder, boolean isOnFly) {
        Annotated annotated = NullableStuffInspectionBase.check(method, holder, method.getReturnType());
        List<PsiMethod> superMethods = ContainerUtil.map(method.findSuperMethodSignaturesIncludingStatic(true), signature2 -> signature2.getMethod());
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance(holder.getProject());
        this.checkSupers(method, holder, annotated, superMethods);
        this.checkParameters(method, holder, superMethods, nullableManager, isOnFly);
        this.checkOverriders(method, holder, annotated, nullableManager);
    }

    private void checkSupers(PsiMethod method, ProblemsHolder holder, Annotated annotated, List<PsiMethod> superMethods) {
        for (PsiMethod superMethod : superMethods) {
            if (this.isNullableOverridingNotNull(annotated, superMethod)) {
                PsiAnnotation annotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, this.getNullityManager(method).getNullables(), true);
                holder.registerProblem(annotation2 != null ? annotation2 : method.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.Nullable.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(method), NullableStuffInspectionBase.getPresentableAnnoName(superMethod)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                break;
            }
            if (!this.isNonAnnotatedOverridingNotNull(method, superMethod)) continue;
            holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.method.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(superMethod)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createFixForNonAnnotatedOverridesNotNull(method, superMethod));
            break;
        }
    }

    private NullableNotNullManager getNullityManager(PsiMethod method) {
        return NullableNotNullManager.getInstance(method.getProject());
    }

    private LocalQuickFix createFixForNonAnnotatedOverridesNotNull(PsiMethod method, PsiMethod superMethod) {
        NullableNotNullManager nullableManager = this.getNullityManager(method);
        String defaultNotNull = nullableManager.getDefaultNotNull();
        String[] annotationsToRemove = ArrayUtil.toStringArray(nullableManager.getNullables());
        return AnnotationUtil.isAnnotatingApplicable(method, defaultNotNull) ? NullableStuffInspectionBase.createAnnotateMethodFix(defaultNotNull, annotationsToRemove, method) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, superMethod);
    }

    private boolean isNullableOverridingNotNull(Annotated methodInfo, PsiMethod superMethod) {
        return this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && methodInfo.isDeclaredNullable && NullableStuffInspectionBase.isNotNullNotInferred(superMethod, true, false);
    }

    private boolean isNonAnnotatedOverridingNotNull(PsiMethod method, PsiMethod superMethod) {
        return this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !(method.getReturnType() instanceof PsiPrimitiveType) && !method.isConstructor() && !this.getNullityManager(method).hasNullability(method) && NullableStuffInspectionBase.isNotNullNotInferred(superMethod, true, this.IGNORE_EXTERNAL_SUPER_NOTNULL) && !NullableStuffInspectionBase.hasInheritableNotNull(superMethod);
    }

    private static boolean hasInheritableNotNull(PsiModifierListOwner owner) {
        return AnnotationUtil.isAnnotated(owner, "javax.annotation.constraints.NotNull", true);
    }

    private void checkParameters(PsiMethod method, ProblemsHolder holder, List<PsiMethod> superMethods, NullableNotNullManager nullableManager, boolean isOnFly) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            PsiParameter parameter = parameters2[i];
            ArrayList<PsiParameter> superParameters = ContainerUtil.newArrayList();
            for (PsiMethod superMethod : superMethods) {
                PsiParameter[] _superParameters = superMethod.getParameterList().getParameters();
                if (_superParameters.length != parameters2.length) continue;
                superParameters.add(_superParameters[i]);
            }
            if (this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE) {
                for (PsiParameter superParameter : superParameters) {
                    if (!NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false) || !NullableStuffInspectionBase.isNullableNotInferred(superParameter, false)) continue;
                    PsiAnnotation annotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, nullableManager.getNotNulls(), true);
                    holder.registerProblem(annotation2 != null ? annotation2 : parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.NotNull.parameter.overrides.Nullable", NullableStuffInspectionBase.getPresentableAnnoName(parameter), NullableStuffInspectionBase.getPresentableAnnoName(superParameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    break;
                }
            }
            if (this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability(parameter) || !NullableStuffInspectionBase.isNotNullNotInferred(superParameter, false, this.IGNORE_EXTERNAL_SUPER_NOTNULL) || NullableStuffInspectionBase.hasInheritableNotNull(superParameter)) continue;
                    LocalQuickFix fix = AnnotationUtil.isAnnotatingApplicable(parameter, nullableManager.getDefaultNotNull()) ? new AddNotNullAnnotationFix(parameter) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, superParameter);
                    holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.parameter.overrides.NotNull", NullableStuffInspectionBase.getPresentableAnnoName(superParameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
                    break;
                }
            }
            if (this.REPORT_NOTNULL_PARAMETERS_OVERRIDES_NOT_ANNOTATED) {
                for (PsiParameter superParameter : superParameters) {
                    if (nullableManager.hasNullability(superParameter) || !NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false)) continue;
                    PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation(parameter, false);
                    assert (notNullAnnotation != null);
                    boolean physical = PsiTreeUtil.isAncestor(parameter, notNullAnnotation, true);
                    RemoveAnnotationQuickFix fix = physical ? new RemoveAnnotationQuickFix(notNullAnnotation, parameter) : null;
                    holder.registerProblem(physical ? notNullAnnotation : parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.NotNull.parameter.overrides.not.annotated", NullableStuffInspectionBase.getPresentableAnnoName(parameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
                    break;
                }
            }
            this.checkNullLiteralArgumentOfNotNullParameterUsages(method, holder, nullableManager, isOnFly, i, parameter);
        }
    }

    private void checkNullLiteralArgumentOfNotNullParameterUsages(PsiMethod method, ProblemsHolder holder, NullableNotNullManager nullableManager, boolean isOnFly, int parameterIdx, PsiParameter parameter) {
        if (this.REPORT_NULLS_PASSED_TO_NOT_NULL_PARAMETER && isOnFly && NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false)) {
            PsiAnnotation notNullAnnotation = nullableManager.getNotNullAnnotation(parameter, false);
            if (JavaNullMethodArgumentUtil.hasNullArgument(method, parameterIdx)) {
                boolean physical = PsiTreeUtil.isAncestor(parameter, notNullAnnotation, true);
                holder.registerProblem(physical ? notNullAnnotation : parameter.getNameIdentifier(), InspectionsBundle.message("inspection.nullable.problems.NotNull.parameter.receives.null.literal", NullableStuffInspectionBase.getPresentableAnnoName(parameter)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.createNavigateToNullParameterUsagesFix(parameter));
            }
        }
    }

    private void checkOverriders(@NotNull PsiMethod method, @NotNull ProblemsHolder holder, @NotNull Annotated annotated, @NotNull NullableNotNullManager nullableManager) {
        if (method == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(17);
        }
        if (holder == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(18);
        }
        if (annotated == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(19);
        }
        if (nullableManager == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(20);
        }
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters2.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters2.length];
            boolean hasAnnotatedParameter = false;
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter = parameters2[i];
                parameterAnnotated[i] = NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false) && !NullableStuffInspectionBase.hasInheritableNotNull(parameter);
                hasAnnotatedParameter |= parameterAnnotated[i];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull && !NullableStuffInspectionBase.hasInheritableNotNull(method)) {
                PsiManager manager = method.getManager();
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable(method, defaultNotNull);
                PsiMethod[] overridings = OverridingMethodsSearch.search(method).toArray((PsiMethod[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject(overriding)) continue;
                    boolean applicable = AnnotationUtil.isAnnotatingApplicable(overriding, defaultNotNull);
                    boolean ableToAddNotNullAnnotation = AddAnnotationPsiFix.isAvailable(overriding, defaultNotNull);
                    if (!methodQuickFixSuggested && annotated.isDeclaredNotNull && !NullableStuffInspectionBase.isNotNullNotInferred(overriding, false, false) && (NullableStuffInspectionBase.isNullableNotInferred(overriding, false) || !NullableStuffInspectionBase.isNullableNotInferred(overriding, true)) && ableToAddNotNullAnnotation) {
                        PsiIdentifier identifier = method.getNameIdentifier();
                        PsiAnnotation annotation2 = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, nullableManager.getNotNulls());
                        String[] annotationsToRemove = ArrayUtil.toStringArray(nullableManager.getNullables());
                        LocalQuickFix fix = applicable ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, method));
                        PsiElement psiElement = annotation2;
                        if (!annotation2.isPhysical() && (psiElement = identifier) == null) continue;
                        holder.registerProblem(psiElement, InspectionsBundle.message("nullable.stuff.problems.overridden.methods.are.not.annotated", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fix);
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter || !ableToAddNotNullAnnotation) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i = 0; i < psiParameters.length; ++i) {
                        PsiAnnotation annotation3;
                        if (parameterQuickFixSuggested[i]) continue;
                        PsiParameter parameter = psiParameters[i];
                        if (!parameterAnnotated[i] || NullableStuffInspectionBase.isNotNullNotInferred(parameter, false, false) || NullableStuffInspectionBase.isNullableNotInferred(parameter, false)) continue;
                        PsiIdentifier identifier = parameters2[i].getNameIdentifier();
                        PsiElement psiElement = annotation3 = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters2[i], nullableManager.getNotNulls());
                        if ((annotation3 == null || !annotation3.isPhysical()) && (psiElement = identifier) == null) continue;
                        holder.registerProblem(psiElement, InspectionsBundle.message("nullable.stuff.problems.overridden.method.parameters.are.not.annotated", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, !applicable ? NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, parameters2[i]) : new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable()));
                        parameterQuickFixSuggested[i] = true;
                    }
                }
            }
        }
    }

    private static boolean isNotNullNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases, boolean skipExternal) {
        Project project;
        NullableNotNullManager manager;
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(21);
        }
        if (!(manager = NullableNotNullManager.getInstance(project = owner.getProject())).isNotNull(owner, checkBases)) {
            return false;
        }
        if (DfaPsiUtil.getTypeNullability(NullableStuffInspectionBase.getMemberType(owner)) == Nullness.NOT_NULL) {
            return true;
        }
        PsiAnnotation anno = manager.getNotNullAnnotation(owner, checkBases);
        if (anno == null || AnnotationUtil.isInferredAnnotation(anno)) {
            return false;
        }
        return !skipExternal || !AnnotationUtil.isExternalAnnotation(anno);
    }

    public static boolean isNullableNotInferred(@NotNull PsiModifierListOwner owner, boolean checkBases) {
        Project project;
        NullableNotNullManager manager;
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(22);
        }
        if (!(manager = NullableNotNullManager.getInstance(project = owner.getProject())).isNullable(owner, checkBases)) {
            return false;
        }
        if (DfaPsiUtil.getTypeNullability(NullableStuffInspectionBase.getMemberType(owner)) == Nullness.NULLABLE) {
            return true;
        }
        PsiAnnotation anno = manager.getNullableAnnotation(owner, checkBases);
        return anno == null || !AnnotationUtil.isInferredAnnotation(anno);
    }

    private static PsiType getMemberType(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            NullableStuffInspectionBase.$$$reportNull$$$0(23);
        }
        return owner instanceof PsiMethod ? ((PsiMethod)owner).getReturnType() : (owner instanceof PsiVariable ? ((PsiVariable)owner).getType() : null);
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(modifierListOwner, nullableManager.getNotNulls());
        if (annotation2 != null && (referenceElement = annotation2.getNameReferenceElement()) != null && referenceElement.resolve() != null) {
            return new ChangeNullableDefaultsFix(annotation2.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    private static AddAnnotationPsiFix createAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove, PsiMethod method) {
        return new AddAnnotationPsiFix(defaultNotNull, method, PsiNameValuePair.EMPTY_ARRAY, annotationsToRemove);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = InspectionsBundle.message("inspection.nullable.problems.Nullable.NotNull.conflict", NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull));
        holder.registerProblem(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement(), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveAnnotationQuickFix(declaredNotNull, listOwner));
        holder.registerProblem(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement(), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new RemoveAnnotationQuickFix(declaredNullable, listOwner));
    }

    @Override
    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase";
                break;
            }
            case 10: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullableManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/nullable/NullableStuffInspectionBase";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createAddAnnotationFix";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableAnnoName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkMethodReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkNonStandardAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessors";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "checkNotNullFieldsInitialized";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkConstructorParameters";
                break;
            }
            case 10: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableAnnoName";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkOverriders";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullNotInferred";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isNullableNotInferred";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getMemberType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        public MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        @NotNull
        protected String getPreposition() {
            if ("as" == null) {
                MyAnnotateMethodFix.$$$reportNull$$$0(0);
            }
            return "as";
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        protected boolean annotateSelf() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix", "getPreposition"));
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

