/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unneededThrows;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsDeclarationInspection;
import com.intellij.codeInspection.unneededThrows.RedundantThrowsGraphAnnotator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.SyntheticElement;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.JavaOverridingMethodUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantThrowsDeclarationLocalInspection
extends AbstractBaseJavaLocalInspectionTool
implements CleanupLocalInspectionTool {
    private final RedundantThrowsDeclarationInspection myGlobalTool;

    public RedundantThrowsDeclarationLocalInspection() {
        this(new RedundantThrowsDeclarationInspection());
    }

    public RedundantThrowsDeclarationLocalInspection(@NotNull RedundantThrowsDeclarationInspection tool) {
        if (tool == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(0);
        }
        this.myGlobalTool = tool;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = this.myGlobalTool.getGroupDisplayName();
        if (string == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myGlobalTool.getDisplayName();
        if (string == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        String string = this.myGlobalTool.getShortName();
        if (string == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @Nullable
    public ProblemDescriptor[] checkMethod(@NotNull PsiMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(4);
        }
        if (manager == null) {
            RedundantThrowsDeclarationLocalInspection.$$$reportNull$$$0(5);
        }
        return this.checkExceptionsNeverThrown(method, manager);
    }

    @Nullable
    private ProblemDescriptor[] checkExceptionsNeverThrown(PsiMethod method, InspectionManager inspectionManager) {
        if (method instanceof SyntheticElement) {
            return null;
        }
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || JavaHighlightUtil.isSerializationRelatedMethod(method, containingClass)) {
            return null;
        }
        PsiCodeBlock body = method.getBody();
        if (body == null) {
            return null;
        }
        if (this.myGlobalTool.IGNORE_ENTRY_POINTS && UnusedDeclarationInspectionBase.isDeclaredAsEntryPoint(method)) {
            return null;
        }
        ReferenceAndType[] thrownExceptions = RedundantThrowsDeclarationLocalInspection.getThrownCheckedExceptions(method);
        if (thrownExceptions.length == 0) {
            return null;
        }
        PsiModifierList modifierList = method.getModifierList();
        boolean needCheckOverridingMethods = !modifierList.hasModifierProperty("private") && !modifierList.hasModifierProperty("static") && !modifierList.hasModifierProperty("final") && !method.isConstructor() && !(containingClass instanceof PsiAnonymousClass) && !containingClass.hasModifierProperty("final");
        Set<PsiClassType> unhandled = RedundantThrowsGraphAnnotator.getUnhandledExceptions(body, method, containingClass);
        List candidates2 = Arrays.stream(thrownExceptions).filter(refAndType -> unhandled.stream().noneMatch(unhandledException -> unhandledException.isAssignableFrom(((ReferenceAndType)refAndType).type) || ((ReferenceAndType)refAndType).type.isAssignableFrom((PsiType)unhandledException))).collect(Collectors.toList());
        if (candidates2.isEmpty()) {
            return null;
        }
        if (needCheckOverridingMethods) {
            Set thrownExceptionShortNames = candidates2.stream().map(refAndType -> ((ReferenceAndType)refAndType).type.getClassName()).collect(Collectors.toSet());
            Predicate<PsiMethod> methodContainsThrownExceptions = m -> Arrays.stream(m.getThrowsList().getReferencedTypes()).map(PsiClassType::getClassName).anyMatch(thrownExceptionShortNames::contains);
            Stream<PsiMethod> overridingMethods = JavaOverridingMethodUtil.getOverridingMethodsIfCheapEnough(method, null, methodContainsThrownExceptions);
            if (overridingMethods == null) {
                return null;
            }
            Iterator overridingMethodIt = overridingMethods.iterator();
            while (overridingMethodIt.hasNext()) {
                PsiMethod m2 = (PsiMethod)overridingMethodIt.next();
                PsiClassType[] overridingMethodThrownException = m2.getThrowsList().getReferencedTypes();
                candidates2.removeIf(refAndType -> {
                    PsiClassType type2 = ((ReferenceAndType)refAndType).type;
                    return ArrayUtil.contains(type2, overridingMethodThrownException);
                });
                if (!candidates2.isEmpty()) continue;
                return null;
            }
        }
        return (ProblemDescriptor[])candidates2.stream().map(exceptionType -> {
            PsiJavaCodeReferenceElement reference = ((ReferenceAndType)exceptionType).ref;
            String description2 = JavaErrorMessages.message("exception.is.never.thrown", JavaHighlightUtil.formatType(((ReferenceAndType)exceptionType).type));
            MethodThrowsFix quickFix = new MethodThrowsFix(method, ((ReferenceAndType)exceptionType).type, false, false);
            return inspectionManager.createProblemDescriptor((PsiElement)reference, description2, quickFix, ProblemHighlightType.LIKE_UNUSED_SYMBOL, true);
        }).toArray(ProblemDescriptor[]::new);
    }

    private static ReferenceAndType[] getThrownCheckedExceptions(PsiMethod method) {
        return (ReferenceAndType[])Stream.of(method.getThrowsList().getReferenceElements()).map(ref -> {
            PsiElement resolved = ref.resolve();
            return resolved instanceof PsiClass && !ExceptionUtil.isUncheckedException((PsiClass)resolved) ? new ReferenceAndType((PsiJavaCodeReferenceElement)ref) : null;
        }).filter(Objects::nonNull).toArray(ReferenceAndType[]::new);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ReferenceAndType {
        private final PsiJavaCodeReferenceElement ref;
        private final PsiClassType type;

        private ReferenceAndType(@NotNull PsiJavaCodeReferenceElement ref) {
            if (ref == null) {
                ReferenceAndType.$$$reportNull$$$0(0);
            }
            this.ref = ref;
            this.type = JavaPsiFacade.getElementFactory(ref.getProject()).createType(ref);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/codeInspection/unneededThrows/RedundantThrowsDeclarationLocalInspection$ReferenceAndType", "<init>"));
        }
    }
}

