/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.varScopeCanBeNarrowed;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.ImplicitUsageProvider;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.SpecialAnnotationsUtilBase;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AllVariablesControlFlowPolicy;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FieldCanBeLocalInspectionBase
extends AbstractBaseJavaLocalInspectionTool {
    @NonNls
    public static final String SHORT_NAME = "FieldCanBeLocal";
    public final JDOMExternalizableStringList EXCLUDE_ANNOS = new JDOMExternalizableStringList();
    public boolean IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS = true;

    private void doCheckClass(PsiClass aClass2, ProblemsHolder holder, List<String> excludeAnnos, boolean ignoreFieldsUsedInMultipleMethods) {
        if (aClass2.isInterface()) {
            return;
        }
        PsiField[] fields2 = aClass2.getFields();
        LinkedHashSet<PsiField> candidates2 = new LinkedHashSet<PsiField>();
        for (PsiField field : fields2) {
            if (AnnotationUtil.isAnnotated(field, excludeAnnos) || !field.hasModifierProperty("private") || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
            candidates2.add(field);
        }
        FieldCanBeLocalInspectionBase.removeFieldsReferencedFromInitializers(aClass2, candidates2);
        if (candidates2.isEmpty()) {
            return;
        }
        THashSet<PsiField> usedFields = new THashSet<PsiField>();
        FieldCanBeLocalInspectionBase.removeReadFields(aClass2, candidates2, usedFields, ignoreFieldsUsedInMultipleMethods);
        if (candidates2.isEmpty()) {
            return;
        }
        ImplicitUsageProvider[] implicitUsageProviders = Extensions.getExtensions(ImplicitUsageProvider.EP_NAME);
        for (PsiField field : candidates2) {
            if (!usedFields.contains(field) || FieldCanBeLocalInspectionBase.hasImplicitReadOrWriteUsage(field, implicitUsageProviders) || !ReferencesSearch.search(field, new LocalSearchScope(aClass2)).forEach(reference -> {
                PsiElement element = reference.getElement();
                if (element instanceof PsiReferenceExpression) {
                    PsiElement qualifier = ((PsiReferenceExpression)element).getQualifier();
                    return qualifier == null || qualifier instanceof PsiThisExpression && ((PsiThisExpression)qualifier).getQualifier() == null;
                }
                return true;
            })) continue;
            String message = InspectionsBundle.message("inspection.field.can.be.local.problem.descriptor", new Object[0]);
            ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
            SpecialAnnotationsUtilBase.createAddToSpecialAnnotationFixes(field, qualifiedName2 -> {
                LocalQuickFix quickFix = SpecialAnnotationsUtilBase.createAddToSpecialAnnotationsListQuickFix(InspectionGadgetsBundle.message("add.0.to.ignore.if.annotated.by.list.quickfix", qualifiedName2), QuickFixBundle.message("fix.add.special.annotation.family", new Object[0]), this.EXCLUDE_ANNOS, qualifiedName2, field);
                fixes.add(quickFix);
                return true;
            });
            LocalQuickFix fix = this.createFix();
            if (fix != null) {
                fixes.add(fix);
            }
            holder.registerProblem((PsiElement)field.getNameIdentifier(), message, fixes.toArray(new LocalQuickFix[fixes.size()]));
        }
    }

    protected LocalQuickFix createFix() {
        return null;
    }

    private static void removeFieldsReferencedFromInitializers(final PsiClass aClass2, final Set<PsiField> candidates2) {
        aClass2.accept(new JavaRecursiveElementVisitor(){

            @Override
            public void visitMethod(PsiMethod method) {
                PsiDocComment docComment;
                PsiMethod resolveMethod;
                PsiExpression expression2;
                PsiStatement[] statements;
                PsiCodeBlock body;
                if (method.isConstructor() && (body = method.getBody()) != null && (statements = body.getStatements()).length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (resolveMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && resolveMethod.isConstructor()) {
                    this.visitMethodCallExpression((PsiMethodCallExpression)expression2);
                }
                if ((docComment = method.getDocComment()) != null) {
                    docComment.accept(this);
                }
            }

            @Override
            public void visitClassInitializer(PsiClassInitializer initializer2) {
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression2) {
                this.excludeFieldCandidate(expression2);
                super.visitReferenceExpression(expression2);
            }

            @Override
            public void visitDocTagValue(PsiDocTagValue value) {
                this.excludeFieldCandidate(value.getReference());
                super.visitDocTagValue(value);
            }

            private void excludeFieldCandidate(PsiReference ref) {
                PsiField field;
                if (ref == null) {
                    return;
                }
                PsiElement resolved = ref.resolve();
                if (resolved instanceof PsiField && aClass2.equals((field = (PsiField)resolved).getContainingClass())) {
                    candidates2.remove(field);
                }
            }
        });
    }

    private static void removeReadFields(PsiClass aClass2, final Set<PsiField> candidates2, final Set<PsiField> usedFields, final boolean ignoreFieldsUsedInMultipleMethods) {
        final HashSet ignored = new HashSet();
        aClass2.accept(new JavaRecursiveElementWalkingVisitor(){

            @Override
            public void visitElement(PsiElement element) {
                if (!candidates2.isEmpty()) {
                    super.visitElement(element);
                }
            }

            @Override
            public void visitMethod(PsiMethod method) {
                super.visitMethod(method);
                PsiCodeBlock body = method.getBody();
                if (body != null) {
                    FieldCanBeLocalInspectionBase.checkCodeBlock(body, candidates2, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
                }
            }

            @Override
            public void visitLambdaExpression(PsiLambdaExpression expression2) {
                super.visitLambdaExpression(expression2);
                PsiElement body = expression2.getBody();
                if (body != null) {
                    FieldCanBeLocalInspectionBase.checkCodeBlock(body, candidates2, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
                }
            }

            @Override
            public void visitClassInitializer(PsiClassInitializer initializer2) {
                super.visitClassInitializer(initializer2);
                FieldCanBeLocalInspectionBase.checkCodeBlock(initializer2.getBody(), candidates2, usedFields, ignoreFieldsUsedInMultipleMethods, ignored);
            }
        });
    }

    private static void checkCodeBlock(PsiElement body, Set<PsiField> candidates2, Set<PsiField> usedFields, boolean ignoreFieldsUsedInMultipleMethods, Set<PsiField> ignored) {
        try {
            Ref<Collection<PsiVariable>> writtenVariables = new Ref<Collection<PsiVariable>>();
            ControlFlow controlFlow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow(body, AllVariablesControlFlowPolicy.getInstance(), false, false);
            List<PsiVariable> usedVars = ControlFlowUtil.getUsedVariables(controlFlow, 0, controlFlow.getSize());
            for (PsiVariable usedVariable : usedVars) {
                if (!(usedVariable instanceof PsiField)) continue;
                PsiField usedField = (PsiField)usedVariable;
                if (!FieldCanBeLocalInspectionBase.getWrittenVariables(controlFlow, writtenVariables).contains(usedField)) {
                    ignored.add(usedField);
                }
                if (usedFields.add(usedField) || !ignoreFieldsUsedInMultipleMethods && !ignored.contains(usedField)) continue;
                candidates2.remove(usedField);
            }
            if (candidates2.isEmpty()) {
                return;
            }
            List<PsiReferenceExpression> readBeforeWrites = ControlFlowUtil.getReadBeforeWrite(controlFlow);
            for (PsiReferenceExpression readBeforeWrite : readBeforeWrites) {
                PsiElement parent2;
                PsiField field;
                PsiElement resolved = readBeforeWrite.resolve();
                if (!(resolved instanceof PsiField) || FieldCanBeLocalInspectionBase.isImmutableState((field = (PsiField)resolved).getType()) && PsiUtil.isConstantExpression(field.getInitializer()) && !FieldCanBeLocalInspectionBase.getWrittenVariables(controlFlow, writtenVariables).contains(field) || (parent2 = body.getParent()) instanceof PsiMethod && ((PsiMethod)parent2).isConstructor() && field.getInitializer() != null && !field.hasModifierProperty("static") && PsiTreeUtil.isAncestor(((PsiMethod)parent2).getContainingClass(), field, true)) continue;
                candidates2.remove(field);
            }
        }
        catch (AnalysisCanceledException e) {
            candidates2.clear();
        }
    }

    private static boolean isImmutableState(PsiType type2) {
        return type2 instanceof PsiPrimitiveType || PsiPrimitiveType.getUnboxedType(type2) != null || Comparing.strEqual("java.lang.String", type2.getCanonicalText());
    }

    private static Collection<PsiVariable> getWrittenVariables(ControlFlow controlFlow, Ref<Collection<PsiVariable>> writtenVariables) {
        if (writtenVariables.get() == null) {
            writtenVariables.set(ControlFlowUtil.getWrittenVariables(controlFlow, 0, controlFlow.getSize(), false));
        }
        return writtenVariables.get();
    }

    private static boolean hasImplicitReadOrWriteUsage(PsiField field, ImplicitUsageProvider[] implicitUsageProviders) {
        for (ImplicitUsageProvider provider : implicitUsageProviders) {
            if (!provider.isImplicitRead(field) && !provider.isImplicitWrite(field)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CLASS_LAYOUT_GROUP_NAME;
        if (string == null) {
            FieldCanBeLocalInspectionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message("inspection.field.can.be.local.display.name", new Object[0]);
        if (string == null) {
            FieldCanBeLocalInspectionBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getShortName() {
        if (SHORT_NAME == null) {
            FieldCanBeLocalInspectionBase.$$$reportNull$$$0(2);
        }
        return SHORT_NAME;
    }

    @Override
    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            FieldCanBeLocalInspectionBase.$$$reportNull$$$0(3);
        }
        if (!this.EXCLUDE_ANNOS.isEmpty() || !this.IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS) {
            super.writeSettings(node);
        }
    }

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FieldCanBeLocalInspectionBase.$$$reportNull$$$0(4);
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            @Override
            public void visitJavaFile(PsiJavaFile file2) {
                for (PsiClass aClass2 : file2.getClasses()) {
                    FieldCanBeLocalInspectionBase.this.doCheckClass(aClass2, holder, FieldCanBeLocalInspectionBase.this.EXCLUDE_ANNOS, FieldCanBeLocalInspectionBase.this.IGNORE_FIELDS_USED_IN_MULTIPLE_METHODS);
                }
            }
        };
        if (javaElementVisitor == null) {
            FieldCanBeLocalInspectionBase.$$$reportNull$$$0(5);
        }
        return javaElementVisitor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspectionBase";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/varScopeCanBeNarrowed/FieldCanBeLocalInspectionBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeSettings";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

