/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.iterators;

import com.intellij.dupLocator.iterators.NodeIterator;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.psi.PsiElement;

public class FilteringNodeIterator
extends NodeIterator {
    private final NodeIterator delegate;
    private final NodeFilter filter;

    private void advanceToNext() {
        while (this.delegate.hasNext() && this.filter.accepts(this.delegate.current())) {
            this.delegate.advance();
        }
    }

    private void rewindToPrevious() {
        while (this.filter.accepts(this.delegate.current())) {
            this.delegate.rewind();
        }
    }

    public FilteringNodeIterator(NodeIterator iterator2, NodeFilter filter2) {
        this.delegate = iterator2;
        this.filter = filter2;
        this.advanceToNext();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext() && !this.filter.accepts(this.delegate.current());
    }

    @Override
    public void rewind(int number) {
        while (number > 0) {
            this.delegate.rewind();
            this.rewindToPrevious();
            --number;
        }
    }

    @Override
    public PsiElement current() {
        return this.delegate.current();
    }

    @Override
    public void advance() {
        this.delegate.advance();
        this.advanceToNext();
    }

    @Override
    public void rewind() {
        this.delegate.rewind();
        this.rewindToPrevious();
    }

    @Override
    public void reset() {
        this.delegate.reset();
        this.advanceToNext();
    }
}

