/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.DuplicatesProfileCache;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.GroupNodeDescription;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.usageView.UsageInfo;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectProcedure;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntIterator;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class DuplocatorHashCallback
implements FragmentsCollector {
    private static final Logger LOG = Logger.getInstance("#com.intellij.dupLocator.treeHash.DuplocatorHashCallback");
    private TIntObjectHashMap<List<List<PsiFragment>>> myDuplicates = new TIntObjectHashMap();
    private final int myBound;
    private boolean myReadOnly = false;
    private final int myDiscardCost;

    public DuplocatorHashCallback(int bound, int discardCost) {
        this.myBound = bound;
        this.myDiscardCost = discardCost;
    }

    public DuplocatorHashCallback(int bound, int discardCost, boolean readOnly) {
        this(bound, discardCost);
        this.myReadOnly = readOnly;
    }

    public DuplocatorHashCallback(int lowerBound) {
        this(lowerBound, 0);
    }

    public void setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
    }

    public void add(int hash, int cost, PsiFragment frag, NodeSpecificHasher visitor2) {
        this.forceAdd(hash, cost, frag);
    }

    private void forceAdd(int hash, int cost, PsiFragment frag) {
        if (frag == null) {
            this.myDuplicates.put(hash, new ArrayList());
            return;
        }
        frag.setCost(cost);
        List<List<PsiFragment>> fragments2 = this.myDuplicates.get(hash);
        if (fragments2 == null) {
            if (!this.myReadOnly) {
                ArrayList list2 = new ArrayList();
                ArrayList<PsiFragment> listf = new ArrayList<PsiFragment>();
                listf.add(frag);
                list2.add(listf);
                this.myDuplicates.put(hash, list2);
            }
            return;
        }
        boolean found = false;
        PsiElement[] elements = frag.getElements();
        int discardCost = 0;
        if (this.myDiscardCost >= 0) {
            discardCost = this.myDiscardCost;
        } else {
            DuplocatorState state2 = DuplocatorUtil.getDuplocatorState(frag);
            if (state2 != null) {
                discardCost = state2.getDiscardCost();
            }
        }
        Iterator<List<PsiFragment>> i = fragments2.iterator();
        while (i.hasNext() && !found) {
            List<PsiFragment> fi = i.next();
            PsiFragment aFrag = fi.get(0);
            if (!aFrag.isEqual(elements, discardCost)) continue;
            boolean skipNew = false;
            Iterator<PsiFragment> frags = fi.iterator();
            while (frags.hasNext() && !skipNew) {
                PsiFragment old = frags.next();
                if (!frag.intersectsWith(old)) continue;
                if (old.getCost() < frag.getCost() || frag.contains(old)) {
                    frags.remove();
                    continue;
                }
                skipNew = true;
            }
            if (!skipNew) {
                fi.add(frag);
            }
            found = true;
        }
        if (!found) {
            ArrayList<PsiFragment> newFrags = new ArrayList<PsiFragment>();
            newFrags.add(frag);
            fragments2.add(newFrags);
        }
    }

    @Override
    public void add(int hash, int cost, PsiFragment frag) {
        int bound;
        if (this.myBound >= 0) {
            bound = this.myBound;
        } else {
            DuplocatorState duplocatorState = DuplocatorUtil.getDuplocatorState(frag);
            if (duplocatorState == null) {
                return;
            }
            bound = duplocatorState.getLowerBound();
        }
        if (cost >= bound) {
            this.forceAdd(hash, cost, frag);
        }
    }

    public DupInfo getInfo() {
        final TObjectIntHashMap duplicateList = new TObjectIntHashMap();
        this.myDuplicates.forEachEntry(new TIntObjectProcedure<List<List<PsiFragment>>>(){

            @Override
            public boolean execute(int hash, List<List<PsiFragment>> listList) {
                for (List<PsiFragment> list2 : listList) {
                    int len = list2.size();
                    if (len <= 1) continue;
                    PsiFragment[] filtered = new PsiFragment[len];
                    int idx = 0;
                    for (PsiFragment fragment : list2) {
                        fragment.markDuplicate();
                        filtered[idx++] = fragment;
                    }
                    duplicateList.put(filtered, hash);
                }
                return true;
            }
        });
        this.myDuplicates = null;
        TObjectIntIterator dups = duplicateList.iterator();
        while (dups.hasNext()) {
            dups.advance();
            PsiFragment[] fragments2 = (PsiFragment[])dups.key();
            LOG.assertTrue(fragments2.length > 1);
            boolean nested = false;
            for (PsiFragment fragment : fragments2) {
                if (!fragment.isNested()) continue;
                nested = true;
                break;
            }
            if (!nested) continue;
            dups.remove();
        }
        final Object[] duplicates = duplicateList.keys();
        Arrays.sort(duplicates, (x, y) -> ((PsiFragment[])y)[0].getCost() - ((PsiFragment[])x)[0].getCost());
        return new DupInfo(){
            private final TIntObjectHashMap<GroupNodeDescription> myPattern2Description = new TIntObjectHashMap();

            @Override
            public int getPatterns() {
                return duplicates.length;
            }

            @Override
            public int getPatternCost(int number) {
                return ((PsiFragment[])duplicates[number])[0].getCost();
            }

            @Override
            public int getPatternDensity(int number) {
                return ((PsiFragment[])duplicates[number]).length;
            }

            @Override
            public PsiFragment[] getFragmentOccurences(int pattern) {
                return (PsiFragment[])duplicates[pattern];
            }

            @Override
            public UsageInfo[] getUsageOccurences(int pattern) {
                PsiFragment[] occs = this.getFragmentOccurences(pattern);
                UsageInfo[] infos2 = new UsageInfo[occs.length];
                for (int i = 0; i < infos2.length; ++i) {
                    infos2[i] = occs[i].getUsageInfo();
                }
                return infos2;
            }

            @Override
            public int getFileCount(int pattern) {
                if (this.myPattern2Description.containsKey(pattern)) {
                    return this.myPattern2Description.get(pattern).getFilesCount();
                }
                return this.cacheGroupNodeDescription(pattern).getFilesCount();
            }

            private GroupNodeDescription cacheGroupNodeDescription(int pattern) {
                PsiFragment[] occurencies;
                HashSet<PsiFile> files2 = new HashSet<PsiFile>();
                for (PsiFragment occurency : occurencies = this.getFragmentOccurences(pattern)) {
                    PsiFile file2 = occurency.getFile();
                    if (file2 == null) continue;
                    files2.add(file2);
                }
                int fileCount = files2.size();
                PsiFile psiFile = occurencies[0].getFile();
                DuplicatesProfile profile2 = DuplicatesProfileCache.getProfile(this, pattern);
                String comment = profile2 != null ? profile2.getComment(this, pattern) : "";
                GroupNodeDescription description2 = new GroupNodeDescription(fileCount, psiFile != null ? psiFile.getName() : "unknown", comment);
                this.myPattern2Description.put(pattern, description2);
                return description2;
            }

            @Override
            @Nullable
            public String getTitle(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return this.myPattern2Description.get(pattern).getTitle();
                    }
                    return this.cacheGroupNodeDescription(pattern).getTitle();
                }
                return null;
            }

            @Override
            @Nullable
            public String getComment(int pattern) {
                if (this.getFileCount(pattern) == 1) {
                    if (this.myPattern2Description.containsKey(pattern)) {
                        return this.myPattern2Description.get(pattern).getComment();
                    }
                    return this.cacheGroupNodeDescription(pattern).getComment();
                }
                return null;
            }

            @Override
            public int getHash(int i) {
                return duplicateList.get((PsiFragment[])duplicates[i]);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(String path2, Project project) throws IOException {
        PrettyPrintWriter writer;
        int[] hashCodes = this.myDuplicates.keys();
        try (OutputStreamWriter fileWriter = null;){
            fileWriter = new FileWriter(path2 + File.separator + "fragments.xml");
            writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("root");
            for (int hash : hashCodes) {
                List<List<PsiFragment>> dupList = this.myDuplicates.get(hash);
                writer.startNode("hash");
                writer.addAttribute("val", String.valueOf(hash));
                for (List<PsiFragment> psiFragments : dupList) {
                    DuplocatorHashCallback.writeFragments(psiFragments, writer, project, false);
                }
                writer.endNode();
            }
            writer.endNode();
            writer.flush();
        }
        fileWriter = null;
        try {
            fileWriter = new FileWriter(path2 + File.separator + "duplicates.xml");
            writer = new PrettyPrintWriter((Writer)fileWriter);
            writer.startNode("root");
            DupInfo info = this.getInfo();
            int patterns = info.getPatterns();
            for (int i = 0; i < patterns; ++i) {
                writer.startNode("duplicate");
                writer.addAttribute("cost", String.valueOf(info.getPatternCost(i)));
                writer.addAttribute("hash", String.valueOf(info.getHash(i)));
                DuplocatorHashCallback.writeFragments(Arrays.asList(info.getFragmentOccurences(i)), writer, project, true);
                writer.endNode();
            }
            writer.endNode();
            writer.flush();
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    private static void writeFragments(List<PsiFragment> psiFragments, PrettyPrintWriter writer, Project project, boolean shouldWriteOffsets) {
        PathMacroManager macroManager = PathMacroManager.getInstance(project);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance(project);
        for (PsiFragment fragment : psiFragments) {
            PsiFile psiFile = fragment.getFile();
            VirtualFile virtualFile2 = psiFile != null ? psiFile.getVirtualFile() : null;
            if (virtualFile2 == null) continue;
            writer.startNode("fragment");
            writer.addAttribute("file", macroManager.collapsePath(virtualFile2.getUrl()));
            if (shouldWriteOffsets) {
                Document document = documentManager.getDocument(psiFile);
                LOG.assertTrue(document != null);
                int startOffset = fragment.getStartOffset();
                int line = document.getLineNumber(startOffset);
                writer.addAttribute("line", String.valueOf(line));
                int lineStartOffset = document.getLineStartOffset(line);
                if (StringUtil.isEmptyOrSpaces(document.getText().substring(lineStartOffset, startOffset))) {
                    startOffset = lineStartOffset;
                }
                writer.addAttribute("start", String.valueOf(startOffset));
                writer.addAttribute("end", String.valueOf(fragment.getEndOffset()));
                if (fragment.containsMultipleFragments()) {
                    int[][] offsets;
                    for (int[] offset2 : offsets = fragment.getOffsets()) {
                        writer.startNode("offset");
                        writer.addAttribute("start", String.valueOf(offset2[0]));
                        writer.addAttribute("end", String.valueOf(offset2[1]));
                        writer.endNode();
                    }
                }
            }
            writer.endNode();
        }
    }
}

