/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import java.util.List;

public class TreeHashingUtils {
    protected static TreeHashResult hashCodeBlockForIndexing(AbstractTreeHasher treeHasher, FragmentsCollector callBack, List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher) {
        int statementsSize = statements.size();
        if (statementsSize > 0) {
            TreePsiFragment fragment = treeHasher.buildFragment(hasher, statements, 0, statementsSize - 1);
            fragment.setParent(upper);
            int cost = 0;
            int hash = 0;
            for (PsiElement psiElement : statements) {
                TreeHashResult res2 = treeHasher.hash(psiElement, null, hasher);
                hash = hash * 31 + res2.getHash();
                cost += res2.getCost();
            }
            TreeHashResult result2 = new TreeHashResult(hash, cost, treeHasher.buildFragment(hasher, statements, 0, statementsSize - 1));
            if (callBack != null && statementsSize > 1) {
                callBack.add(hash, cost, fragment);
            }
            return result2;
        }
        return new TreeHashResult(1, 0, treeHasher.buildFragment(hasher, statements, 0, statementsSize - 1));
    }

    static TreeHashResult computeElementHashForIndexing(AbstractTreeHasher base, FragmentsCollector callBack, PsiElement root2, PsiFragment upper, NodeSpecificHasher hasher) {
        int size;
        List<PsiElement> children2 = hasher.getNodeChildren(root2);
        TreePsiFragment fragment = base.buildFragment(hasher, root2, base.getCost(root2));
        if (upper != null) {
            fragment.setParent(upper);
        }
        if ((size = children2.size()) == 0 && !(root2 instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root2), fragment);
        }
        int discardCost = base.getDiscardCost(root2);
        int c = hasher.getNodeCost(root2);
        int h = hasher.getNodeHash(root2);
        for (int i = 0; i < size; ++i) {
            PsiElement child = children2.get(i);
            TreeHashResult res2 = base.hash(child, fragment, hasher);
            int childCost = res2.getCost();
            c += childCost;
            if (childCost <= discardCost && base.ignoreChildHash(child)) continue;
            h += res2.getHash();
        }
        if (base.shouldAnonymize(root2, hasher)) {
            h = 0;
        }
        if (callBack != null) {
            callBack.add(h, c, fragment);
        }
        return new TreeHashResult(h, c, fragment);
    }
}

