/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import java.util.List;

public class TreePsiFragment
extends PsiFragment {
    private final NodeSpecificHasher myHasher;

    public TreePsiFragment(NodeSpecificHasher hasher, PsiElement root2, int cost) {
        super(root2, cost);
        this.myHasher = hasher;
    }

    public TreePsiFragment(NodeSpecificHasher hasher, List<? extends PsiElement> element, int from, int to) {
        super(element, from, to);
        this.myHasher = hasher;
    }

    @Override
    public boolean isEqual(PsiElement[] elements, int discardCost) {
        if (elements.length != this.myElementAnchors.length) {
            return false;
        }
        for (int i = 0; i < this.myElementAnchors.length; ++i) {
            PsiElement one = this.myElementAnchors[i].retrieve();
            PsiElement two = elements[i];
            if (one != null && two != null && this.myHasher.areTreesEqual(one, two, discardCost)) continue;
            return false;
        }
        return true;
    }
}

