/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.openapi.util.io.FileUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;

public class CommandLineWrapperUtil {
    @NotNull
    public static File createClasspathJarFile(Manifest manifest2, List<String> pathList) throws IOException {
        File file2 = CommandLineWrapperUtil.createClasspathJarFile(manifest2, pathList, false);
        if (file2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @NotNull
    public static File createClasspathJarFile(Manifest manifest2, List<String> pathList, boolean notEscape) throws IOException {
        manifest2.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        StringBuilder classPath = new StringBuilder();
        for (String path2 : pathList) {
            if (classPath.length() > 0) {
                classPath.append(' ');
            }
            File classpathElement = new File(path2);
            String url = (notEscape ? classpathElement.toURL() : classpathElement.toURI().toURL()).toString();
            classPath.append(url);
        }
        manifest2.getMainAttributes().put(Attributes.Name.CLASS_PATH, classPath.toString());
        File jarFile = FileUtil.createTempFile("classpath", ".jar", true);
        new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(jarFile)), manifest2).close();
        File file2 = jarFile;
        if (file2 == null) {
            CommandLineWrapperUtil.$$$reportNull$$$0(1);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/CommandLineWrapperUtil", "createClasspathJarFile"));
    }
}

