/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PairFunction;
import com.intellij.util.text.StringTokenizer;
import com.intellij.xml.util.HtmlUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.Nullable;

public class MicrodataUtil {
    public static final Key<List<String>> ITEM_PROP_KEYS = Key.create("microdata.prop");
    public static final String ITEM_REF = "itemref";
    public static final String ITEM_SCOPE = "itemscope";
    public static final String ITEM_TYPE = "itemtype";
    public static final String ITEM_PROP = "itemprop";
    public static final String ITEM_ID = "itemid";

    public static boolean hasScopeTag(@Nullable XmlTag tag) {
        return MicrodataUtil.findScopeTag(tag) != null;
    }

    @Nullable
    public static XmlTag findScopeTag(@Nullable XmlTag context) {
        Map<String, XmlTag> id2tag = MicrodataUtil.findScopesWithItemRef(context != null ? context.getContainingFile() : null);
        for (XmlTag tag = context; tag != null; tag = tag.getParentTag()) {
            if (tag != context && tag.getAttribute(ITEM_SCOPE) != null) {
                return tag;
            }
            String id = MicrodataUtil.getStripedAttributeValue(tag, "id");
            if (id == null || !id2tag.containsKey(id)) continue;
            return id2tag.get(id);
        }
        return null;
    }

    private static Map<String, XmlTag> findScopesWithItemRef(final @Nullable PsiFile file2) {
        if (!(file2 instanceof XmlFile)) {
            return Collections.emptyMap();
        }
        return CachedValuesManager.getCachedValue(file2, new CachedValueProvider<Map<String, XmlTag>>(){

            @Override
            @Nullable
            public CachedValueProvider.Result<Map<String, XmlTag>> compute() {
                final THashMap result2 = new THashMap();
                file2.accept(new XmlRecursiveElementVisitor(){

                    @Override
                    public void visitXmlTag(XmlTag tag) {
                        super.visitXmlTag(tag);
                        XmlAttribute refAttr = tag.getAttribute(MicrodataUtil.ITEM_REF);
                        if (refAttr != null && tag.getAttribute(MicrodataUtil.ITEM_SCOPE) != null) {
                            MicrodataUtil.getReferencesForAttributeValue(refAttr.getValueElement(), (t, v) -> {
                                result2.put(t, tag);
                                return null;
                            });
                        }
                    }
                });
                return CachedValueProvider.Result.create(result2, file2);
            }
        });
    }

    public static List<String> extractProperties(PsiFile file2, String type2) {
        List<String> result2;
        VirtualFile virtualFile2 = file2.getVirtualFile();
        List<String> list2 = result2 = virtualFile2 != null ? virtualFile2.getUserData(ITEM_PROP_KEYS) : null;
        if (virtualFile2 != null && result2 == null) {
            result2 = MicrodataUtil.collectNames(file2, type2);
            virtualFile2.putUserData(ITEM_PROP_KEYS, result2);
        }
        return result2;
    }

    private static List<String> collectNames(PsiFile file2, String type2) {
        if (file2 instanceof XmlFile) {
            CollectNamesVisitor collectNamesVisitor = MicrodataUtil.getVisitorByType(type2);
            file2.accept(collectNamesVisitor);
            return collectNamesVisitor.getValues();
        }
        return Collections.emptyList();
    }

    private static CollectNamesVisitor getVisitorByType(String type2) {
        if (type2.contains("schema.org")) {
            return new CollectNamesFromSchemaOrgVisitor();
        }
        return new CollectNamesByMicrodataVisitor(type2);
    }

    public static PsiReference[] getUrlReferencesForAttributeValue(XmlAttributeValue element) {
        return MicrodataUtil.getReferencesForAttributeValue(element, (token, offset2) -> {
            if (HtmlUtil.hasHtmlPrefix(token)) {
                TextRange range = TextRange.from(offset2, token.length());
                URLReference urlReference = new URLReference(element, range, true);
                return new DependentNSReference(element, range, urlReference, true);
            }
            return null;
        });
    }

    public static PsiReference[] getReferencesForAttributeValue(@Nullable XmlAttributeValue element, PairFunction<String, Integer, PsiReference> refFun) {
        if (element == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        String text2 = element.getText();
        String urls = StringUtil.unquoteString(text2);
        StringTokenizer tokenizer = new StringTokenizer(urls);
        ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
        while (tokenizer.hasMoreTokens()) {
            int index2;
            String token = tokenizer.nextToken();
            PsiReference ref = refFun.fun(token, index2 = text2.indexOf(token));
            if (ref == null) continue;
            result2.add(ref);
        }
        return result2.toArray(new PsiReference[result2.size()]);
    }

    @Nullable
    public static String getStripedAttributeValue(@Nullable XmlTag tag, @Nls String attributeName) {
        String value = tag != null ? tag.getAttributeValue(attributeName) : null;
        return value != null ? StringUtil.unquoteString(value) : null;
    }

    public static class CollectNamesFromSchemaOrgVisitor
    extends CollectNamesVisitor {
        @Override
        public void visitXmlTag(XmlTag tag) {
            String code;
            super.visitXmlTag(tag);
            if ("prop-nam".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag, "class")) && (code = tag.getSubTagText("code")) != null) {
                this.myValues.add(StringUtil.stripHtml(code, false));
            }
        }
    }

    public static class CollectNamesByMicrodataVisitor
    extends CollectNamesVisitor {
        protected final String myType;
        private boolean myCollecting = false;

        public CollectNamesByMicrodataVisitor(String type2) {
            this.myType = type2;
        }

        @Override
        public void visitXmlTag(XmlTag tag) {
            String value = MicrodataUtil.getStripedAttributeValue(tag, MicrodataUtil.ITEM_ID);
            boolean isTypeTag = this.myType.equalsIgnoreCase(value);
            if (isTypeTag) {
                this.myCollecting = true;
            }
            if (this.myCollecting && "name".equalsIgnoreCase(MicrodataUtil.getStripedAttributeValue(tag, MicrodataUtil.ITEM_PROP))) {
                this.myValues.add(tag.getValue().getTrimmedText());
            }
            super.visitXmlTag(tag);
            if (isTypeTag) {
                this.myCollecting = false;
            }
        }
    }

    private static class CollectNamesVisitor
    extends XmlRecursiveElementVisitor {
        protected final Set<String> myValues = new THashSet<String>();

        private CollectNamesVisitor() {
        }

        public List<String> getValues() {
            return new ArrayList<String>(this.myValues);
        }
    }
}

