/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaAnonymousClassesHelper {
    private static final Key<ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass>> ANONYMOUS_CLASS_NAME = Key.create("ANONYMOUS_CLASS_NAME");
    public static final AnonClassProvider ANON_CLASS_PROVIDER = new AnonClassProvider();

    @Nullable
    public static String getName(@NotNull PsiAnonymousClass cls) {
        PsiClass upper;
        if (cls == null) {
            JavaAnonymousClassesHelper.$$$reportNull$$$0(0);
        }
        if ((upper = PsiTreeUtil.getParentOfType((PsiElement)cls, PsiClass.class)) == null) {
            return null;
        }
        ParameterizedCachedValue<Map<PsiAnonymousClass, String>, PsiClass> value = upper.getUserData(ANONYMOUS_CLASS_NAME);
        if (value == null) {
            value = CachedValuesManager.getManager(upper.getProject()).createParameterizedCachedValue(ANON_CLASS_PROVIDER, false);
            upper.putUserData(ANONYMOUS_CLASS_NAME, value);
        }
        return value.getValue(upper).get(cls);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cls", "com/intellij/ide/util/JavaAnonymousClassesHelper", "getName"));
    }

    private static class AnonClassProvider
    implements ParameterizedCachedValueProvider<Map<PsiAnonymousClass, String>, PsiClass> {
        private AnonClassProvider() {
        }

        @Override
        public CachedValueProvider.Result<Map<PsiAnonymousClass, String>> compute(final PsiClass upper) {
            final THashMap map2 = new THashMap();
            upper.accept(new JavaRecursiveElementWalkingVisitor(){
                int index;

                @Override
                public void visitAnonymousClass(PsiAnonymousClass aClass2) {
                    if (upper == aClass2) {
                        super.visitAnonymousClass(aClass2);
                        return;
                    }
                    PsiExpressionList arguments2 = aClass2.getArgumentList();
                    if (arguments2 != null) {
                        for (PsiExpression expression2 : arguments2.getExpressions()) {
                            expression2.acceptChildren(new JavaRecursiveElementVisitor(){

                                @Override
                                public void visitAnonymousClass(PsiAnonymousClass aClass2) {
                                    ++index;
                                    map2.put(aClass2, "$" + index);
                                }
                            });
                        }
                    }
                    ++this.index;
                    map2.put(aClass2, "$" + this.index);
                }

                @Override
                public void visitClass(PsiClass aClass2) {
                    if (aClass2 == upper) {
                        super.visitClass(aClass2);
                    }
                }
            });
            return CachedValueProvider.Result.create(map2, upper);
        }
    }
}

