/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indentation;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.tree.TokenSet;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class IndentationFoldingBuilder
implements FoldingBuilder,
DumbAware {
    private final TokenSet myTokenSet;

    public IndentationFoldingBuilder(TokenSet tokenSet) {
        this.myTokenSet = tokenSet;
    }

    @Override
    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode astNode, @NotNull Document document) {
        if (astNode == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (document == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(1);
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        this.collectDescriptors(astNode, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(2);
        }
        return foldingDescriptorArray;
    }

    private void collectDescriptors(@NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors) {
        if (node == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (descriptors == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(4);
        }
        LinkedList<ASTNode> toProcess = new LinkedList<ASTNode>();
        toProcess.add(node);
        while (!toProcess.isEmpty()) {
            ASTNode current = (ASTNode)toProcess.remove();
            if (current.getTreeParent() != null && current.getTextLength() > 1 && this.myTokenSet.contains(current.getElementType())) {
                descriptors.add(new FoldingDescriptor(current, current.getTextRange()));
            }
            for (ASTNode child = current.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                toProcess.add(child);
            }
        }
    }

    @Override
    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(5);
        }
        StringBuilder builder = new StringBuilder();
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            String text2 = child.getText();
            if (text2 == null) {
                if (builder.length() <= 0) continue;
                break;
            }
            if (!text2.contains("\n")) {
                builder.append(text2);
                continue;
            }
            if (builder.length() > 0) {
                builder.append(text2.substring(0, text2.indexOf(10)));
                break;
            }
            builder.append(IndentationFoldingBuilder.getFirstNonEmptyLine(text2));
            if (builder.length() > 0) break;
        }
        return builder.toString();
    }

    @NotNull
    private static String getFirstNonEmptyLine(@NotNull String text2) {
        int end;
        if (text2 == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(6);
        }
        int start = 0;
        while ((end = text2.indexOf(10, start)) != -1 && start >= end) {
            start = end + 1;
        }
        String string = end == -1 ? text2.substring(start) : text2.substring(start, end);
        if (string == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            IndentationFoldingBuilder.$$$reportNull$$$0(8);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/indentation/IndentationFoldingBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/indentation/IndentationFoldingBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFoldRegions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstNonEmptyLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildFoldRegions";
                break;
            }
            case 2: 
            case 7: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectDescriptors";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPlaceholderText";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFirstNonEmptyLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCollapsedByDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

