/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PerFileMappingsBase<T>
implements PersistentStateComponent<Element>,
PerFileMappings<T> {
    private final Map<VirtualFile, T> myMappings = ContainerUtil.newHashMap();

    @Nullable
    protected FilePropertyPusher<T> getFilePropertyPusher() {
        return null;
    }

    @Nullable
    protected Project getProject() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public Map<VirtualFile, T> getMappings() {
        Map<VirtualFile, T> map3 = this.myMappings;
        // MONITORENTER : map3
        this.cleanup();
        Map<VirtualFile, T> map2 = Collections.unmodifiableMap(this.myMappings);
        // MONITOREXIT : map3
        if (map2 != null) return map2;
        PerFileMappingsBase.$$$reportNull$$$0(0);
        return map2;
    }

    private void cleanup() {
        Iterator<VirtualFile> i = this.myMappings.keySet().iterator();
        while (i.hasNext()) {
            VirtualFile file2 = i.next();
            if (file2 == null || file2.isValid()) continue;
            i.remove();
        }
    }

    @Override
    @Nullable
    public T getMapping(@Nullable VirtualFile file2) {
        T t = this.getConfiguredMapping(file2);
        return t == null ? this.getDefaultMapping(file2) : t;
    }

    @Nullable
    public T getConfiguredMapping(@Nullable VirtualFile file2) {
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        return this.getMappingInner(file2, this.myMappings, pusher == null ? null : pusher.getFileDataKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected T getMappingInner(@Nullable VirtualFile file2, @Nullable Map<VirtualFile, T> mappings, @Nullable Key<T> pusherKey) {
        T pushedValue;
        VirtualFile originalFile;
        if (file2 instanceof VirtualFileWindow) {
            VirtualFileWindow window = (VirtualFileWindow)((Object)file2);
            file2 = window.getDelegate();
        }
        VirtualFile virtualFile2 = originalFile = file2 instanceof LightVirtualFile ? ((LightVirtualFile)file2).getOriginalFile() : null;
        if (Comparing.equal(originalFile, file2)) {
            originalFile = null;
        }
        if (file2 != null) {
            T t = pushedValue = pusherKey == null ? null : (T)file2.getUserData(pusherKey);
            if (pushedValue != null) {
                return pushedValue;
            }
        }
        if (originalFile != null) {
            T t = pushedValue = pusherKey == null ? null : (T)originalFile.getUserData(pusherKey);
            if (pushedValue != null) {
                return pushedValue;
            }
        }
        if (mappings == null) {
            return null;
        }
        Map<VirtualFile, T> map2 = mappings;
        synchronized (map2) {
            T t = PerFileMappingsBase.getMappingForHierarchy(file2, mappings);
            if (t != null) {
                return t;
            }
            t = PerFileMappingsBase.getMappingForHierarchy(originalFile, mappings);
            if (t != null) {
                return t;
            }
            return this.getNotInHierarchy(file2, mappings);
        }
    }

    @Nullable
    protected T getNotInHierarchy(@Nullable VirtualFile file2, @NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(1);
        }
        if (this.getProject() == null || file2 == null || file2.getFileSystem() instanceof NonPhysicalFileSystem || ProjectFileIndex.getInstance(this.getProject()).isInContent(file2)) {
            return mappings.get(null);
        }
        return null;
    }

    private static <T> T getMappingForHierarchy(@Nullable VirtualFile file2, @NotNull Map<VirtualFile, T> mappings) {
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(2);
        }
        for (VirtualFile cur = file2; cur != null; cur = cur.getParent()) {
            T t = mappings.get(cur);
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    @Nullable
    public T getDefaultMapping(@Nullable VirtualFile file2) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getImmediateMapping(@Nullable VirtualFile file2) {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            return this.myMappings.get(file2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMappings(@NotNull Map<VirtualFile, T> mappings) {
        ArrayList<VirtualFile> oldFiles;
        if (mappings == null) {
            PerFileMappingsBase.$$$reportNull$$$0(3);
        }
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            oldFiles = ContainerUtil.newArrayList(this.myMappings.keySet());
            this.myMappings.clear();
            this.myMappings.putAll(mappings);
            this.cleanup();
        }
        Project project = this.getProject();
        this.handleMappingChange(mappings.keySet(), oldFiles, project != null && !project.isDefault());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMapping(@Nullable VirtualFile file2, @Nullable T dialect) {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            if (dialect == null) {
                this.myMappings.remove(file2);
            } else {
                this.myMappings.put(file2, dialect);
            }
        }
        List<VirtualFile> files2 = ContainerUtil.createMaybeSingletonList(file2);
        this.handleMappingChange(files2, files2, false);
    }

    private void handleMappingChange(Collection<VirtualFile> files2, Collection<VirtualFile> oldFiles, boolean includeOpenFiles) {
        Project project = this.getProject();
        FilePropertyPusher<T> pusher = this.getFilePropertyPusher();
        if (project != null && pusher != null) {
            for (VirtualFile oldFile : oldFiles) {
                if (oldFile == null) continue;
                oldFile.putUserData(pusher.getFileDataKey(), null);
            }
            if (!project.isDefault()) {
                PushedFilePropertiesUpdater.getInstance(project).pushAll(pusher);
            }
        }
        if (this.shouldReparseFiles()) {
            Project[] projects;
            Project[] projectArray;
            if (project == null) {
                projectArray = ProjectManager.getInstance().getOpenProjects();
            } else {
                Project[] projectArray2 = new Project[1];
                projectArray = projectArray2;
                projectArray2[0] = project;
            }
            for (Project p : projects = projectArray) {
                PsiDocumentManager.getInstance(p).reparseFiles(files2, includeOpenFiles);
            }
        }
    }

    public abstract List<T> getAvailableValues();

    @Nullable
    protected abstract String serialize(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getState() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.cleanup();
            Element element = new Element("x");
            ArrayList<VirtualFile> files2 = new ArrayList<VirtualFile>(this.myMappings.keySet());
            Collections.sort(files2, (o1, o2) -> {
                if (o1 == null || o2 == null) {
                    return o1 == null ? (o2 == null ? 0 : 1) : -1;
                }
                return o1.getPath().compareTo(o2.getPath());
            });
            for (VirtualFile file2 : files2) {
                T dialect = this.myMappings.get(file2);
                String value = this.serialize(dialect);
                if (value == null) continue;
                Element child = new Element("file");
                element.addContent(child);
                child.setAttribute("url", file2 == null ? "PROJECT" : file2.getUrl());
                child.setAttribute(this.getValueAttribute(), value);
            }
            return element;
        }
    }

    @Nullable
    protected T handleUnknownMapping(VirtualFile file2, String value) {
        return null;
    }

    @NotNull
    protected String getValueAttribute() {
        if ("value" == null) {
            PerFileMappingsBase.$$$reportNull$$$0(4);
        }
        return "value";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(Element state2) {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            THashMap<String, T> dialectMap = new THashMap<String, T>();
            for (T dialect : this.getAvailableValues()) {
                String key = this.serialize(dialect);
                if (key == null) continue;
                dialectMap.put(key, dialect);
            }
            this.myMappings.clear();
            List<Element> files2 = state2.getChildren("file");
            for (Element fileElement : files2) {
                String url = fileElement.getAttributeValue("url");
                String dialectID = fileElement.getAttributeValue(this.getValueAttribute());
                VirtualFile file2 = url.equals("PROJECT") ? null : VirtualFileManager.getInstance().findFileByUrl(url);
                Object dialect = dialectMap.get(dialectID);
                if (dialect == null && (dialect = this.handleUnknownMapping(file2, dialectID)) == null || file2 == null && !url.equals("PROJECT")) continue;
                this.myMappings.put(file2, dialect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupForNextTest() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            this.myMappings.clear();
        }
    }

    protected boolean shouldReparseFiles() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMappings() {
        Map<VirtualFile, T> map2 = this.myMappings;
        synchronized (map2) {
            return !this.myMappings.isEmpty();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/PerFileMappingsBase";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/PerFileMappingsBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueAttribute";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNotInHierarchy";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMappingForHierarchy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMappings";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

