/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.XmlCodeFoldingSettings;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.xml.XmlEntityRefImpl;
import com.intellij.psi.impl.source.xml.XmlTokenImpl;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlConditionalSection;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XmlCodeFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private static final TokenSet XML_ATTRIBUTE_SET = TokenSet.create(XmlElementType.XML_ATTRIBUTE);
    private static final int MIN_TEXT_RANGE_LENGTH = 3;

    @Override
    public void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> foldings, @NotNull PsiElement psiElement, @NotNull Document document, boolean quick) {
        PsiMetaOwner rootTag;
        if (foldings == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(0);
        }
        if (psiElement == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(1);
        }
        if (document == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(2);
        }
        XmlDocument xmlDocument = null;
        if (psiElement instanceof XmlFile) {
            XmlFile file2 = (XmlFile)psiElement;
            xmlDocument = file2.getDocument();
        } else if (psiElement instanceof XmlDocument) {
            xmlDocument = (XmlDocument)psiElement;
        }
        XmlTag xmlTag = rootTag = xmlDocument == null ? null : xmlDocument.getRootTag();
        if (rootTag == null) {
            rootTag = xmlDocument;
        }
        if (rootTag != null) {
            this.doAddForChildren(xmlDocument, foldings, document);
        }
    }

    protected void addElementsToFold(List<FoldingDescriptor> foldings, XmlElement tag, Document document) {
        this.addToFold(foldings, tag, document);
        this.doAddForChildren(tag, foldings, document);
    }

    protected void doAddForChildren(XmlElement tag, List<FoldingDescriptor> foldings, Document document) {
        PsiElement[] children2;
        for (PsiElement child : children2 = tag.getChildren()) {
            FoldingBuilder foldingBuilder;
            ProgressManager.checkCanceled();
            if (child instanceof XmlTag || child instanceof XmlConditionalSection) {
                this.addElementsToFold(foldings, (XmlElement)child, document);
                continue;
            }
            if (child instanceof XmlComment) {
                this.addToFold(foldings, child, document);
                continue;
            }
            if (child instanceof XmlText || child instanceof XmlProlog) {
                PsiElement[] grandChildren;
                for (PsiElement grandChild : grandChildren = child.getChildren()) {
                    ProgressManager.checkCanceled();
                    if (!(grandChild instanceof XmlComment) && !this.isEntity(grandChild)) continue;
                    this.addToFold(foldings, grandChild, document);
                }
                continue;
            }
            if (this.isEntity(child) || child instanceof XmlAttribute && XmlCodeFoldingBuilder.isAttributeShouldBeFolded((XmlAttribute)child)) {
                this.addToFold(foldings, child, document);
                continue;
            }
            Language language = child.getLanguage();
            if (language instanceof XMLLanguage || language == Language.ANY || (foldingBuilder = LanguageFolding.INSTANCE.forLanguage(language)) == null) continue;
            FoldingDescriptor[] foldingDescriptors = foldingBuilder.buildFoldRegions(child.getNode(), document);
            ContainerUtil.addAll(foldings, foldingDescriptors);
        }
    }

    @Nullable
    public TextRange getRangeToFold(PsiElement element) {
        if (element instanceof XmlTag) {
            ASTNode tagNode = element.getNode();
            XmlToken tagNameElement = XmlTagUtil.getStartTagNameElement((XmlTag)element);
            if (tagNameElement == null) {
                return null;
            }
            int nameEnd = tagNameElement.getTextRange().getEndOffset();
            int end = tagNode.getLastChildNode().getTextRange().getEndOffset() - 1;
            ASTNode[] attributes = tagNode.getChildren(XML_ATTRIBUTE_SET);
            if (attributes.length > 0) {
                ASTNode lastAttribute = attributes[attributes.length - 1];
                ASTNode lastAttributeBeforeCR = null;
                for (ASTNode child = tagNode.getFirstChildNode(); child != lastAttribute.getTreeNext(); child = child.getTreeNext()) {
                    if (child.getElementType() == XmlElementType.XML_ATTRIBUTE) {
                        lastAttributeBeforeCR = child;
                        continue;
                    }
                    if (child.getPsi() instanceof PsiWhiteSpace && child.textContains('\n')) break;
                }
                if (lastAttributeBeforeCR != null) {
                    int attributeEnd = lastAttributeBeforeCR.getTextRange().getEndOffset();
                    return new UnfairTextRange(attributeEnd, end);
                }
            }
            return new UnfairTextRange(nameEnd, end);
        }
        if (element instanceof XmlComment) {
            XmlComment xmlComment = (XmlComment)element;
            TextRange textRange = element.getTextRange();
            int commentStartOffset = this.getCommentStartOffset(xmlComment);
            int commentEndOffset = this.getCommentStartEnd(xmlComment);
            if (textRange.getEndOffset() - textRange.getStartOffset() > commentStartOffset + commentEndOffset) {
                return new TextRange(textRange.getStartOffset() + commentStartOffset, textRange.getEndOffset() - commentEndOffset);
            }
            return null;
        }
        if (element instanceof XmlConditionalSection) {
            XmlConditionalSection conditionalSection = (XmlConditionalSection)element;
            TextRange textRange = element.getTextRange();
            PsiElement bodyStart = conditionalSection.getBodyStart();
            int startOffset = bodyStart != null ? bodyStart.getStartOffsetInParent() : 3;
            int endOffset = 3;
            if (textRange.getEndOffset() - textRange.getStartOffset() > startOffset + endOffset) {
                return new TextRange(textRange.getStartOffset() + startOffset, textRange.getEndOffset() - endOffset);
            }
            return null;
        }
        if (element instanceof XmlAttribute) {
            XmlAttributeValue valueElement = ((XmlAttribute)element).getValueElement();
            return valueElement != null ? valueElement.getValueTextRange() : null;
        }
        if (this.isEntity(element)) {
            return element.getTextRange();
        }
        return null;
    }

    protected int getCommentStartOffset(XmlComment element) {
        return 4;
    }

    protected int getCommentStartEnd(XmlComment element) {
        return 3;
    }

    protected boolean addToFold(List<FoldingDescriptor> foldings, PsiElement elementToFold, Document document) {
        PsiUtilCore.ensureValid(elementToFold);
        TextRange range = this.getRangeToFold(elementToFold);
        if (range == null) {
            return false;
        }
        if (range.getStartOffset() >= 0 && range.getEndOffset() <= elementToFold.getContainingFile().getTextRange().getEndOffset() && range.getEndOffset() <= document.getTextLength()) {
            int startLine = document.getLineNumber(range.getStartOffset());
            int endLine = document.getLineNumber(range.getEndOffset() - 1);
            boolean entity = this.isEntity(elementToFold);
            if ((startLine < endLine || elementToFold instanceof XmlAttribute || entity) && (range.getStartOffset() + 3 < range.getEndOffset() || entity)) {
                foldings.add(new FoldingDescriptor(elementToFold.getNode(), range));
                return true;
            }
        }
        return false;
    }

    @Override
    public String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        String value;
        PsiElement psi;
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(3);
        }
        if (range == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(4);
        }
        if ((psi = node.getPsi()) instanceof XmlAttribute && "src".equalsIgnoreCase(((XmlAttribute)psi).getName())) {
            return "data:";
        }
        if (psi instanceof XmlTag || psi instanceof XmlComment || psi instanceof XmlAttribute || psi instanceof XmlConditionalSection) {
            return "...";
        }
        if (this.isEntity(psi) && (value = this.getEntityPlaceholder(psi)) != null) {
            return value;
        }
        return null;
    }

    @Nullable
    protected String getEntityPlaceholder(PsiElement psi) {
        String text2 = psi.getText();
        String fastPath = StringUtil.unescapeXml(text2);
        if (!StringUtil.equals(fastPath, text2)) {
            return fastPath;
        }
        if (psi.isValid()) {
            XmlAttributeValue value;
            XmlEntityDecl resolve2 = XmlEntityRefImpl.resolveEntity((XmlElement)psi, text2, psi.getContainingFile());
            XmlAttributeValue xmlAttributeValue = value = resolve2 != null ? resolve2.getValueElement() : null;
            if (value != null) {
                return XmlCodeFoldingBuilder.getEntityValue(value);
            }
        }
        return null;
    }

    private static String getEntityValue(XmlAttributeValue value) {
        String result2 = value.getValue();
        int i = result2.indexOf(35);
        if (i > 0) {
            int charNum = StringUtil.parseInt(StringUtil.trimEnd(result2.substring(i + 1), ";"), -1);
            return charNum >= 0 ? String.valueOf((char)charNum) : null;
        }
        return null;
    }

    @Override
    public boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(5);
        }
        PsiElement psi = node.getPsi();
        XmlCodeFoldingSettings foldingSettings = this.getFoldingSettings();
        return psi instanceof XmlTag && foldingSettings.isCollapseXmlTags() || psi instanceof XmlAttribute && (XmlCodeFoldingBuilder.foldStyle((XmlAttribute)psi, foldingSettings) || XmlCodeFoldingBuilder.foldSrc((XmlAttribute)psi, foldingSettings)) || this.isEntity(psi) && foldingSettings.isCollapseEntities() && this.hasEntityPlaceholder(psi);
    }

    private boolean hasEntityPlaceholder(PsiElement psi) {
        try {
            return this.getEntityPlaceholder(psi) != null;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    private static boolean foldSrc(XmlAttribute psi, XmlCodeFoldingSettings settings2) {
        return settings2.isCollapseDataUri() && "src".equals(psi.getName());
    }

    private static boolean foldStyle(XmlAttribute psi, XmlCodeFoldingSettings settings2) {
        return settings2.isCollapseHtmlStyleAttribute() && "style".equalsIgnoreCase(psi.getName());
    }

    protected boolean isEntity(PsiElement psi) {
        return psi instanceof XmlEntityRef || psi instanceof XmlTokenImpl && ((XmlTokenImpl)psi).getElementType() == XmlTokenType.XML_CHAR_ENTITY_REF;
    }

    private static boolean isAttributeShouldBeFolded(XmlAttribute child) {
        return HtmlUtil.isHtmlFile(child.getContainingFile()) && ("style".equalsIgnoreCase(child.getName()) || "src".equals(child.getName()) && child.getValue() != null && URLUtil.isDataUri(child.getValue()));
    }

    protected abstract XmlCodeFoldingSettings getFoldingSettings();

    @Override
    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(6);
        }
        return node.getElementType() == XmlElementType.XML_TAG;
    }

    @Override
    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            XmlCodeFoldingBuilder.$$$reportNull$$$0(7);
        }
        return node.getElementType() == XmlTokenType.XML_COMMENT_CHARACTERS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/XmlCodeFoldingBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

