/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.xml;

import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.util.XmlTagUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XMLExternalAnnotator
extends ExternalAnnotator<MyHost, MyHost> {
    @Override
    @Nullable
    public MyHost collectInformation(@NotNull PsiFile file2) {
        XmlNSDescriptor nsDescriptor;
        if (file2 == null) {
            XMLExternalAnnotator.$$$reportNull$$$0(0);
        }
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file2).getDocument();
        if (document == null) {
            return null;
        }
        XmlTag rootTag = document.getRootTag();
        XmlNSDescriptor xmlNSDescriptor = nsDescriptor = rootTag == null ? null : rootTag.getNSDescriptor(rootTag.getNamespace(), false);
        if (nsDescriptor instanceof Validator) {
            MyHost host = new MyHost();
            ((Validator)((Object)nsDescriptor)).validate(document, host);
            return host;
        }
        return null;
    }

    @Override
    @Nullable
    public MyHost doAnnotate(MyHost collectedInfo) {
        return collectedInfo;
    }

    @Override
    public void apply(@NotNull PsiFile file2, MyHost annotationResult, @NotNull AnnotationHolder holder) {
        if (file2 == null) {
            XMLExternalAnnotator.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            XMLExternalAnnotator.$$$reportNull$$$0(2);
        }
        annotationResult.apply(holder);
    }

    private static void appendFixes(Annotation annotation2, IntentionAction ... actions) {
        if (actions != null) {
            for (IntentionAction action2 : actions) {
                annotation2.registerFix(action2);
            }
        }
    }

    public static void addMessageWithFixes(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type2, AnnotationHolder myHolder, IntentionAction ... fixes) {
        if (type2 == null) {
            XMLExternalAnnotator.$$$reportNull$$$0(3);
        }
        if (fixes == null) {
            XMLExternalAnnotator.$$$reportNull$$$0(4);
        }
        if (message != null && !message.isEmpty()) {
            if (context instanceof XmlTag) {
                XMLExternalAnnotator.addMessagesForTag((XmlTag)context, message, type2, myHolder, fixes);
            } else if (type2 == Validator.ValidationHost.ErrorType.ERROR) {
                XMLExternalAnnotator.appendFixes(myHolder.createErrorAnnotation(context, message), fixes);
            } else {
                XMLExternalAnnotator.appendFixes(myHolder.createWarningAnnotation(context, message), fixes);
            }
        }
    }

    private static void addMessagesForTag(XmlTag tag, String message, Validator.ValidationHost.ErrorType type2, AnnotationHolder myHolder, IntentionAction ... actions) {
        XmlToken childByRole = XmlTagUtil.getStartTagNameElement(tag);
        XMLExternalAnnotator.addMessagesForTreeChild(childByRole, type2, message, myHolder, actions);
        childByRole = XmlTagUtil.getEndTagNameElement(tag);
        XMLExternalAnnotator.addMessagesForTreeChild(childByRole, type2, message, myHolder, actions);
    }

    private static void addMessagesForTreeChild(XmlToken childByRole, Validator.ValidationHost.ErrorType type2, String message, AnnotationHolder myHolder, IntentionAction ... actions) {
        if (childByRole != null) {
            Annotation annotation2 = type2 == Validator.ValidationHost.ErrorType.ERROR ? myHolder.createErrorAnnotation(childByRole, message) : myHolder.createWarningAnnotation(childByRole, message);
            XMLExternalAnnotator.appendFixes(annotation2, actions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/xml/XMLExternalAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addMessageWithFixes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class MyHost
    implements Validator.ValidationHost {
        private final List<Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>> messages = new ArrayList<Trinity<PsiElement, String, Validator.ValidationHost.ErrorType>>();

        MyHost() {
        }

        @Override
        public void addMessage(PsiElement context, String message, int type2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addMessage(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type2) {
            if (type2 == null) {
                MyHost.$$$reportNull$$$0(0);
            }
            this.messages.add(Trinity.create(context, message, type2));
        }

        void apply(AnnotationHolder holder) {
            for (Trinity<PsiElement, String, Validator.ValidationHost.ErrorType> message : this.messages) {
                XMLExternalAnnotator.addMessageWithFixes((PsiElement)message.first, (String)message.second, (Validator.ValidationHost.ErrorType)((Object)message.third), holder, new IntentionAction[0]);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/lang/xml/XMLExternalAnnotator$MyHost", "addMessage"));
        }
    }
}

