/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.XmlLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlTokenType;

public class XmlHighlightingLexer
extends DelegateLexer {
    public XmlHighlightingLexer() {
        super(new XmlLexer());
    }

    @Override
    public IElementType getTokenType() {
        IElementType tokenType = this.getDelegate().getTokenType();
        if (tokenType == null) {
            return tokenType;
        }
        tokenType = this.fixWrongTokenTypes(tokenType);
        return tokenType;
    }

    private IElementType fixWrongTokenTypes(IElementType tokenType) {
        int state2 = this.getState() & 0x1F;
        if (tokenType == XmlTokenType.XML_NAME) {
            if (state2 == 2 || state2 == 8) {
                tokenType = XmlTokenType.XML_TAG_NAME;
            }
        } else if (tokenType == XmlTokenType.XML_WHITE_SPACE) {
            switch (state2) {
                case 12: 
                case 14: {
                    tokenType = XmlTokenType.TAG_WHITE_SPACE;
                    break;
                }
                default: {
                    tokenType = XmlTokenType.XML_REAL_WHITE_SPACE;
                    break;
                }
            }
        } else if ((tokenType == XmlTokenType.XML_CHAR_ENTITY_REF || tokenType == XmlTokenType.XML_ENTITY_REF_TOKEN) && state2 == 10) {
            return XmlTokenType.XML_COMMENT_CHARACTERS;
        }
        return tokenType;
    }
}

