/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.defaults.AssignabilityRegistrationException;
import org.picocontainer.defaults.DecoratingComponentAdapter;
import org.picocontainer.defaults.LifecycleStrategy;
import org.picocontainer.defaults.NotConcreteRegistrationException;

public class CachingComponentAdapter
extends DecoratingComponentAdapter {
    private volatile Object cached;
    private boolean disposed = false;
    private boolean started = false;
    private final boolean delegateHasLifecylce;
    private final Object lock = new Object();

    public CachingComponentAdapter(ComponentAdapter delegate) {
        super(delegate);
        this.delegateHasLifecylce = delegate instanceof LifecycleStrategy && ((LifecycleStrategy)((Object)delegate)).hasLifecycle(delegate.getComponentImplementation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getComponentInstance(PicoContainer container2) throws PicoInitializationException, PicoIntrospectionException, AssignabilityRegistrationException, NotConcreteRegistrationException {
        Object o = this.cached;
        if (o != null) {
            return o;
        }
        Object object = this.lock;
        synchronized (object) {
            o = this.cached;
            if (o != null) {
                return o;
            }
            this.cached = o = super.getComponentInstance(container2);
        }
        return o;
    }

    public void start(PicoContainer container2) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (this.started) {
                throw new IllegalStateException("Already started");
            }
            this.start(this.getComponentInstance(container2));
            this.started = true;
        }
    }

    public void stop(PicoContainer container2) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            if (!this.started) {
                throw new IllegalStateException("Not started");
            }
            this.stop(this.getComponentInstance(container2));
            this.started = false;
        }
    }

    public void dispose(PicoContainer container2) {
        if (this.delegateHasLifecylce) {
            if (this.disposed) {
                throw new IllegalStateException("Already disposed");
            }
            this.dispose(this.getComponentInstance(container2));
            this.disposed = true;
        }
    }

    public boolean hasLifecycle() {
        return this.delegateHasLifecylce;
    }
}

