/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.ex;

import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.string.DiffStringBuilder;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class DiffFragment {
    public static DiffFragment[] EMPTY_ARRAY = new DiffFragment[0];
    @Nullable
    private CharSequence myText1;
    @Nullable
    private CharSequence myText2;
    private boolean myIsModified;

    public DiffFragment(@Nullable String text1, @Nullable String text2) {
        this(DiffString.createNullable(text1), DiffString.createNullable(text2));
    }

    public DiffFragment(@Nullable DiffString text1, @Nullable DiffString text2) {
        this.myText1 = text1;
        this.myText2 = text2;
        this.myIsModified = text1 == null || text2 == null || !text1.equals(text2);
    }

    public boolean isEmpty() {
        return StringUtil.isEmpty(this.myText1) && StringUtil.isEmpty(this.myText2);
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void setModified(boolean modified) {
        this.myIsModified = modified;
    }

    public void appendText1(@Nullable DiffString str) {
        if (str == null) {
            return;
        }
        if (this.myText1 instanceof DiffStringBuilder) {
            ((DiffStringBuilder)this.myText1).append(str);
            return;
        }
        if (this.myText1 instanceof DiffString) {
            DiffString text1 = (DiffString)this.myText1;
            if (DiffString.canInplaceConcatenate(text1, str)) {
                this.myText1 = DiffString.concatenate(text1, str);
            } else {
                DiffStringBuilder builder = new DiffStringBuilder(text1.length() + str.length());
                builder.append(text1);
                builder.append(str);
                this.myText1 = builder;
            }
            return;
        }
        throw new IllegalStateException("Bad DiffFragment: " + (this.myText1 != null ? this.myText1.getClass() : "null"));
    }

    public void appendText2(@Nullable DiffString str) {
        if (str == null) {
            return;
        }
        if (this.myText2 instanceof DiffStringBuilder) {
            ((DiffStringBuilder)this.myText2).append(str);
            return;
        }
        if (this.myText2 instanceof DiffString) {
            DiffString text2 = (DiffString)this.myText2;
            if (DiffString.canInplaceConcatenate(text2, str)) {
                this.myText2 = DiffString.concatenate(text2, str);
            } else {
                DiffStringBuilder builder = new DiffStringBuilder(text2.length() + str.length());
                builder.append(text2);
                builder.append(str);
                this.myText2 = builder;
            }
            return;
        }
        throw new IllegalStateException("Bad DiffFragment: " + (this.myText2 != null ? this.myText2.getClass() : "null"));
    }

    @Nullable
    public DiffString getText1() {
        if (this.myText1 == null) {
            return null;
        }
        if (this.myText1 instanceof DiffString) {
            return (DiffString)this.myText1;
        }
        if (this.myText1 instanceof DiffStringBuilder) {
            return ((DiffStringBuilder)this.myText1).toDiffString();
        }
        throw new IllegalStateException("Bad DiffFragment: " + this.myText1.getClass());
    }

    @Nullable
    public DiffString getText2() {
        if (this.myText2 == null) {
            return null;
        }
        if (this.myText2 instanceof DiffString) {
            return (DiffString)this.myText2;
        }
        if (this.myText2 instanceof DiffStringBuilder) {
            return ((DiffStringBuilder)this.myText2).toDiffString();
        }
        throw new IllegalStateException("Bad DiffFragment: " + this.myText2.getClass());
    }

    public boolean isChange() {
        return this.myText1 != null && this.myText2 != null && this.isModified();
    }

    public boolean isEqual() {
        return this.myText1 != null && this.myText2 != null && !this.isModified();
    }

    public static DiffFragment unchanged(@Nullable String text1, @Nullable String text2) {
        return DiffFragment.unchanged(DiffString.createNullable(text1), DiffString.createNullable(text2));
    }

    public static DiffFragment unchanged(@Nullable DiffString text1, @Nullable DiffString text2) {
        if (text1 == null) {
            text1 = DiffString.EMPTY;
        }
        if (text2 == null) {
            text2 = DiffString.EMPTY;
        }
        DiffFragment result2 = new DiffFragment(text1, text2);
        result2.setModified(false);
        return result2;
    }

    public boolean isOneSide() {
        return this.myText1 == null || this.myText2 == null;
    }
}

