/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.colors.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Color;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class ValueElementReader {
    @NonNls
    private static final String VALUE = "value";
    @NonNls
    private static final String MAC = "mac";
    @NonNls
    private static final String LINUX = "linux";
    @NonNls
    private static final String WINDOWS = "windows";
    private static final String OS = SystemInfo.isWindows ? "windows" : (SystemInfo.isMac ? "mac" : "linux");
    private static final Logger LOG = Logger.getInstance(ValueElementReader.class);
    private String myAttribute;

    ValueElementReader() {
    }

    public void setAttribute(String attribute) {
        this.myAttribute = StringUtil.isEmpty(attribute) ? null : attribute;
    }

    @Nullable
    public <T> T read(Class<T> type2, Element element) {
        T value = null;
        if (element != null) {
            if (this.myAttribute != null) {
                value = this.read(type2, element, this.myAttribute);
            }
            if (value == null && (value = (T)this.read(type2, element, OS)) == null) {
                value = this.read(type2, element, VALUE);
            }
        }
        return value;
    }

    private <T> T read(Class<T> type2, Element element, String attribute) {
        block6: {
            String value = element.getAttributeValue(attribute);
            if (value != null) {
                if ((value = value.trim()).isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("empty attribute: " + attribute);
                    }
                } else {
                    try {
                        return this.convert(type2, value);
                    }
                    catch (Exception exception) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug("wrong attribute: " + attribute, exception);
                    }
                }
            }
        }
        return null;
    }

    protected <T> T convert(Class<T> type2, String value) {
        if (String.class.equals(type2)) {
            return (T)value;
        }
        if (Integer.class.equals(type2)) {
            return (T)Integer.valueOf(value);
        }
        if (Float.class.equals(type2)) {
            return (T)Float.valueOf(value);
        }
        if (Color.class.equals(type2)) {
            return (T)ValueElementReader.toColor(value);
        }
        if (Enum.class.isAssignableFrom(type2)) {
            return ValueElementReader.toEnum(type2, value);
        }
        if (Boolean.class.equals(type2)) {
            return (T)Boolean.valueOf(value);
        }
        throw new IllegalArgumentException("unsupported " + type2);
    }

    private static <T extends Enum> T toEnum(Class<T> type2, String value) {
        for (Enum field : (Enum[])type2.getEnumConstants()) {
            if (!value.equalsIgnoreCase(field.name()) && !value.equals(String.valueOf(field.ordinal()))) continue;
            return (T)field;
        }
        throw new IllegalArgumentException(value);
    }

    private static Color toColor(String value) {
        int rgb;
        try {
            rgb = Integer.parseInt(value, 16);
        }
        catch (NumberFormatException ignored) {
            rgb = Integer.decode(value);
        }
        return new Color(rgb);
    }
}

