/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions;

import com.intellij.openapi.extensions.SortingException;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LoadingOrder {
    @NonNls
    private static final String FIRST_STR = "FIRST";
    @NonNls
    private static final String LAST_STR = "LAST";
    @NonNls
    private static final String BEFORE_STR = "BEFORE ";
    @NonNls
    private static final String BEFORE_STR_OLD = "BEFORE:";
    @NonNls
    private static final String AFTER_STR = "AFTER ";
    @NonNls
    private static final String AFTER_STR_OLD = "AFTER:";
    public static final LoadingOrder ANY = new LoadingOrder();
    public static final LoadingOrder FIRST = new LoadingOrder("FIRST");
    public static final LoadingOrder LAST = new LoadingOrder("LAST");
    @NonNls
    private final String myName;
    private final boolean myFirst;
    private final boolean myLast;
    private final Set<String> myBefore;
    private final Set<String> myAfter;

    private LoadingOrder() {
        this.myBefore = new LinkedHashSet<String>(2);
        this.myAfter = new LinkedHashSet<String>(2);
        this.myName = "ANY";
        this.myFirst = false;
        this.myLast = false;
    }

    private LoadingOrder(@NonNls @NotNull String text2) {
        if (text2 == null) {
            LoadingOrder.$$$reportNull$$$0(0);
        }
        this.myBefore = new LinkedHashSet<String>(2);
        this.myAfter = new LinkedHashSet<String>(2);
        this.myName = text2;
        boolean last2 = false;
        boolean first2 = false;
        for (String string : StringUtil.split(text2, ",")) {
            String trimmed = string.trim();
            if (trimmed.equalsIgnoreCase(FIRST_STR)) {
                first2 = true;
                continue;
            }
            if (trimmed.equalsIgnoreCase(LAST_STR)) {
                last2 = true;
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, BEFORE_STR)) {
                this.myBefore.add(trimmed.substring(BEFORE_STR.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, BEFORE_STR_OLD)) {
                this.myBefore.add(trimmed.substring(BEFORE_STR_OLD.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, AFTER_STR)) {
                this.myAfter.add(trimmed.substring(AFTER_STR.length()).trim());
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(trimmed, AFTER_STR_OLD)) {
                this.myAfter.add(trimmed.substring(AFTER_STR_OLD.length()).trim());
                continue;
            }
            throw new AssertionError((Object)("Invalid specification: " + trimmed + "; should be one of FIRST, LAST, BEFORE <id> or AFTER <id>"));
        }
        this.myFirst = first2;
        this.myLast = last2;
    }

    public String toString() {
        return this.myName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LoadingOrder)) {
            return false;
        }
        LoadingOrder that = (LoadingOrder)o;
        if (this.myFirst != that.myFirst) {
            return false;
        }
        if (this.myLast != that.myLast) {
            return false;
        }
        if (!this.myAfter.equals(that.myAfter)) {
            return false;
        }
        return this.myBefore.equals(that.myBefore);
    }

    public int hashCode() {
        int result2 = this.myFirst ? 1 : 0;
        result2 = 31 * result2 + (this.myLast ? 1 : 0);
        result2 = 31 * result2 + this.myBefore.hashCode();
        result2 = 31 * result2 + this.myAfter.hashCode();
        return result2;
    }

    public static LoadingOrder before(@NonNls String id) {
        return new LoadingOrder(BEFORE_STR + id);
    }

    public static LoadingOrder after(@NonNls String id) {
        return new LoadingOrder(AFTER_STR + id);
    }

    public static void sort(Orderable ... orderable) {
        if (orderable == null) {
            LoadingOrder.$$$reportNull$$$0(1);
        }
        LoadingOrder.sort(Arrays.asList(orderable));
    }

    public static void sort(final @NotNull List<? extends Orderable> orderable) {
        if (orderable == null) {
            LoadingOrder.$$$reportNull$$$0(2);
        }
        final LinkedHashMap<String, Orderable> map2 = ContainerUtil.newLinkedHashMap();
        final LinkedHashMap<Orderable, LoadingOrder> cachedMap = ContainerUtil.newLinkedHashMap();
        final LinkedHashSet<Orderable> first2 = new LinkedHashSet<Orderable>(1);
        final LinkedHashSet<Orderable> hasBefore = new LinkedHashSet<Orderable>(orderable.size());
        for (Orderable orderable2 : orderable) {
            String id = orderable2.getOrderId();
            if (StringUtil.isNotEmpty(id)) {
                map2.put(id, orderable2);
            }
            LoadingOrder order = orderable2.getOrder();
            cachedMap.put(orderable2, order);
            if (order.myFirst) {
                first2.add(orderable2);
            }
            if (order.myBefore.isEmpty()) continue;
            hasBefore.add(orderable2);
        }
        InboundSemiGraph<Orderable> graph2 = new InboundSemiGraph<Orderable>(){

            @Override
            public Collection<Orderable> getNodes() {
                ArrayList<Orderable> list2 = ContainerUtil.newArrayList(orderable);
                Collections.reverse(list2);
                return list2;
            }

            @Override
            public Iterator<Orderable> getIn(Orderable n) {
                LoadingOrder hisOrder;
                LoadingOrder order = (LoadingOrder)cachedMap.get(n);
                LinkedHashSet<Orderable> predecessors = new LinkedHashSet<Orderable>();
                for (String id : order.myAfter) {
                    Orderable o = (Orderable)map2.get(id);
                    if (o == null) continue;
                    predecessors.add(o);
                }
                String id = n.getOrderId();
                if (StringUtil.isNotEmpty(id)) {
                    for (Orderable o : hasBefore) {
                        hisOrder = (LoadingOrder)cachedMap.get(o);
                        if (!hisOrder.myBefore.contains(id)) continue;
                        predecessors.add(o);
                    }
                }
                if (order.myLast) {
                    for (Orderable o : orderable) {
                        hisOrder = (LoadingOrder)cachedMap.get(o);
                        if (hisOrder.myLast) continue;
                        predecessors.add(o);
                    }
                }
                if (!order.myFirst) {
                    predecessors.addAll(first2);
                }
                return predecessors.iterator();
            }
        };
        DFSTBuilder<Orderable> dFSTBuilder = new DFSTBuilder<Orderable>(GraphGenerator.generate(CachingSemiGraph.cache(graph2)));
        if (!dFSTBuilder.isAcyclic()) {
            Couple<Orderable> p = dFSTBuilder.getCircularDependency();
            throw new SortingException("Could not satisfy sorting requirements", ((Orderable)p.first).getDescribingElement(), ((Orderable)p.second).getDescribingElement());
        }
        orderable.sort(dFSTBuilder.comparator());
    }

    public static LoadingOrder readOrder(@NonNls String orderAttr) {
        return orderAttr != null ? new LoadingOrder(orderAttr) : ANY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderable";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/extensions/LoadingOrder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "sort";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Orderable {
        @Nullable
        public String getOrderId();

        public LoadingOrder getOrder();

        public Element getDescribingElement();
    }
}

