/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.module;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleJdkOrderEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleUtilCore {
    public static final Key<Module> KEY_MODULE = new Key("Module");

    public static boolean projectContainsFile(@NotNull Project project, @NotNull VirtualFile file2, boolean isLibraryElement) {
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(1);
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (isLibraryElement) {
            List<OrderEntry> orders = projectFileIndex.getOrderEntriesForFile(file2);
            for (OrderEntry orderEntry : orders) {
                if (!(orderEntry instanceof ModuleJdkOrderEntry) && !(orderEntry instanceof JdkOrderEntry) && !(orderEntry instanceof LibraryOrderEntry)) continue;
                return true;
            }
            return false;
        }
        return projectFileIndex.isInContent(file2);
    }

    @NotNull
    public static String getModuleNameInReadAction(@NotNull Module module2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(2);
        }
        String string = ReadAction.compute(module2::getName);
        if (string == null) {
            ModuleUtilCore.$$$reportNull$$$0(3);
        }
        return string;
    }

    public static boolean isModuleDisposed(@NotNull PsiElement element) {
        Module module2;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(4);
        }
        if (!element.isValid()) {
            return true;
        }
        Project project = element.getProject();
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        PsiFile file2 = element.getContainingFile();
        if (file2 == null) {
            return true;
        }
        VirtualFile vFile = file2.getVirtualFile();
        Module module3 = module2 = vFile == null ? null : projectFileIndex.getModuleForFile(vFile);
        return module2 == null ? !projectFileIndex.isInLibraryClasses(vFile) : module2.isDisposed();
    }

    @Nullable
    public static Module findModuleForFile(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ModuleUtilCore.$$$reportNull$$$0(6);
        }
        return ProjectFileIndex.SERVICE.getInstance(project).getModuleForFile(file2);
    }

    @Nullable
    public static Module findModuleForPsiElement(@NotNull PsiElement element) {
        PsiFile containingFile;
        if (element == null) {
            ModuleUtilCore.$$$reportNull$$$0(7);
        }
        if ((containingFile = element.getContainingFile()) == null ? !element.isValid() : !containingFile.isValid()) {
            return null;
        }
        Project project = (containingFile == null ? element : containingFile).getProject();
        if (project.isDefault()) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance(project);
        if (element instanceof PsiFileSystemItem && (!(element instanceof PsiFile) || element.getContext() == null)) {
            VirtualFile vFile = ((PsiFileSystemItem)element).getVirtualFile();
            if (vFile == null) {
                VirtualFile virtualFile2 = vFile = containingFile == null ? null : containingFile.getOriginalFile().getVirtualFile();
                if (vFile == null) {
                    return element.getUserData(KEY_MODULE);
                }
            }
            if (fileIndex.isInLibrarySource(vFile) || fileIndex.isInLibraryClasses(vFile)) {
                List<OrderEntry> orderEntries2 = fileIndex.getOrderEntriesForFile(vFile);
                if (orderEntries2.isEmpty()) {
                    return null;
                }
                if (orderEntries2.size() == 1) {
                    return orderEntries2.get(0).getOwnerModule();
                }
                HashSet<Module> modules = new HashSet<Module>();
                for (OrderEntry orderEntry : orderEntries2) {
                    modules.add(orderEntry.getOwnerModule());
                }
                Module[] candidates2 = modules.toArray(new Module[modules.size()]);
                Arrays.sort(candidates2, ModuleManager.getInstance(project).moduleDependencyComparator());
                return candidates2[0];
            }
            return fileIndex.getModuleForFile(vFile);
        }
        if (containingFile != null) {
            PsiFile file2;
            PsiElement context;
            while ((context = containingFile.getContext()) != null && (file2 = context.getContainingFile()) != null) {
                containingFile = file2;
            }
            if (containingFile.getUserData(KEY_MODULE) != null) {
                return containingFile.getUserData(KEY_MODULE);
            }
            PsiFile originalFile = containingFile.getOriginalFile();
            if (originalFile.getUserData(KEY_MODULE) != null) {
                return originalFile.getUserData(KEY_MODULE);
            }
            VirtualFile virtualFile3 = originalFile.getVirtualFile();
            if (virtualFile3 != null) {
                return fileIndex.getModuleForFile(virtualFile3);
            }
        }
        return element.getUserData(KEY_MODULE);
    }

    public static void getDependencies(@NotNull Module module2, @NotNull Set<Module> modules) {
        Module[] dependencies2;
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(8);
        }
        if (modules == null) {
            ModuleUtilCore.$$$reportNull$$$0(9);
        }
        if (modules.contains(module2)) {
            return;
        }
        modules.add(module2);
        for (Module dependency : dependencies2 = ModuleRootManager.getInstance(module2).getDependencies()) {
            ModuleUtilCore.getDependencies(dependency, modules);
        }
    }

    public static void collectModulesDependsOn(@NotNull Module module2, @NotNull Set<Module> result2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(11);
        }
        if (!result2.add(module2)) {
            return;
        }
        ModuleManager moduleManager2 = ModuleManager.getInstance(module2.getProject());
        List<Module> dependentModules = moduleManager2.getModuleDependentModules(module2);
        block0: for (Module dependentModule : dependentModules) {
            OrderEntry[] orderEntries2;
            for (OrderEntry o : orderEntries2 = ModuleRootManager.getInstance(dependentModule).getOrderEntries()) {
                ModuleOrderEntry orderEntry;
                if (!(o instanceof ModuleOrderEntry) || (orderEntry = (ModuleOrderEntry)o).getModule() != module2) continue;
                if (orderEntry.isExported()) {
                    ModuleUtilCore.collectModulesDependsOn(dependentModule, result2);
                    continue block0;
                }
                result2.add(dependentModule);
                continue block0;
            }
        }
    }

    @NotNull
    public static List<Module> getAllDependentModules(@NotNull Module module2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(12);
        }
        ArrayList<Module> list2 = new ArrayList<Module>();
        Graph<Module> graph2 = ModuleManager.getInstance(module2.getProject()).moduleGraph();
        Iterator<Module> i = graph2.getOut(module2);
        while (i.hasNext()) {
            list2.add(i.next());
        }
        ArrayList<Module> arrayList = list2;
        if (arrayList == null) {
            ModuleUtilCore.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    public static boolean visitMeAndDependentModules(@NotNull Module module2, @NotNull ModuleVisitor visitor2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(14);
        }
        if (visitor2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(15);
        }
        if (!visitor2.visit(module2)) {
            return false;
        }
        List<Module> list2 = ModuleUtilCore.getAllDependentModules(module2);
        for (Module dependentModule : list2) {
            if (visitor2.visit(dependentModule)) continue;
            return false;
        }
        return true;
    }

    public static boolean moduleContainsFile(@NotNull Module module2, @NotNull VirtualFile file2, boolean isLibraryElement) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(17);
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
        if (isLibraryElement) {
            OrderEntry orderEntry = moduleRootManager.getFileIndex().getOrderEntryForFile(file2);
            return orderEntry instanceof ModuleJdkOrderEntry || orderEntry instanceof JdkOrderEntry || orderEntry instanceof LibraryOrderEntry;
        }
        return moduleRootManager.getFileIndex().isInContent(file2);
    }

    public static boolean isModuleFile(@NotNull Module module2, @NotNull VirtualFile file2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(19);
        }
        return FileUtil.namesEqual(file2.getPath(), module2.getModuleFilePath());
    }

    public static boolean isModuleDir(@NotNull Module module2, @NotNull VirtualFile dir) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(20);
        }
        if (dir == null) {
            ModuleUtilCore.$$$reportNull$$$0(21);
        }
        return FileUtil.namesEqual(dir.getPath(), ModuleUtilCore.getModuleDirPath(module2));
    }

    @NotNull
    public static String getModuleDirPath(@NotNull Module module2) {
        if (module2 == null) {
            ModuleUtilCore.$$$reportNull$$$0(22);
        }
        String string = PathUtilRt.getParentPath(module2.getModuleFilePath());
        if (string == null) {
            ModuleUtilCore.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/module/ModuleUtilCore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleNameInReadAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDependentModules";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleDirPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "projectContainsFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getModuleNameInReadAction";
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDisposed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findModuleForPsiElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesDependsOn";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllDependentModules";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "visitMeAndDependentModules";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "moduleContainsFile";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModuleFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getModuleDirPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @FunctionalInterface
    public static interface ModuleVisitor {
        public boolean visit(@NotNull Module var1);
    }
}

