/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectLocatorImpl
extends ProjectLocator {
    @Override
    @Nullable
    public Project guessProjectForFile(@Nullable VirtualFile file2) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null) {
            return null;
        }
        Project[] projects = projectManager.getOpenProjects();
        if (projects.length == 0) {
            return null;
        }
        if (projects.length == 1 && !projects[0].isDisposed()) {
            return projects[0];
        }
        if (file2 != null) {
            Project preferredProject = ProjectLocatorImpl.getPreferredProject(file2);
            if (preferredProject != null) {
                return preferredProject;
            }
            for (Project project : projects) {
                if (!project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance(project).getFileIndex().isInContent(file2)) continue;
                return project;
            }
        }
        return !projects[0].isDisposed() ? projects[0] : null;
    }

    @Override
    @NotNull
    public Collection<Project> getProjectsForFile(VirtualFile file2) {
        ProjectManager projectManager = ProjectManager.getInstance();
        if (projectManager == null || file2 == null) {
            List<Project> list2 = Collections.emptyList();
            if (list2 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(0);
            }
            return list2;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 0) {
            List<Project> list3 = Collections.emptyList();
            if (list3 == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(1);
            }
            return list3;
        }
        SmartList<Project> result2 = new SmartList<Project>();
        for (Project project : openProjects) {
            if (!project.isInitialized() || project.isDisposed() || !ProjectRootManager.getInstance(project).getFileIndex().isInContent(file2)) continue;
            result2.add(project);
        }
        SmartList<Project> smartList = result2;
        if (smartList == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/project/ProjectLocatorImpl", "getProjectsForFile"));
    }
}

