/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryInfoImpl
extends DirectoryInfo {
    public static final int MAX_ROOT_TYPE_ID = 127;
    protected final VirtualFile myRoot;
    private final Module module;
    private final VirtualFile libraryClassRoot;
    private final VirtualFile contentRoot;
    private final VirtualFile sourceRoot;
    protected final boolean myInModuleSource;
    protected final boolean myInLibrarySource;
    protected final boolean myExcluded;
    private final byte mySourceRootTypeId;
    private final String myUnloadedModuleName;

    DirectoryInfoImpl(@NotNull VirtualFile root2, Module module2, VirtualFile contentRoot, VirtualFile sourceRoot, VirtualFile libraryClassRoot, boolean inModuleSource, boolean inLibrarySource, boolean isExcluded, int sourceRootTypeId, @Nullable String unloadedModuleName) {
        if (root2 == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(0);
        }
        this.myRoot = root2;
        this.module = module2;
        this.libraryClassRoot = libraryClassRoot;
        this.contentRoot = contentRoot;
        this.sourceRoot = sourceRoot;
        this.myInModuleSource = inModuleSource;
        this.myInLibrarySource = inLibrarySource;
        this.myExcluded = isExcluded;
        this.myUnloadedModuleName = unloadedModuleName;
        if (sourceRootTypeId > 127) {
            throw new IllegalArgumentException("Module source root type id " + sourceRootTypeId + " exceeds the maximum allowable value (" + 127 + ")");
        }
        this.mySourceRootTypeId = (byte)sourceRootTypeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.myRoot.equals(((DirectoryInfoImpl)o).myRoot);
    }

    public int hashCode() {
        return this.myRoot.hashCode();
    }

    public String toString() {
        return "DirectoryInfo{module=" + this.getModule() + ", isInModuleSource=" + this.myInModuleSource + ", rootTypeId=" + this.getSourceRootTypeId() + ", isInLibrarySource=" + this.isInLibrarySource() + ", isExcludedFromModule=" + this.myExcluded + ", libraryClassRoot=" + this.getLibraryClassRoot() + ", contentRoot=" + this.getContentRoot() + ", sourceRoot=" + this.getSourceRoot() + "}";
    }

    @Override
    public boolean isInProject() {
        return !this.myExcluded;
    }

    @Override
    public boolean isInProject(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(1);
        }
        return !this.isExcluded(file2);
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    @Nullable
    public VirtualFile getSourceRoot() {
        return this.sourceRoot;
    }

    @Override
    public VirtualFile getLibraryClassRoot() {
        return this.libraryClassRoot;
    }

    @Override
    @Nullable
    public VirtualFile getContentRoot() {
        return this.contentRoot;
    }

    @Override
    public boolean isInModuleSource() {
        return this.myInModuleSource;
    }

    @Override
    public boolean isInLibrarySource() {
        return this.myInLibrarySource;
    }

    @Override
    public boolean isInLibrarySource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(2);
        }
        return this.myInLibrarySource;
    }

    @Override
    public boolean isExcluded() {
        return this.myExcluded;
    }

    @Override
    public boolean isExcluded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(3);
        }
        return this.myExcluded;
    }

    @Override
    public boolean isInModuleSource(@NotNull VirtualFile file2) {
        if (file2 == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(4);
        }
        return this.myInModuleSource;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public int getSourceRootTypeId() {
        return this.mySourceRootTypeId;
    }

    @Override
    public String getUnloadedModuleName() {
        return this.myUnloadedModuleName;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile2 = this.myRoot;
        if (virtualFile2 == null) {
            DirectoryInfoImpl.$$$reportNull$$$0(5);
        }
        return virtualFile2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/DirectoryInfoImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/DirectoryInfoImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isInProject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInLibrarySource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExcluded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInModuleSource";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

