/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.LibraryOrderEntryBaseImpl;
import com.intellij.openapi.roots.impl.OrderEntryFactory;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.WritableOrderEntry;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LibraryOrderEntryImpl
extends LibraryOrderEntryBaseImpl
implements LibraryOrderEntry,
ClonableOrderEntry,
WritableOrderEntry {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.LibraryOrderEntryImpl");
    private Library myLibrary;
    @Nullable
    private String myLibraryName;
    private String myLibraryLevel;
    private boolean myExported;
    @NonNls
    static final String ENTRY_TYPE = "library";
    @NonNls
    private static final String NAME_ATTR = "name";
    @NonNls
    private static final String LEVEL_ATTR = "level";
    private final MyOrderEntryLibraryTableListener myLibraryListener;
    @NonNls
    private static final String EXPORTED_ATTR = "exported";

    LibraryOrderEntryImpl(@NotNull Library library2, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (library2 == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(0);
        }
        if (rootModel == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(1);
        }
        if (projectRootManager == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(2);
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        LOG.assertTrue(library2.getTable() != null);
        this.myLibrary = library2;
        this.addListeners();
        this.init();
    }

    LibraryOrderEntryImpl(@NotNull Element element, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) throws InvalidDataException {
        if (element == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(3);
        }
        if (rootModel == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(4);
        }
        if (projectRootManager == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(5);
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        LOG.assertTrue(ENTRY_TYPE.equals(element.getAttributeValue("type")));
        this.myExported = element.getAttributeValue(EXPORTED_ATTR) != null;
        this.myScope = DependencyScope.readExternal(element);
        String level = element.getAttributeValue(LEVEL_ATTR);
        String name = element.getAttributeValue(NAME_ATTR);
        if (name == null) {
            throw new InvalidDataException();
        }
        if (level == null) {
            throw new InvalidDataException();
        }
        this.searchForLibrary(name, level);
        this.addListeners();
        this.init();
    }

    private LibraryOrderEntryImpl(@NotNull LibraryOrderEntryImpl that, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (that == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(6);
        }
        if (rootModel == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(7);
        }
        if (projectRootManager == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(8);
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        if (that.myLibrary == null) {
            this.myLibraryName = that.myLibraryName;
            this.myLibraryLevel = that.myLibraryLevel;
        } else {
            this.myLibrary = that.myLibrary;
        }
        this.myExported = that.myExported;
        this.myScope = that.myScope;
        this.addListeners();
        this.init();
    }

    public LibraryOrderEntryImpl(@NotNull String name, @NotNull String level, @NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager) {
        if (name == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(9);
        }
        if (level == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(10);
        }
        if (rootModel == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(11);
        }
        if (projectRootManager == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(12);
        }
        super(rootModel, projectRootManager);
        this.myLibraryListener = new MyOrderEntryLibraryTableListener();
        this.searchForLibrary(name, level);
        this.addListeners();
    }

    private void searchForLibrary(@NotNull String name, @NotNull String level) {
        Library library2;
        if (name == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(13);
        }
        if (level == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(14);
        }
        if (this.myLibrary != null) {
            return;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(level, this.getRootModel().getModule().getProject());
        Library library3 = library2 = libraryTable != null ? libraryTable.getLibraryByName(name) : null;
        if (library2 == null) {
            this.myLibraryName = name;
            this.myLibraryLevel = level;
            this.myLibrary = null;
        } else {
            this.myLibraryName = null;
            this.myLibraryLevel = null;
            this.myLibrary = library2;
        }
    }

    @Override
    public boolean isExported() {
        return this.myExported;
    }

    @Override
    public void setExported(boolean exported) {
        this.myExported = exported;
    }

    @Override
    @NotNull
    public DependencyScope getScope() {
        DependencyScope dependencyScope = this.myScope;
        if (dependencyScope == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(15);
        }
        return dependencyScope;
    }

    @Override
    public void setScope(@NotNull DependencyScope scope) {
        if (scope == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(16);
        }
        this.myScope = scope;
    }

    @Override
    @Nullable
    public Library getLibrary() {
        Library library2 = this.getRootModel().getConfigurationAccessor().getLibrary(this.myLibrary, this.myLibraryName, this.myLibraryLevel);
        if (library2 != null) {
            return library2;
        }
        if (this.myLibrary != null) {
            this.myLibraryName = this.myLibrary.getName();
            this.myLibraryLevel = this.myLibrary.getTable().getTableLevel();
        }
        this.myLibrary = null;
        return null;
    }

    @Override
    public boolean isModuleLevel() {
        return false;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.getLibraryName();
        if (string == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @Nullable
    protected RootProvider getRootProvider() {
        return this.myLibrary == null ? null : this.myLibrary.getRootProvider();
    }

    @Override
    public boolean isValid() {
        if (this.isDisposed()) {
            return false;
        }
        Library library2 = this.getLibrary();
        return library2 != null && !((LibraryEx)library2).isDisposed();
    }

    @Override
    public <R> R accept(@NotNull RootPolicy<R> policy, R initialValue) {
        if (policy == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(18);
        }
        return policy.visitLibraryOrderEntry(this, initialValue);
    }

    @Override
    @NotNull
    public OrderEntry cloneEntry(@NotNull RootModelImpl rootModel, @NotNull ProjectRootManagerImpl projectRootManager, @NotNull VirtualFilePointerManager filePointerManager) {
        if (rootModel == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(19);
        }
        if (projectRootManager == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(20);
        }
        if (filePointerManager == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(21);
        }
        ProjectRootManagerImpl rootManager = ProjectRootManagerImpl.getInstanceImpl(this.getRootModel().getModule().getProject());
        LibraryOrderEntryImpl libraryOrderEntryImpl = new LibraryOrderEntryImpl(this, rootModel, rootManager);
        if (libraryOrderEntryImpl == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(22);
        }
        return libraryOrderEntryImpl;
    }

    @Override
    public void writeExternal(@NotNull Element rootElement) throws WriteExternalException {
        if (rootElement == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(23);
        }
        Element element = OrderEntryFactory.createOrderEntryElement(ENTRY_TYPE);
        String libraryLevel = this.getLibraryLevel();
        if (this.myExported) {
            element.setAttribute(EXPORTED_ATTR, "");
        }
        this.myScope.writeExternal(element);
        element.setAttribute(NAME_ATTR, this.getLibraryName());
        element.setAttribute(LEVEL_ATTR, libraryLevel);
        rootElement.addContent(element);
    }

    @Override
    @NotNull
    public String getLibraryLevel() {
        if (this.myLibrary == null) {
            String string = this.myLibraryLevel;
            if (string == null) {
                LibraryOrderEntryImpl.$$$reportNull$$$0(24);
            }
            return string;
        }
        LibraryTable table = this.myLibrary.getTable();
        String string = table.getTableLevel();
        if (string == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(25);
        }
        return string;
    }

    @Override
    public String getLibraryName() {
        return this.myLibrary == null ? this.myLibraryName : this.myLibrary.getName();
    }

    private void addListeners() {
        String libraryLevel = this.getLibraryLevel();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(libraryLevel, this.getRootModel().getModule().getProject());
        if (libraryTable != null) {
            this.myProjectRootManagerImpl.addListenerForTable(this.myLibraryListener, libraryTable);
        }
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    @Override
    public void dispose() {
        super.dispose();
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(this.getLibraryLevel(), this.getRootModel().getModule().getProject());
        if (libraryTable != null) {
            this.myProjectRootManagerImpl.removeListenerForTable(this.myLibraryListener, libraryTable);
        }
    }

    private void afterLibraryAdded(@NotNull Library newLibrary) {
        if (newLibrary == null) {
            LibraryOrderEntryImpl.$$$reportNull$$$0(26);
        }
        if (this.myLibrary == null && Comparing.equal(this.myLibraryName, newLibrary.getName())) {
            this.myLibrary = newLibrary;
            this.myLibraryName = null;
            this.myLibraryLevel = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    private void beforeLibraryRemoved(Library library2) {
        if (library2 == this.myLibrary) {
            this.myLibraryName = this.myLibrary.getName();
            this.myLibraryLevel = this.myLibrary.getTable().getTableLevel();
            this.myLibrary = null;
            this.updateFromRootProviderAndSubscribe();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = ENTRY_TYPE;
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRootManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = NAME_ATTR;
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = LEVEL_ATTR;
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointerManager";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLibrary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneEntry";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "searchForLibrary";
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setScope";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "cloneEntry";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "afterLibraryAdded";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyOrderEntryLibraryTableListener
    implements LibraryTable.Listener {
        MyOrderEntryLibraryTableListener() {
        }

        @Override
        public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                MyOrderEntryLibraryTableListener.$$$reportNull$$$0(0);
            }
            LibraryOrderEntryImpl.this.afterLibraryAdded(newLibrary);
        }

        @Override
        public void afterLibraryRenamed(@NotNull Library library2) {
            if (library2 == null) {
                MyOrderEntryLibraryTableListener.$$$reportNull$$$0(1);
            }
            this.afterLibraryAdded(library2);
        }

        @Override
        public void beforeLibraryRemoved(@NotNull Library library2) {
            if (library2 == null) {
                MyOrderEntryLibraryTableListener.$$$reportNull$$$0(2);
            }
            LibraryOrderEntryImpl.this.beforeLibraryRemoved(library2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = LibraryOrderEntryImpl.ENTRY_TYPE;
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/roots/impl/LibraryOrderEntryImpl$MyOrderEntryLibraryTableListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

