/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.OrderRootsEnumerator;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.roots.impl.OrderEnumeratorBase;
import com.intellij.openapi.roots.impl.OrderRootsCache;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.util.PathsList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

class OrderRootsEnumeratorImpl
implements OrderRootsEnumerator {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.roots.impl.OrderRootsEnumeratorImpl");
    private final OrderEnumeratorBase myOrderEnumerator;
    private final OrderRootType myRootType;
    private final NotNullFunction<OrderEntry, OrderRootType> myRootTypeProvider;
    private boolean myUsingCache;
    private NotNullFunction<OrderEntry, VirtualFile[]> myCustomRootProvider;
    private boolean myWithoutSelfModuleOutput;

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull OrderRootType rootType) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(0);
        }
        if (rootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(1);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = rootType;
        this.myRootTypeProvider = null;
    }

    OrderRootsEnumeratorImpl(@NotNull OrderEnumeratorBase orderEnumerator, @NotNull NotNullFunction<OrderEntry, OrderRootType> rootTypeProvider) {
        if (orderEnumerator == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(2);
        }
        if (rootTypeProvider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(3);
        }
        this.myOrderEnumerator = orderEnumerator;
        this.myRootType = null;
        this.myRootTypeProvider = rootTypeProvider;
    }

    @Override
    @NotNull
    public VirtualFile[] getRoots() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache2 = this.myOrderEnumerator.getCache();
            if (cache2 != null) {
                int flags = this.myOrderEnumerator.getFlags();
                VirtualFile[] cached = cache2.getCachedRoots(this.myRootType, flags);
                if (cached == null) {
                    VirtualFile[] virtualFileArray = cache2.setCachedRoots(this.myRootType, flags, this.computeRootsUrls()).getFiles();
                    if (virtualFileArray == null) {
                        OrderRootsEnumeratorImpl.$$$reportNull$$$0(4);
                    }
                    return virtualFileArray;
                }
                if (cached == null) {
                    OrderRootsEnumeratorImpl.$$$reportNull$$$0(5);
                }
                return cached;
            }
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.computeRoots());
        if (virtualFileArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(6);
        }
        return virtualFileArray;
    }

    @Override
    @NotNull
    public String[] getUrls() {
        if (this.myUsingCache) {
            this.checkCanUseCache();
            OrderRootsCache cache2 = this.myOrderEnumerator.getCache();
            if (cache2 != null) {
                int flags = this.myOrderEnumerator.getFlags();
                String[] cached = cache2.getCachedUrls(this.myRootType, flags);
                if (cached == null) {
                    String[] stringArray = cache2.setCachedRoots(this.myRootType, flags, this.computeRootsUrls()).getUrls();
                    if (stringArray == null) {
                        OrderRootsEnumeratorImpl.$$$reportNull$$$0(7);
                    }
                    return stringArray;
                }
                if (cached == null) {
                    OrderRootsEnumeratorImpl.$$$reportNull$$$0(8);
                }
                return cached;
            }
        }
        String[] stringArray = ArrayUtil.toStringArray(this.computeRootsUrls());
        if (stringArray == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(9);
        }
        return stringArray;
    }

    private void checkCanUseCache() {
        LOG.assertTrue(this.myRootTypeProvider == null, "Caching not supported for OrderRootsEnumerator with root type provider");
        LOG.assertTrue(this.myCustomRootProvider == null, "Caching not supported for OrderRootsEnumerator with 'usingCustomRootProvider' option");
        LOG.assertTrue(!this.myWithoutSelfModuleOutput, "Caching not supported for OrderRootsEnumerator with 'withoutSelfModuleOutput' option");
    }

    @NotNull
    private Collection<VirtualFile> computeRoots() {
        LinkedHashSet<VirtualFile> result2 = new LinkedHashSet<VirtualFile>();
        this.myOrderEnumerator.forEach((orderEntry, customHandlers) -> {
            OrderRootType type2 = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRoots(type2, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), (Collection<VirtualFile>)result2, true, !this.myOrderEnumerator.isProductionOnly(), (List<OrderEnumerationHandler>)customHandlers);
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module2 = moduleOrderEntry.getModule();
                if (module2 != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module2);
                    boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRoots(type2, rootModel, (Collection<VirtualFile>)result2, !productionOnTests, includeTests, (List<OrderEnumerationHandler>)customHandlers);
                }
            } else {
                if (this.myCustomRootProvider != null) {
                    Collections.addAll(result2, (Object[])this.myCustomRootProvider.fun((OrderEntry)orderEntry));
                    return true;
                }
                if (OrderEnumeratorBase.addCustomRootsForLibrary(orderEntry, type2, result2, customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, orderEntry.getFiles(type2));
            }
            return true;
        });
        LinkedHashSet<VirtualFile> linkedHashSet = result2;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    @NotNull
    private Collection<String> computeRootsUrls() {
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        this.myOrderEnumerator.forEach((orderEntry, customHandlers) -> {
            OrderRootType type2 = this.getRootType((OrderEntry)orderEntry);
            if (orderEntry instanceof ModuleSourceOrderEntry) {
                this.collectModuleRootsUrls(type2, ((ModuleSourceOrderEntry)orderEntry).getRootModel(), result2, true, !this.myOrderEnumerator.isProductionOnly());
            } else if (orderEntry instanceof ModuleOrderEntry) {
                ModuleOrderEntry moduleOrderEntry = (ModuleOrderEntry)orderEntry;
                Module module2 = moduleOrderEntry.getModule();
                if (module2 != null) {
                    ModuleRootModel rootModel = this.myOrderEnumerator.getRootModel(module2);
                    boolean productionOnTests = orderEntry instanceof ModuleOrderEntryImpl && ((ModuleOrderEntryImpl)orderEntry).isProductionOnTestDependency();
                    boolean includeTests = !this.myOrderEnumerator.isProductionOnly() && OrderEnumeratorBase.shouldIncludeTestsFromDependentModulesToTestClasspath(customHandlers) || productionOnTests;
                    this.collectModuleRootsUrls(type2, rootModel, result2, !productionOnTests, includeTests);
                }
            } else {
                if (OrderEnumeratorBase.addCustomRootUrlsForLibrary(orderEntry, type2, result2, customHandlers)) {
                    return true;
                }
                Collections.addAll(result2, orderEntry.getUrls(type2));
            }
            return true;
        });
        LinkedHashSet<String> linkedHashSet = result2;
        if (linkedHashSet == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(11);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    public PathsList getPathsList() {
        PathsList list2 = new PathsList();
        this.collectPaths(list2);
        PathsList pathsList = list2;
        if (pathsList == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(12);
        }
        return pathsList;
    }

    @Override
    public void collectPaths(@NotNull PathsList list2) {
        if (list2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(13);
        }
        list2.addVirtualFiles(this.getRoots());
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCache() {
        this.myUsingCache = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(14);
        }
        return orderRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator withoutSelfModuleOutput() {
        this.myWithoutSelfModuleOutput = true;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(15);
        }
        return orderRootsEnumeratorImpl;
    }

    @Override
    @NotNull
    public OrderRootsEnumerator usingCustomRootProvider(@NotNull NotNullFunction<OrderEntry, VirtualFile[]> provider) {
        if (provider == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(16);
        }
        this.myCustomRootProvider = provider;
        OrderRootsEnumeratorImpl orderRootsEnumeratorImpl = this;
        if (orderRootsEnumeratorImpl == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(17);
        }
        return orderRootsEnumeratorImpl;
    }

    private void collectModuleRoots(@NotNull OrderRootType type2, ModuleRootModel rootModel, @NotNull Collection<VirtualFile> result2, boolean includeProduction, boolean includeTests, @NotNull List<OrderEnumerationHandler> customHandlers) {
        CompilerModuleExtension extension;
        if (type2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(18);
        }
        if (result2 == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(19);
        }
        if (customHandlers == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(20);
        }
        if (type2.equals(OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRoots(includeTests));
            } else {
                result2.addAll(rootModel.getSourceRoots(JavaModuleSourceRootTypes.TESTS));
            }
        } else if (type2.equals(OrderRootType.CLASSES) && (extension = rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension.getOutputRoots(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension.getOutputRoots(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, extension.getCompilerOutputPathForTests());
            }
        }
        OrderEnumeratorBase.addCustomRootsForModule(type2, rootModel, result2, includeProduction, includeTests, customHandlers);
    }

    private void collectModuleRootsUrls(OrderRootType type2, ModuleRootModel rootModel, Collection<String> result2, boolean includeProduction, boolean includeTests) {
        CompilerModuleExtension extension;
        if (type2.equals(OrderRootType.SOURCES)) {
            if (includeProduction) {
                Collections.addAll(result2, rootModel.getSourceRootUrls(includeTests));
            } else {
                for (ContentEntry entry : rootModel.getContentEntries()) {
                    for (SourceFolder folder : entry.getSourceFolders(JavaModuleSourceRootTypes.TESTS)) {
                        result2.add(folder.getUrl());
                    }
                }
            }
        } else if (type2.equals(OrderRootType.CLASSES) && (extension = rootModel.getModuleExtension(CompilerModuleExtension.class)) != null) {
            if (this.myWithoutSelfModuleOutput && this.myOrderEnumerator.isRootModuleModel(rootModel)) {
                if (includeTests && includeProduction) {
                    Collections.addAll(result2, extension.getOutputRootUrls(false));
                }
            } else if (includeProduction) {
                Collections.addAll(result2, extension.getOutputRootUrls(includeTests));
            } else {
                ContainerUtil.addIfNotNull(result2, extension.getCompilerOutputUrlForTests());
            }
        }
    }

    @NotNull
    private OrderRootType getRootType(@NotNull OrderEntry e) {
        if (e == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(21);
        }
        OrderRootType orderRootType = this.myRootType != null ? this.myRootType : this.myRootTypeProvider.fun(e);
        if (orderRootType == null) {
            OrderRootsEnumeratorImpl.$$$reportNull$$$0(22);
        }
        return orderRootType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEnumerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypeProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customHandlers";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/OrderRootsEnumeratorImpl";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRoots";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootsUrls";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathsList";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCache";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutSelfModuleOutput";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "usingCustomRootProvider";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 22: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectPaths";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "usingCustomRootProvider";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "collectModuleRoots";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getRootType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

