/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.libraries;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.text.StringTokenizer;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isClassAvailableInLibrary(Library library2, String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(library2.getFiles(OrderRootType.CLASSES), fqn);
    }

    public static boolean isClassAvailableInLibrary(VirtualFile[] files2, String fqn) {
        return LibraryUtil.isClassAvailableInLibrary(Arrays.asList(files2), fqn);
    }

    public static boolean isClassAvailableInLibrary(List<VirtualFile> files2, String fqn) {
        for (VirtualFile file2 : files2) {
            if (!LibraryUtil.findInFile(file2, new StringTokenizer(fqn, "."))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Library findLibraryByClass(String fqn, @Nullable Project project) {
        LibraryTable projectTable;
        Library library2;
        if (project != null && (library2 = LibraryUtil.findInTable(projectTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project), fqn)) != null) {
            return library2;
        }
        LibraryTable table = LibraryTablesRegistrar.getInstance().getLibraryTable();
        return LibraryUtil.findInTable(table, fqn);
    }

    private static boolean findInFile(VirtualFile file2, StringTokenizer tokenizer) {
        VirtualFile child;
        if (!tokenizer.hasMoreTokens()) {
            return true;
        }
        StringBuilder name = new StringBuilder(tokenizer.nextToken());
        if (!tokenizer.hasMoreTokens()) {
            name.append(".class");
        }
        return (child = file2.findChild(name.toString())) != null && LibraryUtil.findInFile(child, tokenizer);
    }

    @Nullable
    private static Library findInTable(LibraryTable table, String fqn) {
        for (Library library2 : table.getLibraries()) {
            if (!LibraryUtil.isClassAvailableInLibrary(library2, fqn)) continue;
            return library2;
        }
        return null;
    }

    public static Library createLibrary(LibraryTable libraryTable, @NonNls String baseName) {
        String name = baseName;
        int count2 = 2;
        while (libraryTable.getLibraryByName(name) != null) {
            name = baseName + " (" + count2++ + ")";
        }
        return libraryTable.createLibrary(name);
    }

    public static VirtualFile[] getLibraryRoots(Project project) {
        return LibraryUtil.getLibraryRoots(project, true, true);
    }

    public static VirtualFile[] getLibraryRoots(Project project, boolean includeSourceFiles, boolean includeJdk) {
        return LibraryUtil.getLibraryRoots(ModuleManager.getInstance(project).getModules(), includeSourceFiles, includeJdk);
    }

    public static VirtualFile[] getLibraryRoots(Module[] modules, boolean includeSourceFiles, boolean includeJdk) {
        HashSet roots2 = new HashSet();
        for (Module module2 : modules) {
            OrderEntry[] orderEntries2;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance(module2);
            for (OrderEntry entry : orderEntries2 = moduleRootManager.getOrderEntries()) {
                VirtualFile[] files2;
                if (entry instanceof LibraryOrderEntry) {
                    Library library2 = ((LibraryOrderEntry)entry).getLibrary();
                    if (library2 == null) continue;
                    VirtualFile[] virtualFileArray = files2 = includeSourceFiles ? library2.getFiles(OrderRootType.SOURCES) : null;
                    if (files2 == null || files2.length == 0) {
                        files2 = library2.getFiles(OrderRootType.CLASSES);
                    }
                    ContainerUtil.addAll(roots2, files2);
                    continue;
                }
                if (!includeJdk || !(entry instanceof JdkOrderEntry)) continue;
                JdkOrderEntry jdkEntry = (JdkOrderEntry)entry;
                VirtualFile[] virtualFileArray = files2 = includeSourceFiles ? jdkEntry.getRootFiles(OrderRootType.SOURCES) : null;
                if (files2 == null || files2.length == 0) {
                    files2 = jdkEntry.getRootFiles(OrderRootType.CLASSES);
                }
                ContainerUtil.addAll(roots2, files2);
            }
        }
        return VfsUtilCore.toVirtualFileArray(roots2);
    }

    @Nullable
    public static Library findLibrary(@NotNull Module module2, @NotNull String name) {
        if (module2 == null) {
            LibraryUtil.$$$reportNull$$$0(0);
        }
        if (name == null) {
            LibraryUtil.$$$reportNull$$$0(1);
        }
        Ref<Object> result2 = Ref.create(null);
        OrderEnumerator.orderEntries(module2).forEachLibrary(library2 -> {
            if (name == null) {
                LibraryUtil.$$$reportNull$$$0(7);
            }
            if (name.equals(library2.getName())) {
                result2.set(library2);
                return false;
            }
            return true;
        });
        return result2.get();
    }

    @Nullable
    public static OrderEntry findLibraryEntry(VirtualFile file2, Project project) {
        List<OrderEntry> entries2 = ProjectRootManager.getInstance(project).getFileIndex().getOrderEntriesForFile(file2);
        for (OrderEntry entry : entries2) {
            if (!(entry instanceof LibraryOrderEntry) && !(entry instanceof JdkOrderEntry)) continue;
            return entry;
        }
        return null;
    }

    @NotNull
    public static String getPresentableName(@NotNull Library library2) {
        String name;
        if (library2 == null) {
            LibraryUtil.$$$reportNull$$$0(2);
        }
        if ((name = library2.getName()) != null) {
            String string = name;
            if (string == null) {
                LibraryUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (library2 instanceof LibraryEx && ((LibraryEx)library2).isDisposed()) {
            if ("Disposed Library" == null) {
                LibraryUtil.$$$reportNull$$$0(4);
            }
            return "Disposed Library";
        }
        String[] urls = library2.getUrls(OrderRootType.CLASSES);
        if (urls.length > 0) {
            String string = PathUtil.getFileName(VfsUtilCore.urlToPath(urls[0]));
            if (string == null) {
                LibraryUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        if ("Empty Library" == null) {
            LibraryUtil.$$$reportNull$$$0(6);
        }
        return "Empty Library";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/libraries/LibraryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/libraries/LibraryUtil";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findLibrary";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPresentableName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findLibrary$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

