/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.BitUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xmlb.annotations.Transient;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Verifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.DefaultJDOMExternalizer");

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode) throws WriteExternalException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.writeExternal(data2, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data2, @NotNull Element parentNode, @Nullable(value="null means all elements accepted") JDOMFilter filter2) throws WriteExternalException {
        Field[] fields2;
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(3);
        }
        for (Field field : fields2 = data2.getClass().getFields()) {
            Element element;
            String value;
            block25: {
                int modifiers2;
                if (field.getName().indexOf(36) >= 0 || !Modifier.isPublic(modifiers2 = field.getModifiers()) || Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || field.getAnnotation(Transient.class) != null) continue;
                field.setAccessible(true);
                Class<?> type2 = field.getType();
                if (filter2 != null && !filter2.isAccept(field) || field.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
                value = null;
                try {
                    if (type2.isPrimitive()) {
                        if (type2.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data2));
                        } else if (type2.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data2));
                        } else if (type2.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data2));
                        } else if (type2.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data2));
                        } else if (type2.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data2));
                        } else if (type2.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data2));
                        } else if (type2.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data2));
                        } else {
                            if (!type2.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data2));
                        }
                        break block25;
                    }
                    if (type2.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data2));
                        break block25;
                    }
                    if (type2.isEnum()) {
                        value = field.get(data2).toString();
                        break block25;
                    }
                    if (type2.equals(Color.class)) {
                        Color color = (Color)field.get(data2);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data2);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type2);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    static String filterXMLCharacters(String value) {
        if (value != null) {
            StringBuilder builder = null;
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (Verifier.isXMLCharacter(c)) {
                    if (builder == null) continue;
                    builder.append(c);
                    continue;
                }
                if (builder != null) continue;
                builder = new StringBuilder(value.length() + 5);
                builder.append(value, 0, i);
            }
            if (builder != null) {
                value = builder.toString();
            }
        }
        return value;
    }

    public static void readExternal(@NotNull Object data2, Element parentNode) throws InvalidDataException {
        if (data2 == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            return;
        }
        block15: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                List<Element> children2;
                Object value;
                Field field = data2.getClass().getField(fieldName);
                Class<?> type2 = field.getType();
                int modifiers2 = field.getModifiers();
                if (!BitUtil.isSet(modifiers2, 1) || BitUtil.isSet(modifiers2, 8)) continue;
                field.setAccessible(true);
                if (BitUtil.isSet(modifiers2, 16)) {
                    value = field.get(data2);
                    if (!JDOMExternalizable.class.isInstance(value)) continue;
                    children2 = e.getChildren("value");
                    Iterator<Element> iterator2 = children2.iterator();
                    while (iterator2.hasNext()) {
                        Element child;
                        Element valueTag = child = iterator2.next();
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                if (type2.isPrimitive()) {
                    if (value == null) continue;
                    if (type2.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data2, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Short.TYPE)) {
                        try {
                            field.setShort(data2, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field.setInt(data2, i);
                        continue;
                    }
                    if (type2.equals(Long.TYPE)) {
                        try {
                            field.setLong(data2, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data2, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data2, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data2, ((String)value).charAt(0));
                        continue;
                    }
                    if (type2.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field.setBoolean(data2, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field.setBoolean(data2, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type2.isEnum()) {
                    for (Object enumValue : type2.getEnumConstants()) {
                        if (!enumValue.toString().equals(value)) continue;
                        field.set(data2, enumValue);
                        continue block15;
                    }
                    continue;
                }
                if (type2.equals(String.class)) {
                    field.set(data2, value);
                    continue;
                }
                if (type2.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field.set(data2, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                    children2 = e.getChildren("value");
                    if (children2.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element : children2) {
                        object = (JDOMExternalizable)type2.newInstance();
                        object.readExternal(element);
                    }
                    field.set(data2, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type2);
            }
            catch (NoSuchFieldException field) {
            }
            catch (SecurityException ex) {
                throw new InvalidDataException();
            }
            catch (IllegalAccessException ex) {
                throw new InvalidDataException(ex);
            }
            catch (InstantiationException ex) {
                throw new InvalidDataException();
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        if (value == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(5);
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) throws InvalidDataException {
        Color color;
        if (value == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value, ex);
                throw new InvalidDataException("Wrong color value: " + value, ex);
            }
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/DefaultJDOMExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "toInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

