/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DeprecatedDuplicatesIconPathPatcher;
import com.intellij.openapi.util.IconPathPatcher;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.ui.RetrievableIcon;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ImageFilter;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = ContainerUtil.createWeakMap(200);
    @NonNls
    private static final List<IconPathPatcher> ourPatchers = new ArrayList<IconPathPatcher>(2);
    public static boolean STRICT;
    private static boolean USE_DARK_ICONS;
    private static ImageFilter IMAGE_FILTER;
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    public static void installPathPatcher(IconPathPatcher patcher) {
        ourPatchers.add(patcher);
        IconLoader.clearCache();
    }

    @Deprecated
    public static Icon getIcon(@NotNull Image image) {
        if (image == null) {
            IconLoader.$$$reportNull$$$0(0);
        }
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        USE_DARK_ICONS = useDarkIcons;
        IconLoader.clearCache();
    }

    public static void setFilter(ImageFilter filter2) {
        if (IMAGE_FILTER != filter2) {
            IMAGE_FILTER = filter2;
            IconLoader.clearCache();
        }
    }

    private static void clearCache() {
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
    }

    @NotNull
    public static Icon getIcon(@NonNls @NotNull String path2) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(1);
        }
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path2;
        Icon icon = IconLoader.getIcon(path2, callerClass);
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(2);
        }
        return icon;
    }

    @Nullable
    private static Icon getReflectiveIcon(@NotNull String path2, ClassLoader classLoader) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(3);
        }
        try {
            String pckg = path2.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path2.substring(0, path2.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path2.substring(path2.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path2) {
        Class callerClass;
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(4);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return IconLoader.findIcon(path2, callerClass);
    }

    @Nullable
    public static Icon findIcon(@NonNls @NotNull String path2, boolean strict) {
        Class callerClass;
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(5);
        }
        if ((callerClass = ReflectionUtil.getGrandCallerClass()) == null) {
            return null;
        }
        return IconLoader.findIcon(path2, callerClass, false, strict);
    }

    @NotNull
    public static Icon getIcon(@NotNull String path2, @NotNull Class aClass2) {
        Icon icon;
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(6);
        }
        if (aClass2 == null) {
            IconLoader.$$$reportNull$$$0(7);
        }
        if ((icon = IconLoader.findIcon(path2, aClass2)) == null) {
            LOG.error("Icon cannot be found in '" + path2 + "', aClass='" + aClass2 + "'");
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(8);
        }
        return icon2;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path2, @NotNull Class aClass2) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(9);
        }
        if (aClass2 == null) {
            IconLoader.$$$reportNull$$$0(10);
        }
        return IconLoader.findIcon(path2, aClass2, false);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path2, @NotNull Class aClass2, boolean computeNow) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(11);
        }
        if (aClass2 == null) {
            IconLoader.$$$reportNull$$$0(12);
        }
        return IconLoader.findIcon(path2, aClass2, computeNow, STRICT);
    }

    @Nullable
    public static Icon findIcon(@NotNull String path2, @NotNull Class aClass2, boolean computeNow, boolean strict) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(13);
        }
        if (aClass2 == null) {
            IconLoader.$$$reportNull$$$0(14);
        }
        String originalPath = path2;
        Pair<String, Class> patchedPath = IconLoader.patchPath(path2);
        path2 = (String)patchedPath.first;
        if (patchedPath.second != null) {
            aClass2 = (Class)patchedPath.second;
        }
        if (IconLoader.isReflectivePath(path2)) {
            return IconLoader.getReflectiveIcon(path2, aClass2.getClassLoader());
        }
        URL myURL = aClass2.getResource(path2);
        if (myURL == null) {
            if (strict) {
                throw new RuntimeException("Can't find icon in '" + path2 + "' near " + aClass2);
            }
            return null;
        }
        Icon icon = IconLoader.findIcon(myURL);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = aClass2.getClassLoader();
        }
        return icon;
    }

    @NotNull
    private static Pair<String, Class> patchPath(@NotNull String path2) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(15);
        }
        for (IconPathPatcher patcher : ourPatchers) {
            String newPath = patcher.patchPath(path2);
            if (newPath == null) continue;
            Pair<String, Class> pair = Pair.create(newPath, patcher.getContextClass(path2));
            if (pair == null) {
                IconLoader.$$$reportNull$$$0(16);
            }
            return pair;
        }
        Pair<String, Object> pair = Pair.create(path2, null);
        if (pair == null) {
            IconLoader.$$$reportNull$$$0(17);
        }
        return pair;
    }

    private static boolean isReflectivePath(@NotNull String path2) {
        List<String> paths;
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(18);
        }
        return (paths = StringUtil.split(path2, ".")).size() > 1 && paths.get(0).endsWith("Icons");
    }

    @Nullable
    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    @Nullable
    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url, useCache);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
            }
        }
        return icon;
    }

    @Nullable
    public static Icon findIcon(@NotNull String path2, @NotNull ClassLoader classLoader) {
        if (path2 == null) {
            IconLoader.$$$reportNull$$$0(19);
        }
        if (classLoader == null) {
            IconLoader.$$$reportNull$$$0(20);
        }
        String originalPath = path2;
        Pair<String, Class> patchedPath = IconLoader.patchPath(path2);
        path2 = (String)patchedPath.first;
        if (patchedPath.second != null) {
            classLoader = ((Class)patchedPath.second).getClassLoader();
        }
        if (IconLoader.isReflectivePath(path2)) {
            return IconLoader.getReflectiveIcon(path2, classLoader);
        }
        if (!StringUtil.startsWithChar(path2, '/')) {
            return null;
        }
        URL url = classLoader.getResource(path2.substring(1));
        Icon icon = IconLoader.findIcon(url);
        if (icon instanceof CachedImageIcon) {
            ((CachedImageIcon)icon).myOriginalPath = originalPath;
            ((CachedImageIcon)icon).myClassLoader = classLoader;
        }
        return icon;
    }

    @Nullable
    public static Image toImage(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(21);
        }
        if (icon instanceof CachedImageIcon) {
            icon = ((CachedImageIcon)icon).getRealIcon();
        }
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(w, h, 3);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    @Nullable
    private static ImageIcon checkIcon(Image image, @NotNull URL url) {
        if (url == null) {
            IconLoader.$$$reportNull$$$0(22);
        }
        if (image == null || image.getHeight(null) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (!IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        assert (icon instanceof ImageIcon);
        return (ImageIcon)icon;
    }

    public static boolean isGoodSize(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(23);
        }
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    @Nullable
    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            if (!IconLoader.isGoodSize(icon)) {
                LOG.error(icon);
                return EMPTY_ICON;
            }
            if (icon instanceof CachedImageIcon) {
                disabledIcon = ((CachedImageIcon)icon).asDisabledIcon();
            } else {
                float scale = UIUtil.isJreHiDPI() ? JBUI.sysScale() : 1.0f;
                BufferedImage image = new BufferedImage((int)(scale * (float)icon.getIconWidth()), (int)(scale * (float)icon.getIconHeight()), 2);
                Graphics2D graphics = image.createGraphics();
                graphics.setColor(UIUtil.TRANSPARENT_COLOR);
                graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
                graphics.scale(scale, scale);
                icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
                graphics.dispose();
                Image img = ImageUtil.filter(image, UIUtil.getGrayFilter());
                if (UIUtil.isJreHiDPI()) {
                    img = RetinaImage.createFrom(img, scale, null);
                }
                disabledIcon = new JBImageIcon(img);
            }
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    public static Icon getTransparentIcon(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(24);
        }
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(final @NotNull Icon icon, final float alpha) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(25);
        }
        return new RetrievableIcon(){

            @Override
            @Nullable
            public Icon retrieveIcon() {
                return icon;
            }

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    @NotNull
    public static Icon getIconSnapshot(@NotNull Icon icon) {
        if (icon == null) {
            IconLoader.$$$reportNull$$$0(26);
        }
        if (icon instanceof CachedImageIcon) {
            ImageIcon imageIcon = ((CachedImageIcon)icon).getRealIcon();
            if (imageIcon == null) {
                IconLoader.$$$reportNull$$$0(27);
            }
            return imageIcon;
        }
        Icon icon2 = icon;
        if (icon2 == null) {
            IconLoader.$$$reportNull$$$0(28);
        }
        return icon2;
    }

    public static Icon get1xIcon(Icon icon) {
        Image img;
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon instanceof CachedImageIcon && (img = ((CachedImageIcon)icon).loadFromUrl(JBUI.ScaleContext.create(JBUI.ScaleType.USR_SCALE.of(1.0), JBUI.ScaleType.SYS_SCALE.of(1.0)))) != null) {
            icon = new ImageIcon(img);
        }
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doWithTmpRegValue(String key, Boolean tempValue, Callable<T> action2) {
        RegistryValue regVal = Registry.get(key);
        boolean regValOrig = regVal.asBoolean();
        regVal.setValue(tempValue);
        try {
            T t = action2.call();
            return t;
        }
        catch (Exception ignore) {
            T t = null;
            return t;
        }
        finally {
            regVal.setValue(regValOrig);
        }
    }

    static {
        USE_DARK_ICONS = UIUtil.isUnderDarcula();
        IconLoader.installPathPatcher(new DeprecatedDuplicatesIconPathPatcher());
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            @NonNls
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 17: 
            case 27: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 17: 
            case 27: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "image";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 17: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/IconLoader";
                break;
            }
            case 2: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "patchPath";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconSnapshot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 17: 
            case 27: 
            case 28: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getReflectiveIcon";
                break;
            }
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "patchPath";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isReflectivePath";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "toImage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkIcon";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isGoodSize";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTransparentIcon";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getIconSnapshot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 16: 
            case 17: 
            case 27: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static abstract class LazyIcon
    extends JBUI.RasterJBIcon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$900();
        private int numberOfPatchers = IconLoader.access$600().size();
        private ImageFilter filter = IconLoader.access$1000();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon;
            if (this.updateScaleContext(JBUI.ScaleContext.create((Graphics2D)g))) {
                this.myIcon = null;
            }
            if ((icon = this.getOrComputeIcon()) != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS || this.myIcon == null || this.filter != IMAGE_FILTER || this.numberOfPatchers != ourPatchers.size()) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.filter = IMAGE_FILTER;
                this.myWasComputed = true;
                this.numberOfPatchers = ourPatchers.size();
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();
    }

    public static final class CachedImageIcon
    extends JBUI.RasterJBIcon
    implements ScalableIcon {
        private volatile Object myRealIcon;
        private String myOriginalPath;
        private ClassLoader myClassLoader;
        @NotNull
        private URL myUrl;
        private volatile boolean dark;
        private volatile int numberOfPatchers;
        private boolean svg;
        private boolean useCacheOnLoad;
        private ImageFilter[] myFilters;
        private final MyScaledIconsCache myScaledIconsCache;

        private CachedImageIcon(@NotNull CachedImageIcon icon) {
            if (icon == null) {
                CachedImageIcon.$$$reportNull$$$0(0);
            }
            this.numberOfPatchers = ourPatchers.size();
            this.useCacheOnLoad = true;
            this.myScaledIconsCache = new MyScaledIconsCache();
            ((JBUI.ScaleContext)this.getScaleContext()).addUpdateListener(new JBUI.BaseScaleContext.UpdateListener(){

                @Override
                public void contextUpdated() {
                    CachedImageIcon.this.myRealIcon = null;
                }
            });
            this.myRealIcon = null;
            this.myOriginalPath = icon.myOriginalPath;
            this.myClassLoader = icon.myClassLoader;
            this.myUrl = icon.myUrl;
            this.dark = icon.dark;
            this.numberOfPatchers = icon.numberOfPatchers;
            this.myFilters = icon.myFilters;
            this.svg = this.myOriginalPath != null ? this.myOriginalPath.toLowerCase().endsWith("svg") : false;
            this.useCacheOnLoad = icon.useCacheOnLoad;
        }

        public CachedImageIcon(@NotNull URL url) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(1);
            }
            this(url, true);
        }

        public CachedImageIcon(@NotNull URL url, boolean useCacheOnLoad) {
            if (url == null) {
                CachedImageIcon.$$$reportNull$$$0(2);
            }
            this.numberOfPatchers = ourPatchers.size();
            this.useCacheOnLoad = true;
            this.myScaledIconsCache = new MyScaledIconsCache();
            ((JBUI.ScaleContext)this.getScaleContext()).addUpdateListener(new /* invalid duplicate definition of identical inner class */);
            this.myUrl = url;
            this.dark = USE_DARK_ICONS;
            this.myFilters = new ImageFilter[]{IMAGE_FILTER};
            this.svg = url.toString().endsWith("svg");
            this.useCacheOnLoad = useCacheOnLoad;
        }

        private void setGlobalFilter(ImageFilter globalFilter) {
            this.myFilters[0] = globalFilter;
        }

        private ImageFilter getGlobalFilter() {
            return this.myFilters[0];
        }

        @NotNull
        private synchronized ImageIcon getRealIcon() {
            ImageIcon imageIcon = this.getRealIcon(null);
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(3);
            }
            return imageIcon;
        }

        @NotNull
        private synchronized ImageIcon getRealIcon(JBUI.ScaleContext ctx) {
            ImageIcon icon;
            Object realIcon;
            if (this.updateScaleContext(ctx)) {
                this.myRealIcon = null;
            }
            if (!this.isValid()) {
                if (IconLoader.isLoaderDisabled()) {
                    ImageIcon imageIcon = EMPTY_ICON;
                    if (imageIcon == null) {
                        CachedImageIcon.$$$reportNull$$$0(4);
                    }
                    return imageIcon;
                }
                this.myRealIcon = null;
                this.dark = USE_DARK_ICONS;
                this.setGlobalFilter(IMAGE_FILTER);
                this.myScaledIconsCache.clear();
                if (this.numberOfPatchers != ourPatchers.size()) {
                    URL url;
                    String path2;
                    this.numberOfPatchers = ourPatchers.size();
                    Pair patchedPath = IconLoader.patchPath(this.myOriginalPath);
                    String string = path2 = this.myOriginalPath == null ? null : (String)patchedPath.first;
                    if (patchedPath.second != null) {
                        this.myClassLoader = ((Class)patchedPath.second).getClassLoader();
                    }
                    if (this.myClassLoader != null && path2 != null && path2.startsWith("/") && (url = this.myClassLoader.getResource(path2 = path2.substring(1))) != null) {
                        this.myUrl = url;
                    }
                }
            }
            if ((realIcon = this.myRealIcon) instanceof Icon) {
                ImageIcon imageIcon = (ImageIcon)realIcon;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(5);
                }
                return imageIcon;
            }
            if (realIcon instanceof Reference && (icon = (ImageIcon)((Reference)realIcon).get()) != null) {
                ImageIcon imageIcon = icon;
                if (imageIcon == null) {
                    CachedImageIcon.$$$reportNull$$$0(6);
                }
                return imageIcon;
            }
            icon = this.myScaledIconsCache.getOrScaleIcon(1.0f);
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<ImageIcon>(icon);
                this.myRealIcon = realIcon;
            }
            ImageIcon imageIcon = icon == null ? EMPTY_ICON : icon;
            if (imageIcon == null) {
                CachedImageIcon.$$$reportNull$$$0(7);
            }
            return imageIcon;
        }

        private boolean isValid() {
            return this.myRealIcon != null && this.dark == USE_DARK_ICONS && this.getGlobalFilter() == IMAGE_FILTER && this.numberOfPatchers == ourPatchers.size();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JBUI.ScaleContext ctx = c != null ? JBUI.ScaleContext.create(c) : JBUI.ScaleContext.create((Graphics2D)g);
            this.getRealIcon(ctx).paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }

        @Override
        public float getScale() {
            return 1.0f;
        }

        @Override
        public Icon scale(float scale) {
            if (scale == 1.0f) {
                return this;
            }
            this.getRealIcon();
            ImageIcon icon = this.myScaledIconsCache.getOrScaleIcon(scale);
            if (icon != null) {
                return icon;
            }
            return this;
        }

        private Icon asDisabledIcon() {
            CachedImageIcon icon = new CachedImageIcon(this);
            icon.myFilters = new ImageFilter[]{this.getGlobalFilter(), UIUtil.getGrayFilter()};
            return icon;
        }

        private Image loadFromUrl(JBUI.ScaleContext ctx) {
            return ImageLoader.loadFromUrl(this.myUrl, true, this.useCacheOnLoad, this.myFilters, ctx);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/util/IconLoader$CachedImageIcon";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRealIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        private class MyScaledIconsCache {
            private static final int SCALED_ICONS_CACHE_LIMIT = 5;
            private Map<Double, SoftReference<ImageIcon>> scaledIconsCache = Collections.synchronizedMap(new LinkedHashMap<Double, SoftReference<ImageIcon>>(5){

                @Override
                public boolean removeEldestEntry(Map.Entry<Double, SoftReference<ImageIcon>> entry) {
                    return this.size() > 5;
                }
            });

            private MyScaledIconsCache() {
            }

            public ImageIcon getOrScaleIcon(float scale) {
                CachedImageIcon.this.updateScale(JBUI.ScaleType.OBJ_SCALE.of(scale));
                ImageIcon icon = (ImageIcon)SoftReference.dereference(this.scaledIconsCache.get(CachedImageIcon.this.getScale(JBUI.ScaleType.PIX_SCALE)));
                if (icon != null) {
                    return icon;
                }
                Image image = CachedImageIcon.this.svg ? (Image)IconLoader.doWithTmpRegValue("ide.svg.icon", true, new Callable<Image>(){

                    @Override
                    public Image call() {
                        return CachedImageIcon.this.loadFromUrl((JBUI.ScaleContext)CachedImageIcon.this.getScaleContext());
                    }
                }) : CachedImageIcon.this.loadFromUrl((JBUI.ScaleContext)CachedImageIcon.this.getScaleContext());
                icon = IconLoader.checkIcon(image, CachedImageIcon.this.myUrl);
                if (icon != null && icon.getIconWidth() * icon.getIconHeight() * 4 < ImageLoader.CACHED_IMAGE_MAX_SIZE) {
                    this.scaledIconsCache.put(CachedImageIcon.this.getScale(JBUI.ScaleType.PIX_SCALE), new SoftReference<ImageIcon>(icon));
                }
                return icon;
            }

            public void clear() {
                this.scaledIconsCache.clear();
            }
        }
    }
}

