/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    public final int bugfix;

    public Version(int major, int minor, int bugfix) {
        this.bugfix = bugfix;
        this.minor = minor;
        this.major = major;
    }

    @Nullable
    public static Version parseVersion(@NotNull String versionString) {
        int patch;
        int minor;
        String[] versions;
        String version;
        int major;
        if (versionString == null) {
            Version.$$$reportNull$$$0(0);
        }
        if ((major = Version.parseNumber(version = (versions = versionString.split("\\."))[0], -1)) < 0) {
            return null;
        }
        int n = minor = versions.length > 1 ? Version.parseNumber(versions[1], -1) : 0;
        if (minor < 0) {
            return new Version(major, 0, 0);
        }
        int n2 = patch = versions.length > 2 ? Version.parseNumber(versions[2], -1) : 0;
        if (patch < 0) {
            return new Version(major, minor, 0);
        }
        return new Version(major, minor, patch);
    }

    private static int parseNumber(String num, int def) {
        return StringUtil.parseInt(num.replaceFirst("(\\d+).*", "$1"), def);
    }

    public boolean is(@Nullable Integer major) {
        return this.is(major, null);
    }

    public boolean is(@Nullable Integer major, @Nullable Integer minor) {
        return this.is(major, minor, null);
    }

    public boolean is(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) == 0;
    }

    public boolean isOrGreaterThan(@Nullable Integer major) {
        return this.isOrGreaterThan(major, null);
    }

    public boolean isOrGreaterThan(@Nullable Integer major, @Nullable Integer minor) {
        return this.isOrGreaterThan(major, minor, null);
    }

    public boolean isOrGreaterThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) >= 0;
    }

    public boolean lessThan(@Nullable Integer major) {
        return this.lessThan(major, null);
    }

    public boolean lessThan(@Nullable Integer major, @Nullable Integer minor) {
        return this.lessThan(major, minor, null);
    }

    public boolean lessThan(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        return this.compareTo(major, minor, bugfix) < 0;
    }

    @Override
    public int compareTo(@NotNull Version version) {
        if (version == null) {
            Version.$$$reportNull$$$0(1);
        }
        return this.compareTo(version.major, version.minor, version.bugfix);
    }

    @Override
    public int compareTo(@Nullable Integer major) {
        return this.compareTo(major, null);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor) {
        return this.compareTo(major, minor, null);
    }

    public int compareTo(@Nullable Integer major, @Nullable Integer minor, @Nullable Integer bugfix) {
        int result2 = Version.doCompare(this.major, major);
        if (result2 != 0) {
            return result2;
        }
        result2 = Version.doCompare(this.minor, minor);
        if (result2 != 0) {
            return result2;
        }
        return Version.doCompare(this.bugfix, bugfix);
    }

    private static int doCompare(Integer l, Integer r) {
        if (l == null || r == null) {
            return 0;
        }
        return l - r;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.bugfix;
    }

    public String toCompactString() {
        return Version.toCompactString(this.major, this.minor, this.bugfix);
    }

    public static String toCompactString(int major, int minor, int bugfix) {
        String res2 = major + "." + minor;
        if (bugfix > 0) {
            res2 = res2 + "." + bugfix;
        }
        return res2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.bugfix != version.bugfix) {
            return false;
        }
        if (this.major != version.major) {
            return false;
        }
        return this.minor == version.minor;
    }

    public int hashCode() {
        int result2 = this.major;
        result2 = 31 * result2 + this.minor;
        result2 = 31 * result2 + this.bugfix;
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/util/Version";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "parseVersion";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "compareTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

