/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.TypeAnnotationProvider;
import com.intellij.psi.impl.EmptySubstitutorImpl;
import com.intellij.psi.impl.light.LightTypeParameter;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiSubstitutorImpl
implements PsiSubstitutor {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.PsiSubstitutorImpl");
    private static final TObjectHashingStrategy<PsiTypeParameter> PSI_EQUIVALENCE = new TObjectHashingStrategy<PsiTypeParameter>(){

        @Override
        public int computeHashCode(PsiTypeParameter object) {
            String name = object.getName();
            return name == null ? 0 : name.hashCode();
        }

        @Override
        public boolean equals(PsiTypeParameter element1, PsiTypeParameter element2) {
            return element1.getManager().areElementsEquivalent(element1, element2);
        }
    };
    private final Map<PsiTypeParameter, PsiType> mySubstitutionMap;
    private final SubstitutionVisitor mySimpleSubstitutionVisitor;
    private static RecursionGuard ourGuard = RecursionManager.createGuard("substituteGuard");

    private PsiSubstitutorImpl(@NotNull Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(0);
        }
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new THashMap<PsiTypeParameter, PsiType>(map2, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl() {
        this.mySimpleSubstitutionVisitor = new SubstitutionVisitor();
        this.mySubstitutionMap = new THashMap<PsiTypeParameter, PsiType>(2, PSI_EQUIVALENCE);
    }

    PsiSubstitutorImpl(@NotNull PsiTypeParameter typeParameter, PsiType mapping2) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(1);
        }
        this();
        this.mySubstitutionMap.put(typeParameter, mapping2);
    }

    PsiSubstitutorImpl(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(2);
        }
        this();
        this.putAllInternal(parentClass, mappings);
    }

    @Override
    public PsiType substitute(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(3);
        }
        if (this.containsInMap(typeParameter)) {
            return this.getFromMap(typeParameter);
        }
        return JavaPsiFacade.getInstance(typeParameter.getProject()).getElementFactory().createType(typeParameter);
    }

    private boolean containsInMap(PsiTypeParameter typeParameter) {
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.containsKey(typeParameter);
    }

    private PsiType getFromMap(@NotNull PsiTypeParameter typeParameter) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(4);
        }
        if (typeParameter instanceof LightTypeParameter && ((LightTypeParameter)typeParameter).useDelegateToSubstitute()) {
            typeParameter = ((LightTypeParameter)typeParameter).getDelegate();
        }
        return this.mySubstitutionMap.get(typeParameter);
    }

    @Override
    public PsiType substitute(PsiType type2) {
        if (type2 == null) {
            return null;
        }
        PsiUtil.ensureValidType(type2);
        PsiType substituted = type2.accept(this.mySimpleSubstitutionVisitor);
        return this.correctExternalSubstitution(substituted, type2);
    }

    @Override
    public PsiType substituteWithBoundsPromotion(@NotNull PsiTypeParameter typeParameter) {
        PsiType substituted;
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(5);
        }
        if ((substituted = this.substitute(typeParameter)) instanceof PsiWildcardType && !((PsiWildcardType)substituted).isSuper()) {
            PsiWildcardType wildcard;
            PsiWildcardType wildcardType = (PsiWildcardType)substituted;
            PsiType glb = PsiCapturedWildcardType.captureUpperBound(typeParameter, wildcardType, this);
            if (glb instanceof PsiWildcardType) {
                return glb;
            }
            if (glb instanceof PsiCapturedWildcardType && !(wildcard = ((PsiCapturedWildcardType)glb).getWildcard()).isSuper()) {
                return wildcard;
            }
            if (glb != null) {
                return PsiWildcardType.createExtends(typeParameter.getManager(), glb);
            }
        }
        return substituted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PsiSubstitutorImpl)) {
            return false;
        }
        PsiSubstitutorImpl that = (PsiSubstitutorImpl)o;
        return !(this.mySubstitutionMap != null ? !this.mySubstitutionMap.equals(that.mySubstitutionMap) : that.mySubstitutionMap != null);
    }

    public int hashCode() {
        return this.mySubstitutionMap != null ? this.mySubstitutionMap.hashCode() : 0;
    }

    private PsiType rawTypeForTypeParameter(PsiTypeParameter typeParameter) {
        PsiClassType[] extendsTypes = typeParameter.getExtendsListTypes();
        if (extendsTypes.length > 0) {
            return ourGuard.doPreventingRecursion(extendsTypes[0], true, () -> this.substitute(extendsTypes[0]));
        }
        return PsiType.getJavaLangObject(typeParameter.getManager(), typeParameter.getResolveScope());
    }

    private PsiType correctExternalSubstitution(PsiType substituted, @NotNull PsiType original) {
        if (original == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(6);
        }
        if (substituted != null) {
            return substituted;
        }
        return original.accept(new PsiTypeVisitor<PsiType>(){

            @Override
            public PsiType visitArrayType(PsiArrayType arrayType) {
                return new PsiArrayType(arrayType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitEllipsisType(PsiEllipsisType ellipsisType) {
                return new PsiEllipsisType(ellipsisType.getComponentType().accept(this));
            }

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClass aClass2 = classType.resolve();
                if (aClass2 == null) {
                    return classType;
                }
                if (aClass2 instanceof PsiTypeParameter) {
                    return PsiSubstitutorImpl.this.rawTypeForTypeParameter((PsiTypeParameter)aClass2);
                }
                return JavaPsiFacade.getInstance(aClass2.getProject()).getElementFactory().createType(aClass2);
            }

            @Override
            public PsiType visitType(PsiType type2) {
                return null;
            }
        });
    }

    protected PsiSubstitutorImpl clone() {
        return new PsiSubstitutorImpl(this.mySubstitutionMap);
    }

    @Override
    @NotNull
    public PsiSubstitutor put(@NotNull PsiTypeParameter typeParameter, PsiType mapping2) {
        if (typeParameter == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(7);
        }
        PsiSubstitutorImpl ret = this.clone();
        if (mapping2 != null && !mapping2.isValid()) {
            LOG.error("Invalid type in substitutor: " + mapping2 + "; " + mapping2.getClass());
        }
        ret.mySubstitutionMap.put(typeParameter, mapping2);
        PsiSubstitutorImpl psiSubstitutorImpl = ret;
        if (psiSubstitutorImpl == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(8);
        }
        return psiSubstitutorImpl;
    }

    private void putAllInternal(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(9);
        }
        PsiTypeParameter[] params2 = parentClass.getTypeParameters();
        for (int i = 0; i < params2.length; ++i) {
            PsiTypeParameter param = params2[i];
            assert (param != null);
            if (mappings != null && mappings.length > i) {
                PsiType mapping2 = mappings[i];
                this.mySubstitutionMap.put(param, mapping2);
                if (mapping2 == null || mapping2.isValid()) continue;
                LOG.error("Invalid type in substitutor: " + mapping2);
                continue;
            }
            this.mySubstitutionMap.put(param, null);
        }
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiClass parentClass, PsiType[] mappings) {
        if (parentClass == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(10);
        }
        PsiSubstitutorImpl substitutor2 = this.clone();
        substitutor2.putAllInternal(parentClass, mappings);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor2;
        if (psiSubstitutorImpl == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(11);
        }
        return psiSubstitutorImpl;
    }

    @Override
    @NotNull
    public PsiSubstitutor putAll(@NotNull PsiSubstitutor another) {
        if (another == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(12);
        }
        if (another instanceof EmptySubstitutorImpl) {
            PsiSubstitutorImpl psiSubstitutorImpl = this;
            if (psiSubstitutorImpl == null) {
                PsiSubstitutorImpl.$$$reportNull$$$0(13);
            }
            return psiSubstitutorImpl;
        }
        PsiSubstitutorImpl anotherImpl = (PsiSubstitutorImpl)another;
        PsiSubstitutorImpl substitutor2 = this.clone();
        substitutor2.mySubstitutionMap.putAll(anotherImpl.mySubstitutionMap);
        PsiSubstitutorImpl psiSubstitutorImpl = substitutor2;
        if (psiSubstitutorImpl == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(14);
        }
        return psiSubstitutorImpl;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        Set<Map.Entry<PsiTypeParameter, PsiType>> set = this.mySubstitutionMap.entrySet();
        for (Map.Entry<PsiTypeParameter, PsiType> entry : set) {
            PsiTypeParameter typeParameter = entry.getKey();
            buffer.append(typeParameter.getName());
            PsiTypeParameterListOwner owner = typeParameter.getOwner();
            if (owner instanceof PsiClass) {
                buffer.append(" of ");
                buffer.append(((PsiClass)owner).getQualifiedName());
            } else if (owner instanceof PsiMethod) {
                buffer.append(" of ");
                buffer.append(((PsiMethod)owner).getName());
                buffer.append(" in ");
                PsiClass aClass2 = ((PsiMethod)owner).getContainingClass();
                buffer.append(aClass2 != null ? aClass2.getQualifiedName() : "<no class>");
            }
            buffer.append(" -> ");
            if (entry.getValue() != null) {
                buffer.append(entry.getValue().getCanonicalText());
            } else {
                buffer.append("null");
            }
            buffer.append('\n');
        }
        return buffer.toString();
    }

    public static PsiSubstitutor createSubstitutor(@Nullable Map<PsiTypeParameter, PsiType> map2) {
        if (map2 == null || map2.isEmpty()) {
            return EMPTY;
        }
        return new PsiSubstitutorImpl(map2);
    }

    @Override
    public boolean isValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null || type2.isValid()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void ensureValid() {
        for (PsiType type2 : this.mySubstitutionMap.values()) {
            if (type2 == null) continue;
            PsiUtil.ensureValidType(type2);
        }
    }

    @Override
    @NotNull
    public Map<PsiTypeParameter, PsiType> getSubstitutionMap() {
        Map<PsiTypeParameter, PsiType> map2 = Collections.unmodifiableMap(this.mySubstitutionMap);
        if (map2 == null) {
            PsiSubstitutorImpl.$$$reportNull$$$0(15);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameter";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiSubstitutorImpl";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "put";
                break;
            }
            case 11: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "putAll";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitutionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "substitute";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFromMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "substituteWithBoundsPromotion";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "correctExternalSubstitution";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "putAllInternal";
                break;
            }
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "putAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class SubstitutionVisitor
    extends PsiTypeMapper {
        private SubstitutionVisitor() {
        }

        @Override
        public PsiType visitCapturedWildcardType(PsiCapturedWildcardType type2) {
            return type2;
        }

        @Override
        public PsiType visitType(PsiType type2) {
            return null;
        }

        @Override
        public PsiType visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound == null) {
                return wildcardType;
            }
            PsiType newBound = bound.accept(this);
            if (newBound == null) {
                return null;
            }
            assert (newBound.isValid()) : newBound.getClass() + "; " + bound.isValid();
            if (newBound instanceof PsiWildcardType) {
                PsiType newBoundBound = ((PsiWildcardType)newBound).getBound();
                return !((PsiWildcardType)newBound).isBounded() ? PsiWildcardType.createUnbounded(wildcardType.getManager()) : this.rebound(wildcardType, newBoundBound);
            }
            return newBound == PsiType.NULL ? newBound : this.rebound(wildcardType, newBound);
        }

        private PsiWildcardType rebound(PsiWildcardType type2, PsiType newBound) {
            LOG.assertTrue(type2.getBound() != null);
            LOG.assertTrue(newBound.isValid());
            if (type2.isExtends()) {
                if (newBound.equalsToText("java.lang.Object")) {
                    return PsiWildcardType.createUnbounded(type2.getManager());
                }
                return PsiWildcardType.createExtends(type2.getManager(), newBound);
            }
            return PsiWildcardType.createSuper(type2.getManager(), newBound);
        }

        @Override
        public PsiType visitClassType(final PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass2 = resolveResult.getElement();
            if (aClass2 == null) {
                return classType;
            }
            PsiUtilCore.ensureValid(aClass2);
            if (aClass2 instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)aClass2;
                if (PsiSubstitutorImpl.this.containsInMap(typeParameter)) {
                    final PsiType result2 = this.substituteTypeParameter(typeParameter);
                    if (result2 != null) {
                        PsiUtil.ensureValidType(result2);
                        if (result2 instanceof PsiClassType || result2 instanceof PsiArrayType || result2 instanceof PsiWildcardType) {
                            return result2.annotate(new TypeAnnotationProvider(){

                                @Override
                                @NotNull
                                public PsiAnnotation[] getAnnotations() {
                                    PsiAnnotation[] psiAnnotationArray = ArrayUtil.mergeArrays(result2.getAnnotations(), classType.getAnnotations());
                                    if (psiAnnotationArray == null) {
                                        1.$$$reportNull$$$0(0);
                                    }
                                    return psiAnnotationArray;
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor$1", "getAnnotations"));
                                }
                            });
                        }
                    }
                    return result2;
                }
                return classType;
            }
            HashMap<PsiTypeParameter, PsiType> hashMap = new HashMap<PsiTypeParameter, PsiType>(2);
            if (!this.processClass(aClass2, resolveResult.getSubstitutor(), hashMap)) {
                return null;
            }
            PsiClassType result3 = JavaPsiFacade.getElementFactory(aClass2.getProject()).createType(aClass2, PsiSubstitutorImpl.createSubstitutor(hashMap), classType.getLanguageLevel());
            PsiUtil.ensureValidType(result3);
            return result3;
        }

        private PsiType substituteTypeParameter(@NotNull PsiTypeParameter typeParameter) {
            if (typeParameter == null) {
                SubstitutionVisitor.$$$reportNull$$$0(0);
            }
            return PsiSubstitutorImpl.this.getFromMap(typeParameter);
        }

        private PsiType substituteInternal(PsiType type2) {
            return type2.accept(this);
        }

        private boolean processClass(PsiClass resolve2, PsiSubstitutor originalSubstitutor, Map<PsiTypeParameter, PsiType> substMap) {
            PsiTypeParameter[] params2;
            for (PsiTypeParameter param : params2 = resolve2.getTypeParameters()) {
                PsiType original = originalSubstitutor.substitute(param);
                if (original == null) {
                    substMap.put(param, null);
                    continue;
                }
                substMap.put(param, this.substituteInternal(original));
            }
            if (resolve2.hasModifierProperty("static")) {
                return true;
            }
            PsiClass containingClass = resolve2.getContainingClass();
            return containingClass == null || this.processClass(containingClass, originalSubstitutor, substMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "com/intellij/psi/impl/PsiSubstitutorImpl$SubstitutionVisitor", "substituteTypeParameter"));
        }
    }
}

