/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UnfairTextRange;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.impl.light.LightMemberReference;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

class ConstructorReferencesSearchHelper {
    private final PsiManager myManager;

    ConstructorReferencesSearchHelper(@NotNull PsiManager manager) {
        if (manager == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(0);
        }
        this.myManager = manager;
    }

    boolean processConstructorReferences(@NotNull Processor<PsiReference> processor, @NotNull PsiMethod constructor, @NotNull PsiClass containingClass, @NotNull SearchScope searchScope, @NotNull Project project, boolean ignoreAccessScope, boolean isStrictSignatureSearch, @NotNull SearchRequestCollector collector2) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(1);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(2);
        }
        if (containingClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(4);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(5);
        }
        if (collector2 == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(6);
        }
        boolean[] constructorCanBeCalledImplicitly = new boolean[1];
        boolean[] isEnum = new boolean[1];
        boolean[] isUnder18 = new boolean[1];
        DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            PsiParameter[] parameters2;
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(49);
            }
            if (containingClass == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(50);
            }
            boolean bl = constructorCanBeCalledImplicitly[0] = (parameters2 = constructor.getParameterList().getParameters()).length == 0;
            if (!constructorCanBeCalledImplicitly[0]) {
                constructorCanBeCalledImplicitly[0] = parameters2.length == 1 && parameters2[0].isVarArgs();
            }
            isEnum[0] = containingClass.isEnum();
            isUnder18[0] = PsiUtil.getLanguageLevel(containingClass).isAtLeast(LanguageLevel.JDK_1_8);
            return null;
        });
        if (isEnum[0] && !ConstructorReferencesSearchHelper.processEnumReferences(processor, constructor, project, containingClass)) {
            return false;
        }
        PairProcessor<PsiReference, SearchRequestCollector> processor1 = (reference, collector1) -> {
            PsiMethod constructor1;
            PsiElement parent2;
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(46);
            }
            if (processor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(47);
            }
            if (containingClass == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(48);
            }
            if ((parent2 = reference.getElement().getParent()) instanceof PsiAnonymousClass) {
                parent2 = parent2.getParent();
            }
            if (parent2 instanceof PsiNewExpression && (constructor1 = ((PsiNewExpression)parent2).resolveConstructor()) != null && (isStrictSignatureSearch ? this.myManager.areElementsEquivalent(constructor, constructor1) : this.myManager.areElementsEquivalent(containingClass, constructor1.getContainingClass()))) {
                return processor.process((PsiReference)reference);
            }
            return true;
        };
        SearchScope restrictedScope = searchScope instanceof GlobalSearchScope ? GlobalSearchScope.getScopeRestrictedByFileTypes((GlobalSearchScope)searchScope, JavaFileType.INSTANCE) : searchScope;
        ReferencesSearch.searchOptimized(containingClass, restrictedScope, ignoreAccessScope, collector2, true, processor1);
        if (isUnder18[0] && !ConstructorReferencesSearchHelper.process18MethodPointers(processor, constructor, project, containingClass, restrictedScope)) {
            return false;
        }
        if (!DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            if (containingClass == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(41);
            }
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(42);
            }
            if (searchScope == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(43);
            }
            if (project == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(44);
            }
            if (processor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(45);
            }
            return this.processSuperOrThis(containingClass, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "this", "super", processor);
        }).booleanValue()) {
            return false;
        }
        Processor<PsiClass> processor2 = inheritor -> {
            PsiElement navigationElement;
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(37);
            }
            if (searchScope == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(38);
            }
            if (project == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(39);
            }
            if (processor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(40);
            }
            if ((navigationElement = inheritor.getNavigationElement()) instanceof PsiClass) {
                return this.processSuperOrThis((PsiClass)navigationElement, constructor, constructorCanBeCalledImplicitly[0], searchScope, project, isStrictSignatureSearch, "super", "this", processor);
            }
            return true;
        };
        return ClassInheritorsSearch.search(containingClass, searchScope, false).forEach(processor2);
    }

    private static boolean processEnumReferences(@NotNull Processor<PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass2) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(7);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(8);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(9);
        }
        if (aClass2 == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(10);
        }
        return DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            if (aClass2 == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(34);
            }
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(35);
            }
            if (processor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(36);
            }
            for (PsiField field : aClass2.getFields()) {
                PsiReference reference;
                if (!(field instanceof PsiEnumConstant) || (reference = field.getReference()) == null || !reference.isReferenceTo(constructor) || processor.process(reference)) continue;
                return false;
            }
            return true;
        });
    }

    private static boolean process18MethodPointers(@NotNull Processor<PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass aClass2, SearchScope searchScope) {
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(11);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(12);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(13);
        }
        if (aClass2 == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(14);
        }
        return ReferencesSearch.search(aClass2, searchScope).forEach(reference -> {
            PsiElement element;
            if (project == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(29);
            }
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(30);
            }
            if (processor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(31);
            }
            if ((element = reference.getElement()) != null) {
                return DumbService.getInstance(project).runReadActionInSmartMode(() -> {
                    PsiElement parent2;
                    if (constructor == null) {
                        ConstructorReferencesSearchHelper.$$$reportNull$$$0(32);
                    }
                    if (processor == null) {
                        ConstructorReferencesSearchHelper.$$$reportNull$$$0(33);
                    }
                    if ((parent2 = element.getParent()) instanceof PsiMethodReferenceExpression && ((PsiMethodReferenceExpression)parent2).getReferenceNameElement() instanceof PsiKeyword && ((PsiMethodReferenceExpression)parent2).isReferenceTo(constructor) && !processor.process((PsiReference)((Object)parent2))) {
                        return false;
                    }
                    return true;
                });
            }
            return true;
        });
    }

    private boolean processSuperOrThis(@NotNull PsiClass inheritor, @NotNull PsiMethod constructor, boolean constructorCanBeCalledImplicitly, @NotNull SearchScope searchScope, @NotNull Project project, boolean isStrictSignatureSearch, @NotNull String superOrThisKeyword, @NotNull String thisOrSuperKeyword, @NotNull Processor<PsiReference> processor) {
        PsiMethod[] constructors2;
        if (inheritor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(15);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(16);
        }
        if (searchScope == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(17);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(18);
        }
        if (superOrThisKeyword == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(19);
        }
        if (thisOrSuperKeyword == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(21);
        }
        if ((constructors2 = inheritor.getConstructors()).length == 0 && constructorCanBeCalledImplicitly && !this.processImplicitConstructorCall(inheritor, processor, constructor, project, inheritor)) {
            return false;
        }
        for (PsiMethod method : constructors2) {
            PsiReferenceExpression refExpr;
            PsiExpression expr;
            PsiStatement statement2;
            PsiCodeBlock body = method.getBody();
            if (body == null || method == constructor && isStrictSignatureSearch) continue;
            PsiStatement[] statements = body.getStatements();
            if (statements.length != 0 && (statement2 = statements[0]) instanceof PsiExpressionStatement && (expr = ((PsiExpressionStatement)statement2).getExpression()) instanceof PsiMethodCallExpression && PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)(refExpr = ((PsiMethodCallExpression)expr).getMethodExpression()))) {
                if (refExpr.textMatches(superOrThisKeyword)) {
                    boolean match2;
                    PsiElement referencedElement = refExpr.resolve();
                    if (!(referencedElement instanceof PsiMethod)) continue;
                    PsiMethod constructor1 = (PsiMethod)referencedElement;
                    boolean bl = match2 = isStrictSignatureSearch ? this.myManager.areElementsEquivalent(constructor1, constructor) : this.myManager.areElementsEquivalent(constructor.getContainingClass(), constructor1.getContainingClass());
                    if (!match2 || processor.process(refExpr)) continue;
                    return false;
                }
                if (refExpr.textMatches(thisOrSuperKeyword)) continue;
            }
            if (!constructorCanBeCalledImplicitly || !PsiSearchScopeUtil.isInScope(searchScope, (PsiElement)method) || this.processImplicitConstructorCall(method, processor, constructor, project, inheritor)) continue;
            return false;
        }
        return true;
    }

    private boolean processImplicitConstructorCall(final @NotNull PsiMember usage, @NotNull Processor<PsiReference> processor, @NotNull PsiMethod constructor, @NotNull Project project, @NotNull PsiClass containingClass) {
        if (usage == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(23);
        }
        if (constructor == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(24);
        }
        if (project == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(25);
        }
        if (containingClass == null) {
            ConstructorReferencesSearchHelper.$$$reportNull$$$0(26);
        }
        if (containingClass instanceof PsiAnonymousClass) {
            return true;
        }
        PsiClass ctrClass = constructor.getContainingClass();
        if (ctrClass == null) {
            return true;
        }
        boolean isImplicitSuper = DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            if (containingClass == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(28);
            }
            return this.myManager.areElementsEquivalent(ctrClass, containingClass.getSuperClass());
        });
        if (!isImplicitSuper) {
            return true;
        }
        PsiElement resolved = JavaResolveUtil.resolveImaginarySuperCallInThisPlace(usage, project, ctrClass);
        boolean resolvesToThisConstructor = DumbService.getInstance(project).runReadActionInSmartMode(() -> {
            if (constructor == null) {
                ConstructorReferencesSearchHelper.$$$reportNull$$$0(27);
            }
            return this.myManager.areElementsEquivalent(constructor, resolved);
        });
        if (!resolvesToThisConstructor) {
            return true;
        }
        return processor.process(new LightMemberReference(this.myManager, usage, PsiSubstitutor.EMPTY){

            @Override
            public PsiElement getElement() {
                return usage;
            }

            @Override
            public TextRange getRangeInElement() {
                PsiElement identifier;
                if (usage instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)((Object)usage)).getNameIdentifier()) != null) {
                    int startOffsetInParent = identifier.getStartOffsetInParent();
                    if (startOffsetInParent >= 0) {
                        return TextRange.from(startOffsetInParent, identifier.getTextLength());
                    }
                    return new UnfairTextRange(-1, -1);
                }
                return super.getRangeInElement();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: 
            case 7: 
            case 11: 
            case 21: 
            case 23: 
            case 31: 
            case 33: 
            case 36: 
            case 40: 
            case 45: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 8: 
            case 12: 
            case 16: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 35: 
            case 37: 
            case 42: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 3: 
            case 26: 
            case 28: 
            case 41: 
            case 48: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 4: 
            case 17: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: 
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 39: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 10: 
            case 14: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritor";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superOrThisKeyword";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisOrSuperKeyword";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/ConstructorReferencesSearchHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processConstructorReferences";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "processEnumReferences";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "process18MethodPointers";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "processSuperOrThis";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "processImplicitConstructorCall";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processImplicitConstructorCall$8";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processImplicitConstructorCall$7";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$process18MethodPointers$6";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$null$5";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processEnumReferences$4";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processConstructorReferences$3";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processConstructorReferences$2";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processConstructorReferences$1";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$processConstructorReferences$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

