/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.search.JavaOverridingMethodsSearcher;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllOverridingMethodsSearch;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaAllOverridingMethodsSearcher
implements QueryExecutor<Pair<PsiMethod, PsiMethod>, AllOverridingMethodsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull AllOverridingMethodsSearch.SearchParameters p, @NotNull Processor<Pair<PsiMethod, PsiMethod>> consumer) {
        if (p == null) {
            JavaAllOverridingMethodsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaAllOverridingMethodsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass psiClass = p.getPsiClass();
        List potentials = ReadAction.compute(() -> ContainerUtil.filter(psiClass.getMethods(), PsiUtil::canBeOverridden));
        SearchScope scope = p.getScope();
        Processor<PsiClass> inheritorsProcessor = inheritor -> {
            if (consumer == null) {
                JavaAllOverridingMethodsSearcher.$$$reportNull$$$0(2);
            }
            Project project = psiClass.getProject();
            for (PsiMethod superMethod : potentials) {
                PsiMethod inInheritor;
                ProgressManager.checkCanceled();
                if (superMethod.hasModifierProperty("packageLocal") && !JavaPsiFacade.getInstance(project).arePackagesTheSame(psiClass, (PsiElement)inheritor) || (inInheritor = JavaOverridingMethodsSearcher.findOverridingMethod(project, inheritor, superMethod, psiClass)) == null || consumer.process(Pair.create(superMethod, inInheritor))) continue;
                return false;
            }
            return true;
        };
        return ClassInheritorsSearch.search(psiClass, scope, true).forEach(inheritorsProcessor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/JavaAllOverridingMethodsSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$execute$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

