/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.compiler.CompilerDirectHierarchyInfo;
import com.intellij.compiler.CompilerReferenceService;
import com.intellij.concurrency.JobLauncher;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiEnumConstantInitializer;
import com.intellij.psi.PsiField;
import com.intellij.psi.impl.java.stubs.index.JavaAnonymousClassBaseRefOccurenceIndex;
import com.intellij.psi.impl.java.stubs.index.JavaSuperClassNameOccurenceIndex;
import com.intellij.psi.impl.search.HighlightingCaches;
import com.intellij.psi.impl.search.JavaClassInheritorsSearcher;
import com.intellij.psi.impl.search.StubHierarchyInheritorSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AllClassesSearch;
import com.intellij.psi.search.searches.DirectClassInheritorsSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class JavaDirectInheritorsSearcher
implements QueryExecutor<PsiClass, DirectClassInheritorsSearch.SearchParameters> {
    @Override
    public boolean execute(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull Processor<PsiClass> consumer) {
        SearchScope useScope;
        SearchScope scope;
        if (parameters2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(1);
        }
        PsiClass baseClass = JavaDirectInheritorsSearcher.getClassToSearch(parameters2);
        assert (parameters2.isCheckInheritance());
        Project project = PsiUtilCore.getProjectInReadAction(baseClass);
        if (JavaClassInheritorsSearcher.isJavaLangObject(baseClass)) {
            SearchScope useScope2 = ReadAction.compute(baseClass::getUseScope);
            return AllClassesSearch.search(useScope2, project).forEach(psiClass -> {
                if (consumer == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(40);
                }
                ProgressManager.checkCanceled();
                if (psiClass.isInterface()) {
                    return consumer.process((PsiClass)psiClass);
                }
                PsiClass superClass = psiClass.getSuperClass();
                return superClass == null || !JavaClassInheritorsSearcher.isJavaLangObject(superClass) || consumer.process((PsiClass)psiClass);
            });
        }
        CompilerDirectHierarchyInfo info = JavaDirectInheritorsSearcher.performSearchUsingCompilerIndices(parameters2, parameters2.getScope(), project);
        if (info == null) {
            scope = parameters2.getScope();
            useScope = ReadAction.compute(baseClass::getUseScope);
        } else {
            if (!JavaDirectInheritorsSearcher.processInheritorCandidates(info.getHierarchyChildren(), consumer, parameters2.includeAnonymous())) {
                return false;
            }
            scope = ReadAction.compute(() -> {
                if (parameters2 == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(39);
                }
                return parameters2.getScope().intersectWith(info.getDirtyScope());
            });
            useScope = ReadAction.compute(() -> baseClass.getUseScope().intersectWith(info.getDirtyScope()));
        }
        PsiClass[] cache2 = JavaDirectInheritorsSearcher.getOrCalculateDirectSubClasses(project, baseClass, useScope);
        if (cache2.length == 0) {
            return true;
        }
        VirtualFile baseClassJarFile = null;
        int groupStart = 0;
        boolean sameJarClassFound = false;
        String currentFQN = null;
        boolean[] isOutOfScope = new boolean[cache2.length];
        for (int i = 0; i <= cache2.length; ++i) {
            String fqn;
            PsiClass subClass;
            ProgressManager.checkCanceled();
            PsiClass psiClass2 = subClass = i == cache2.length ? null : cache2[i];
            if (subClass instanceof PsiAnonymousClass && !parameters2.includeAnonymous()) {
                return true;
            }
            if (i != cache2.length && !JavaDirectInheritorsSearcher.isInScope(scope, subClass)) {
                isOutOfScope[i] = true;
                continue;
            }
            String string = fqn = i == cache2.length ? null : ReadAction.compute(subClass::getQualifiedName);
            if (currentFQN != null && Comparing.equal(fqn, currentFQN)) {
                boolean fromSameJar;
                VirtualFile currentJarFile = JavaDirectInheritorsSearcher.getJarFile(subClass);
                if (baseClassJarFile == null) {
                    baseClassJarFile = JavaDirectInheritorsSearcher.getJarFile(baseClass);
                }
                if (!(fromSameJar = Comparing.equal(currentJarFile, baseClassJarFile))) continue;
                if (!consumer.process(subClass)) {
                    return false;
                }
                sameJarClassFound = true;
                continue;
            }
            currentFQN = fqn;
            if (!sameJarClassFound) {
                for (int g = groupStart; g < i; ++g) {
                    PsiClass subClassCandidate;
                    ProgressManager.checkCanceled();
                    if (isOutOfScope[g] || consumer.process(subClassCandidate = cache2[g])) continue;
                    return false;
                }
            }
            groupStart = i;
            sameJarClassFound = false;
        }
        return true;
    }

    private static PsiClass getClassToSearch(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2) {
        if (parameters2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(2);
        }
        return ReadAction.compute(() -> {
            if (parameters2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(38);
            }
            return (PsiClass)PsiUtil.preferCompiledElement(parameters2.getClassToProcess());
        });
    }

    private static boolean isInScope(@NotNull SearchScope scope, @NotNull PsiClass subClass) {
        if (scope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(3);
        }
        if (subClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(4);
        }
        return ReadAction.compute(() -> {
            if (scope == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(36);
            }
            if (subClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(37);
            }
            return PsiSearchScopeUtil.isInScope(scope, (PsiElement)subClass);
        });
    }

    @NotNull
    private static PsiClass[] getOrCalculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull SearchScope useScope) {
        ConcurrentMap<PsiClass, PsiClass[]> map2;
        PsiClass[] cache2;
        if (project == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(5);
        }
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(6);
        }
        if (useScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(7);
        }
        if ((cache2 = (PsiClass[])(map2 = HighlightingCaches.getInstance((Project)project).DIRECT_SUB_CLASSES).get(baseClass)) != null) {
            if (cache2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(8);
            }
            return cache2;
        }
        String baseClassName = ReadAction.compute(baseClass::getName);
        if (StringUtil.isEmpty(baseClassName)) {
            if (PsiClass.EMPTY_ARRAY == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(9);
            }
            return PsiClass.EMPTY_ARRAY;
        }
        cache2 = JavaDirectInheritorsSearcher.calculateDirectSubClasses(project, baseClass, baseClassName, useScope);
        if (ReadAction.compute(baseClass::isPhysical).booleanValue()) {
            cache2 = ConcurrencyUtil.cacheOrGet(map2, baseClass, cache2);
        }
        if (cache2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(10);
        }
        return cache2;
    }

    private static <T> boolean processConcurrentlyIfTooMany(@NotNull Collection<T> collection, @NotNull Processor<? super T> processor) {
        int size;
        if (collection == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(12);
        }
        if ((size = collection.size()) == 0) {
            return true;
        }
        if (size > 100) {
            return JobLauncher.getInstance().invokeConcurrentlyUnderProgress(new ArrayList<T>(collection), ProgressIndicatorProvider.getGlobalProgressIndicator(), true, processor);
        }
        return ContainerUtil.process(collection, processor);
    }

    @NotNull
    private static PsiClass[] calculateDirectSubClasses(@NotNull Project project, @NotNull PsiClass baseClass, @NotNull String baseClassName, @NotNull SearchScope useScope) {
        if (project == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(13);
        }
        if (baseClass == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(14);
        }
        if (baseClassName == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(15);
        }
        if (useScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(16);
        }
        DumbService dumbService = DumbService.getInstance(project);
        GlobalSearchScope globalUseScope = dumbService.runReadActionInSmartMode(() -> {
            if (useScope == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(34);
            }
            if (project == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(35);
            }
            return StubHierarchyInheritorSearcher.restrictScope(GlobalSearchScopeUtil.toGlobalSearchScope(useScope, project));
        });
        Collection candidates2 = dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(32);
            }
            if (project == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(33);
            }
            return JavaSuperClassNameOccurenceIndex.getInstance().get(baseClassName, project, globalUseScope);
        });
        HashMap classesWithFqn = new HashMap();
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(candidates2, referenceList -> {
            if (baseClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(30);
            }
            ProgressManager.checkCanceled();
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiClass candidate2;
                boolean isInheritor;
                if (baseClass == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(31);
                }
                if (isInheritor = (candidate2 = (PsiClass)referenceList.getParent()).isInheritor(baseClass, false)) {
                    String fqn = candidate2.getQualifiedName();
                    Map map2 = classesWithFqn;
                    synchronized (map2) {
                        Object value = classesWithFqn.get(fqn);
                        if (value == null) {
                            classesWithFqn.put(fqn, candidate2);
                        } else if (value instanceof PsiClass) {
                            ArrayList<PsiClass> list2 = new ArrayList<PsiClass>();
                            list2.add((PsiClass)value);
                            list2.add(candidate2);
                            classesWithFqn.put(fqn, list2);
                        } else {
                            List list3 = (List)value;
                            list3.add(candidate2);
                        }
                    }
                }
            });
            return true;
        });
        ArrayList<PsiClass> result2 = new ArrayList<PsiClass>();
        for (Object value : classesWithFqn.values()) {
            if (value instanceof PsiClass) {
                result2.add((PsiClass)value);
                continue;
            }
            List list2 = (List)value;
            result2.addAll(list2);
        }
        Collection anonymousCandidates = dumbService.runReadActionInSmartMode(() -> {
            if (baseClassName == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(28);
            }
            if (project == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(29);
            }
            return JavaAnonymousClassBaseRefOccurenceIndex.getInstance().get(baseClassName, project, globalUseScope);
        });
        JavaDirectInheritorsSearcher.processConcurrentlyIfTooMany(anonymousCandidates, candidate2 -> {
            boolean isInheritor;
            if (baseClass == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(26);
            }
            if (isInheritor = dumbService.runReadActionInSmartMode(() -> {
                if (baseClass == null) {
                    JavaDirectInheritorsSearcher.$$$reportNull$$$0(27);
                }
                return candidate2.isInheritor(baseClass, false);
            }).booleanValue()) {
                List list2 = result2;
                synchronized (list2) {
                    result2.add((PsiClass)candidate2);
                }
            }
            return true;
        });
        boolean isEnum = ReadAction.compute(baseClass::isEnum);
        if (isEnum) {
            PsiField[] fields2;
            for (PsiField field : fields2 = ReadAction.compute(baseClass::getFields)) {
                ProgressManager.checkCanceled();
                if (!(field instanceof PsiEnumConstant)) continue;
                PsiEnumConstantInitializer initializingClass2 = ReadAction.compute(((PsiEnumConstant)field)::getInitializingClass);
                if (initializingClass2 == null) continue;
                result2.add(initializingClass2);
            }
        }
        PsiClass[] psiClassArray = result2.isEmpty() ? PsiClass.EMPTY_ARRAY : result2.toArray(new PsiClass[result2.size()]);
        if (psiClassArray == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(17);
        }
        return psiClassArray;
    }

    private static VirtualFile getJarFile(@NotNull PsiClass aClass2) {
        if (aClass2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(18);
        }
        return ReadAction.compute(() -> {
            if (aClass2 == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(25);
            }
            return PsiUtil.getJarFile(aClass2);
        });
    }

    private static CompilerDirectHierarchyInfo performSearchUsingCompilerIndices(@NotNull DirectClassInheritorsSearch.SearchParameters parameters2, @NotNull SearchScope useScope, @NotNull Project project) {
        if (parameters2 == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(19);
        }
        if (useScope == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(20);
        }
        if (project == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(21);
        }
        if (!(useScope instanceof GlobalSearchScope)) {
            return null;
        }
        SearchScope scope = parameters2.getScope();
        if (!(scope instanceof GlobalSearchScope)) {
            return null;
        }
        CompilerReferenceService compilerReferenceService = CompilerReferenceService.getInstance(project);
        return compilerReferenceService.getDirectInheritors(JavaDirectInheritorsSearcher.getClassToSearch(parameters2), (GlobalSearchScope)scope, JavaFileType.INSTANCE);
    }

    private static boolean processInheritorCandidates(@NotNull Stream<PsiElement> classStream, @NotNull Processor<PsiClass> consumer, boolean acceptAnonymous) {
        if (classStream == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(22);
        }
        if (consumer == null) {
            JavaDirectInheritorsSearcher.$$$reportNull$$$0(23);
        }
        if (!acceptAnonymous) {
            classStream = classStream.filter(c -> !(c instanceof PsiAnonymousClass));
        }
        return ContainerUtil.process(classStream.iterator(), e -> {
            if (consumer == null) {
                JavaDirectInheritorsSearcher.$$$reportNull$$$0(24);
            }
            ProgressManager.checkCanceled();
            PsiClass c = (PsiClass)e;
            return consumer.process(c);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 23: 
            case 24: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 3: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 5: 
            case 13: 
            case 21: 
            case 29: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 14: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useScope";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 15: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClassName";
                break;
            }
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/JavaDirectInheritorsSearcher";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCalculateDirectSubClasses";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDirectSubClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassToSearch";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getOrCalculateDirectSubClasses";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processConcurrentlyIfTooMany";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateDirectSubClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getJarFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "performSearchUsingCompilerIndices";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processInheritorCandidates";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processInheritorCandidates$14";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getJarFile$12";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$11";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$10";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$9";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$8";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$7";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$6";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$calculateDirectSubClasses$5";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isInScope$4";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassToSearch$3";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$1";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "lambda$execute$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

