/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadActionProcessor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.search.ConstructorReferencesSearchHelper;
import com.intellij.psi.impl.search.MethodTextOccurrenceProcessor;
import com.intellij.psi.impl.search.PsiAnnotationMethodReferencesSearcher;
import com.intellij.psi.impl.search.SimpleAccessorReferenceSearcher;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class MethodUsagesSearcher
extends QueryExecutorBase<PsiReference, MethodReferencesSearch.SearchParameters> {
    @Override
    public void processQuery(@NotNull MethodReferencesSearch.SearchParameters p, @NotNull Processor<PsiReference> consumer) {
        if (p == null) {
            MethodUsagesSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            MethodUsagesSearcher.$$$reportNull$$$0(1);
        }
        PsiMethod method = p.getMethod();
        boolean[] isConstructor = new boolean[1];
        PsiManager[] psiManager = new PsiManager[1];
        String[] methodName = new String[1];
        boolean[] isValueAnnotation = new boolean[1];
        boolean[] needStrictSignatureSearch = new boolean[1];
        boolean strictSignatureSearch = p.isStrictSignatureSearch();
        PsiClass aClass2 = DumbService.getInstance(p.getProject()).runReadActionInSmartMode(() -> {
            PsiClass aClass1 = method.getContainingClass();
            if (aClass1 == null) {
                return null;
            }
            isConstructor[0] = method.isConstructor();
            psiManager[0] = aClass1.getManager();
            methodName[0] = method.getName();
            isValueAnnotation[0] = PsiUtil.isAnnotationMethod(method) && "value".equals(methodName[0]) && method.getParameterList().getParametersCount() == 0;
            needStrictSignatureSearch[0] = strictSignatureSearch && (aClass1 instanceof PsiAnonymousClass || aClass1.hasModifierProperty("final") || method.hasModifierProperty("static") || method.hasModifierProperty("final") || method.hasModifierProperty("private"));
            return aClass1;
        });
        if (aClass2 == null) {
            return;
        }
        SearchRequestCollector collector2 = p.getOptimizer();
        SearchScope searchScope = DumbService.getInstance(p.getProject()).runReadActionInSmartMode(p::getEffectiveSearchScope);
        if (searchScope == GlobalSearchScope.EMPTY_SCOPE) {
            return;
        }
        if (isConstructor[0]) {
            new ConstructorReferencesSearchHelper(psiManager[0]).processConstructorReferences(consumer, method, aClass2, searchScope, p.getProject(), false, strictSignatureSearch, collector2);
        }
        if (isValueAnnotation[0]) {
            ReadActionProcessor<PsiReference> refProcessor = PsiAnnotationMethodReferencesSearcher.createImplicitDefaultAnnotationMethodConsumer(consumer);
            ReferencesSearch.search(aClass2, searchScope).forEach(refProcessor);
        }
        if (needStrictSignatureSearch[0]) {
            ReferencesSearch.searchOptimized(method, searchScope, false, collector2, consumer);
            return;
        }
        if (StringUtil.isEmpty(methodName[0])) {
            return;
        }
        DumbService.getInstance(p.getProject()).runReadActionInSmartMode(() -> {
            PsiMethod[] psiMethodArray;
            if (strictSignatureSearch) {
                PsiMethod[] psiMethodArray2 = new PsiMethod[1];
                psiMethodArray = psiMethodArray2;
                psiMethodArray2[0] = method;
            } else {
                psiMethodArray = aClass2.findMethodsByName(methodName[0], false);
            }
            PsiMethod[] methods2 = psiMethodArray;
            short searchContext = 11;
            for (PsiMethod m : methods2) {
                collector2.searchWord(methodName[0], searchScope.intersectWith(m.getUseScope()), searchContext, true, m, this.getTextOccurrenceProcessor(new PsiMethod[]{m}, aClass2, strictSignatureSearch));
            }
            SearchScope accessScope = methods2[0].getUseScope();
            for (int i = 1; i < methods2.length; ++i) {
                PsiMethod method1 = methods2[i];
                accessScope = accessScope.union(method1.getUseScope());
            }
            SearchScope restrictedByAccessScope = searchScope.intersectWith(accessScope);
            SimpleAccessorReferenceSearcher.addPropertyAccessUsages(method, restrictedByAccessScope, collector2);
            return null;
        });
    }

    protected MethodTextOccurrenceProcessor getTextOccurrenceProcessor(PsiMethod[] methods2, PsiClass aClass2, boolean strictSignatureSearch) {
        return new MethodTextOccurrenceProcessor(aClass2, strictSignatureSearch, methods2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "p";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/MethodUsagesSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

