/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.SchemaReferencesProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.schema.ComplexTypeDescriptor;
import com.intellij.xml.impl.schema.TypeDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.impl.schema.XsdNsDescriptor;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeOrElementOrAttributeReference
implements PsiReference {
    @NonNls
    private static final String TARGET_NAMESPACE = "targetNamespace";
    private final PsiElement myElement;
    private TextRange myRange;
    private String nsPrefix;
    @Nullable
    private final ReferenceType myType;
    static final ResolveCache.Resolver RESOLVER = (ref, incompleteCode) -> ((TypeOrElementOrAttributeReference)ref).resolveInner();

    @Nullable
    public ReferenceType getType() {
        return this.myType;
    }

    public void setNamespacePrefix(String prefix) {
        this.nsPrefix = prefix;
    }

    protected TypeOrElementOrAttributeReference(PsiElement element, TextRange range, @Nullable ReferenceType type2) {
        this.myElement = element;
        this.myRange = range;
        assert (this.myRange.getLength() >= 0);
        this.myType = type2;
    }

    TypeOrElementOrAttributeReference(PsiElement element, TextRange range) {
        this(element, range, TypeOrElementOrAttributeReference.determineReferenceType(element));
    }

    @Nullable
    private static ReferenceType determineReferenceType(PsiElement element) {
        XmlAttribute attribute = PsiTreeUtil.getParentOfType(element, XmlAttribute.class);
        if (attribute == null) {
            return null;
        }
        XmlTag tag = attribute.getParent();
        String localName = tag.getLocalName();
        String attributeLocalName = attribute.getLocalName();
        if ("ref".equals(attributeLocalName) || "substitutionGroup".equals(attributeLocalName)) {
            if (localName.equals("group")) {
                return ReferenceType.GroupReference;
            }
            if (localName.equals("attributeGroup")) {
                return ReferenceType.AttributeGroupReference;
            }
            if ("element".equals(localName)) {
                return ReferenceType.ElementReference;
            }
            if ("attribute".equals(localName)) {
                return ReferenceType.AttributeReference;
            }
        } else if ("type".equals(attributeLocalName) || "base".equals(attributeLocalName) || "memberTypes".equals(attributeLocalName) || "itemType".equals(attributeLocalName)) {
            return ReferenceType.TypeReference;
        }
        return null;
    }

    @Override
    public PsiElement getElement() {
        return this.myElement;
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myRange;
    }

    @Override
    @Nullable
    public PsiElement resolve() {
        return ResolveCache.getInstance(this.getElement().getProject()).resolveWithCaching(this, (ref, incompleteCode) -> ref.resolveInner(), false, false);
    }

    private PsiElement resolveInner() {
        XmlTag tag = PsiTreeUtil.getContextOfType(this.myElement, XmlTag.class, false);
        if (tag == null) {
            return null;
        }
        String canonicalText = this.getCanonicalText();
        boolean[] redefined = new boolean[1];
        XsdNsDescriptor nsDescriptor = this.getDescriptor(tag, canonicalText, redefined);
        if (this.myType != null && nsDescriptor != null) {
            switch (this.myType) {
                case GroupReference: {
                    return nsDescriptor.findGroup(canonicalText);
                }
                case AttributeGroupReference: {
                    return nsDescriptor.findAttributeGroup(canonicalText);
                }
                case ElementReference: {
                    XmlElementDescriptor descriptor2 = nsDescriptor.getElementDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), new HashSet<XmlNSDescriptorImpl>(), true);
                    return descriptor2 != null ? descriptor2.getDeclaration() : null;
                }
                case AttributeReference: {
                    String localNameByQualifiedName = XmlUtil.findLocalNameByQualifiedName(canonicalText);
                    XmlAttributeDescriptor descriptor3 = nsDescriptor.getAttribute(localNameByQualifiedName, TypeOrElementOrAttributeReference.getNamespace(tag, canonicalText), tag);
                    if (descriptor3 != null) {
                        return descriptor3.getDeclaration();
                    }
                    return null;
                }
                case TypeReference: {
                    TypeDescriptor typeDescriptor;
                    TypeDescriptor typeDescriptor2 = typeDescriptor = redefined[0] ? nsDescriptor.findTypeDescriptor(XmlUtil.findLocalNameByQualifiedName(canonicalText), "") : nsDescriptor.getTypeDescriptor(canonicalText, tag);
                    if (typeDescriptor instanceof ComplexTypeDescriptor) {
                        return typeDescriptor.getDeclaration();
                    }
                    if (typeDescriptor == null) break;
                    return this.myElement;
                }
            }
        }
        return null;
    }

    XsdNsDescriptor getDescriptor(XmlTag tag, String text2, boolean[] redefined) {
        if (this.myType != ReferenceType.ElementReference && this.myType != ReferenceType.AttributeReference) {
            XmlNSDescriptorImpl redefinedDescriptor;
            PsiElement parentElement = this.myElement.getContext();
            PsiElement grandParentElement = parentElement != null ? parentElement.getParent() : null;
            boolean doRedefineCheck = false;
            if (parentElement instanceof XmlAttribute && grandParentElement instanceof XmlTag) {
                String attrName = ((XmlAttribute)parentElement).getName();
                String tagLocalName = ((XmlTag)grandParentElement).getLocalName();
                boolean bl = doRedefineCheck = "ref".equals(attrName) && ("group".equals(tagLocalName) || "attributeGroup".equals(tagLocalName)) || "base".equals(attrName) || "memberTypes".equals(attrName);
            }
            if (doRedefineCheck && (redefinedDescriptor = SchemaReferencesProvider.findRedefinedDescriptor(tag, text2)) != null) {
                redefined[0] = true;
                return redefinedDescriptor;
            }
        }
        String namespace = TypeOrElementOrAttributeReference.getNamespace(tag, text2);
        XmlNSDescriptor nsDescriptor = tag.getNSDescriptor(namespace, true);
        PsiFile file2 = tag.getContainingFile();
        if (!(file2 instanceof XmlFile)) {
            return null;
        }
        XmlDocument document = ((XmlFile)file2).getDocument();
        if (nsDescriptor == null) {
            nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        }
        if (nsDescriptor == null) {
            XmlNSDescriptor[] descrs = new XmlNSDescriptor[1];
            URLReference.processWsdlSchemas(document.getRootTag(), xmlTag -> {
                if (namespace.equals(xmlTag.getAttributeValue(TARGET_NAMESPACE))) {
                    descrs[0] = (XmlNSDescriptor)xmlTag.getMetaData();
                    return false;
                }
                return true;
            });
            if (descrs[0] instanceof XmlNSDescriptorImpl) {
                return (XmlNSDescriptorImpl)descrs[0];
            }
        }
        return nsDescriptor instanceof XsdNsDescriptor ? (XsdNsDescriptor)nsDescriptor : null;
    }

    private static String getNamespace(XmlTag tag, String text2) {
        String targetNsPrefix;
        String targetNS;
        String namespacePrefix = XmlUtil.findPrefixByQualifiedName(text2);
        String namespaceByPrefix = tag.getNamespaceByPrefix(namespacePrefix);
        if (!namespaceByPrefix.isEmpty()) {
            return namespaceByPrefix;
        }
        XmlTag rootTag = ((XmlFile)tag.getContainingFile()).getRootTag();
        if (rootTag != null && "schema".equals(rootTag.getLocalName()) && XmlUtil.ourSchemaUrisList.indexOf(rootTag.getNamespace()) != -1 && (targetNS = rootTag.getAttributeValue(TARGET_NAMESPACE)) != null && (namespacePrefix.equals(targetNsPrefix = rootTag.getPrefixByNamespace(targetNS)) || namespaceByPrefix.isEmpty() && targetNsPrefix == null)) {
            return targetNS;
        }
        return namespaceByPrefix;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String name;
        String text2 = this.myElement.getText();
        String string = name = this.myRange.getEndOffset() <= text2.length() ? this.myRange.substring(text2) : "";
        if (!name.isEmpty() && this.nsPrefix != null && !this.nsPrefix.isEmpty()) {
            name = this.nsPrefix + ":" + name;
        }
        String string2 = name;
        if (string2 == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(0);
        }
        return string2;
    }

    @Override
    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String canonicalText = this.getCanonicalText();
        PsiElement element = ElementManipulators.getManipulator(this.myElement).handleContentChange(this.myElement, this.getRangeInElement(), newElementName);
        this.myRange = new TextRange(this.myRange.getStartOffset(), this.myRange.getEndOffset() - (canonicalText.length() - newElementName.length()));
        return element;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(1);
        }
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isReferenceTo(PsiElement element) {
        return this.myElement.getManager().areElementsEquivalent(this.resolve(), element);
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        XmlTag tag = PsiTreeUtil.getContextOfType(this.myElement, XmlTag.class, true);
        if (tag == null || this.myType == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                TypeOrElementOrAttributeReference.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = TypeOrElementOrAttributeReference.getVariants(tag, this.myType, this.nsPrefix);
        if (objectArray == null) {
            TypeOrElementOrAttributeReference.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    public static Object[] getVariants(XmlTag tag, ReferenceType type2, String prefix) {
        String ourNamespace;
        String[] tagNames = null;
        switch (type2) {
            case GroupReference: {
                tagNames = new String[]{"group"};
                break;
            }
            case AttributeGroupReference: {
                tagNames = new String[]{"attributeGroup"};
                break;
            }
            case AttributeReference: {
                tagNames = new String[]{"attribute"};
                break;
            }
            case ElementReference: {
                tagNames = new String[]{"element"};
                break;
            }
            case TypeReference: {
                tagNames = new String[]{"simpleType", "complexType"};
            }
        }
        XmlDocument document = ((XmlFile)tag.getContainingFile()).getDocument();
        if (document == null) {
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        XmlTag rootTag = document.getRootTag();
        String string = ourNamespace = rootTag != null ? rootTag.getAttributeValue(TARGET_NAMESPACE) : "";
        if (ourNamespace == null) {
            ourNamespace = "";
        }
        CompletionProcessor processor = new CompletionProcessor(tag, prefix);
        for (String namespace : tag.knownNamespaces()) {
            XmlNSDescriptor nsDescriptor;
            if (ourNamespace.equals(namespace) || !((nsDescriptor = tag.getNSDescriptor(namespace, true)) instanceof XsdNsDescriptor)) continue;
            TypeOrElementOrAttributeReference.processNamespace(namespace, processor, (XsdNsDescriptor)nsDescriptor, tagNames);
        }
        XmlNSDescriptor nsDescriptor = (XmlNSDescriptor)document.getMetaData();
        if (nsDescriptor instanceof XmlNSDescriptorImpl) {
            TypeOrElementOrAttributeReference.processNamespace(ourNamespace, processor, (XmlNSDescriptorImpl)nsDescriptor, tagNames);
        }
        return ArrayUtil.toStringArray(processor.myElements);
    }

    private static void processNamespace(String namespace, CompletionProcessor processor, XsdNsDescriptor nsDescriptor, String[] tagNames) {
        processor.namespace = namespace;
        nsDescriptor.processTagsInNamespace(tagNames, processor);
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CompletionProcessor
    implements PsiElementProcessor<XmlTag> {
        final List<String> myElements = new ArrayList<String>(1);
        String namespace;
        final XmlTag tag;
        private final String prefix;

        CompletionProcessor(XmlTag tag, String prefix) {
            this.tag = tag;
            this.prefix = prefix;
        }

        @Override
        public boolean execute(@NotNull XmlTag element) {
            if (element == null) {
                CompletionProcessor.$$$reportNull$$$0(0);
            }
            String name = element.getAttributeValue("name");
            String prefixByNamespace = this.tag.getPrefixByNamespace(this.namespace);
            if (prefixByNamespace != null && !prefixByNamespace.isEmpty() && this.prefix == null) {
                name = prefixByNamespace + ":" + name;
            }
            this.myElements.add(name);
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/impl/source/resolve/reference/impl/providers/TypeOrElementOrAttributeReference$CompletionProcessor", "execute"));
        }
    }

    public static enum ReferenceType {
        ElementReference,
        AttributeReference,
        GroupReference,
        AttributeGroupReference,
        TypeReference;

    }
}

