/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.xml.XmlAttribute;
import org.jetbrains.annotations.NotNull;

public class XmlAttributeLiteralEscaper
extends LiteralTextEscaper<XmlAttributeValueImpl> {
    private final XmlAttribute myXmlAttribute;

    public XmlAttributeLiteralEscaper(XmlAttributeValueImpl host) {
        super(host);
        PsiElement parent2 = host.getParent();
        this.myXmlAttribute = parent2 instanceof XmlAttribute ? (XmlAttribute)parent2 : XmlElementFactory.getInstance(host.getProject()).createAttribute("a", host.getValue(), parent2);
    }

    @Override
    public boolean decode(@NotNull TextRange rangeInsideHost, @NotNull StringBuilder outChars) {
        if (rangeInsideHost == null) {
            XmlAttributeLiteralEscaper.$$$reportNull$$$0(0);
        }
        if (outChars == null) {
            XmlAttributeLiteralEscaper.$$$reportNull$$$0(1);
        }
        TextRange valueTextRange = this.myXmlAttribute.getValueTextRange();
        int startInDecoded = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getStartOffset() - valueTextRange.getStartOffset());
        int endInDecoded = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getEndOffset() - valueTextRange.getStartOffset());
        String displayValue = this.myXmlAttribute.getDisplayValue();
        int n = startInDecoded < 0 ? 0 : (startInDecoded = startInDecoded > displayValue.length() ? displayValue.length() : startInDecoded);
        int n2 = endInDecoded < 0 ? 0 : (endInDecoded = endInDecoded > displayValue.length() ? displayValue.length() : endInDecoded);
        if (startInDecoded > endInDecoded) {
            endInDecoded = startInDecoded;
        }
        outChars.append(displayValue, startInDecoded, endInDecoded);
        return true;
    }

    @Override
    public int getOffsetInHost(int offsetInDecoded, @NotNull TextRange rangeInsideHost) {
        if (rangeInsideHost == null) {
            XmlAttributeLiteralEscaper.$$$reportNull$$$0(2);
        }
        TextRange valueTextRange = this.myXmlAttribute.getValueTextRange();
        int displayStart = this.myXmlAttribute.physicalToDisplay(rangeInsideHost.getStartOffset());
        int dp = this.myXmlAttribute.displayToPhysical(offsetInDecoded + displayStart - valueTextRange.getStartOffset());
        if (dp == -1) {
            return -1;
        }
        return dp + valueTextRange.getStartOffset();
    }

    @Override
    public boolean isOneLine() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideHost";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outChars";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/XmlAttributeLiteralEscaper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "decode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getOffsetInHost";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

