/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.xml;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.pom.PomManager;
import com.intellij.pom.PomModel;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.pom.impl.PomTransactionBase;
import com.intellij.pom.xml.XmlAspect;
import com.intellij.pom.xml.events.XmlChange;
import com.intellij.pom.xml.impl.XmlAspectChangeSetImpl;
import com.intellij.pom.xml.impl.events.XmlTagChildAddImpl;
import com.intellij.pom.xml.impl.events.XmlTextChangedImpl;
import com.intellij.psi.LiteralTextEscaper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.injected.XmlTextLiteralEscaper;
import com.intellij.psi.impl.source.xml.LanguageXmlPsiPolicy;
import com.intellij.psi.impl.source.xml.XmlElementImpl;
import com.intellij.psi.impl.source.xml.XmlPsiPolicy;
import com.intellij.psi.impl.source.xml.behavior.DefaultXmlPsiPolicy;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagChild;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlTextImpl
extends XmlElementImpl
implements XmlText,
PsiLanguageInjectionHost {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.xml.XmlTextImpl");
    private volatile String myDisplayText;
    private volatile int[] myGapDisplayStarts;
    private volatile int[] myGapPhysicalStarts;

    public XmlTextImpl() {
        super(XmlElementType.XML_TEXT);
    }

    @Override
    public String toString() {
        return "XmlText";
    }

    @Override
    public boolean isValidHost() {
        return true;
    }

    @Override
    @Nullable
    public XmlText split(int displayIndex) {
        try {
            return this._splitText(displayIndex);
        }
        catch (IncorrectOperationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public String getValue() {
        String text2;
        String displayText = this.myDisplayText;
        if (displayText != null) {
            return displayText;
        }
        StringBuilder buffer = new StringBuilder();
        ASTNode child = this.getFirstChildNode();
        TIntArrayList gapsStarts = new TIntArrayList();
        TIntArrayList gapsShifts = new TIntArrayList();
        while (child != null) {
            ASTNode next;
            int start = buffer.length();
            IElementType elementType = child.getElementType();
            if (elementType == XmlElementType.XML_CDATA) {
                TreeElement cdata = child;
                child = cdata.getFirstChildNode();
            } else if (elementType == XmlTokenType.XML_CHAR_ENTITY_REF) {
                String text3 = child.getText();
                LOG.assertTrue(text3 != null, child);
                buffer.append(XmlUtil.getCharFromEntityRef(text3));
            } else if (elementType == XmlTokenType.XML_WHITE_SPACE || elementType == XmlTokenType.XML_DATA_CHARACTERS || elementType == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN) {
                buffer.append(child.getText());
            } else if (elementType == TokenType.ERROR_ELEMENT || elementType == TokenType.NEW_LINE_INDENT) {
                buffer.append(child.getText());
            }
            int end = buffer.length();
            int originalLength = child.getTextLength();
            if (end - start != originalLength) {
                gapsStarts.add(end);
                gapsShifts.add(originalLength - (end - start));
            }
            if ((next = child.getTreeNext()) == null && child.getTreeParent().getElementType() == XmlElementType.XML_CDATA) {
                child = child.getTreeParent().getTreeNext();
                continue;
            }
            child = next;
        }
        int[] gapDisplayStarts = ArrayUtil.newIntArray(gapsShifts.size());
        int[] gapPhysicalStarts = ArrayUtil.newIntArray(gapsShifts.size());
        int currentGapsSum = 0;
        for (int i = 0; i < gapDisplayStarts.length; ++i) {
            gapDisplayStarts[i] = gapsStarts.get(i);
            gapPhysicalStarts[i] = gapDisplayStarts[i] + (currentGapsSum += gapsShifts.get(i));
        }
        this.myGapDisplayStarts = gapDisplayStarts;
        this.myGapPhysicalStarts = gapPhysicalStarts;
        this.myDisplayText = text2 = buffer.toString();
        return text2;
    }

    @Override
    public int physicalToDisplay(int physicalIndex) {
        int prevDisplayGapStart;
        this.getValue();
        if (this.myGapPhysicalStarts.length == 0) {
            return physicalIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapPhysicalStarts, physicalIndex);
        if (bsResult >= 0) {
            return this.myGapDisplayStarts[bsResult];
        }
        int insertionIndex = -bsResult - 1;
        int prevPhysGapStart = insertionIndex > 0 ? this.myGapPhysicalStarts[insertionIndex - 1] : 0;
        int n = prevDisplayGapStart = insertionIndex > 0 ? this.myGapDisplayStarts[insertionIndex - 1] : 0;
        if (insertionIndex < this.myGapDisplayStarts.length) {
            int prevDisplayGapLength;
            int n2 = prevDisplayGapLength = insertionIndex > 0 ? this.myGapDisplayStarts[insertionIndex] - this.myGapDisplayStarts[insertionIndex - 1] : this.myGapDisplayStarts[0];
            if (physicalIndex - prevPhysGapStart > prevDisplayGapLength) {
                return this.myGapDisplayStarts[insertionIndex];
            }
        }
        return physicalIndex - prevPhysGapStart + prevDisplayGapStart;
    }

    @Override
    public int displayToPhysical(int displayIndex) {
        this.getValue();
        if (this.myGapDisplayStarts.length == 0) {
            return displayIndex;
        }
        int bsResult = Arrays.binarySearch(this.myGapDisplayStarts, displayIndex);
        if (bsResult >= 0) {
            return this.myGapPhysicalStarts[bsResult];
        }
        int insertionIndex = -bsResult - 1;
        int prevPhysGapStart = insertionIndex > 0 ? this.myGapPhysicalStarts[insertionIndex - 1] : 0;
        int prevDisplayGapStart = insertionIndex > 0 ? this.myGapDisplayStarts[insertionIndex - 1] : 0;
        return displayIndex - prevDisplayGapStart + prevPhysGapStart;
    }

    @Override
    public void setValue(String s) throws IncorrectOperationException {
        this.doSetValue(s, this.getPolicy());
    }

    public void doSetValue(final String s, final XmlPsiPolicy policy) throws IncorrectOperationException {
        final PomModel model = PomManager.getModel(this.getProject());
        XmlAspect aspect = model.getModelAspect(XmlAspect.class);
        model.runTransaction(new PomTransactionBase(this, aspect){

            @Override
            public PomModelEvent runInner() {
                String oldText = XmlTextImpl.this.getText();
                ASTNode firstEncodedElement = policy.encodeXmlTextContents(s, XmlTextImpl.this);
                if (firstEncodedElement == null) {
                    XmlTextImpl.this.delete();
                } else {
                    XmlTextImpl.this.replaceAllChildrenToChildrenOf(firstEncodedElement.getTreeParent());
                }
                XmlTextImpl.this.clearCaches();
                return XmlTextChangedImpl.createXmlTextChanged(model, XmlTextImpl.this, oldText);
            }
        });
    }

    @Override
    public XmlElement insertAtOffset(final XmlElement element, final int displayOffset) throws IncorrectOperationException {
        if (element instanceof XmlText) {
            this.insertText(((XmlText)element).getValue(), displayOffset);
        } else {
            PomModel model = PomManager.getModel(this.getProject());
            XmlAspect aspect = model.getModelAspect(XmlAspect.class);
            model.runTransaction(new PomTransactionBase(this.getParent(), aspect){

                @Override
                public PomModelEvent runInner() throws IncorrectOperationException {
                    XmlTag tag = XmlTextImpl.this.getParentTag();
                    assert (tag != null);
                    XmlText rightPart = XmlTextImpl.this._splitText(displayOffset);
                    PsiElement result2 = rightPart != null ? tag.addBefore(element, rightPart) : tag.addAfter(element, XmlTextImpl.this);
                    return XmlTextImpl.this.createEvent(new XmlChange[]{new XmlTagChildAddImpl(tag, (XmlTagChild)result2)});
                }
            });
        }
        return this;
    }

    private XmlPsiPolicy getPolicy() {
        return (XmlPsiPolicy)LanguageXmlPsiPolicy.INSTANCE.forLanguage(this.getLanguage());
    }

    @Override
    public void insertText(String text2, int displayOffset) throws IncorrectOperationException {
        IElementType elementType;
        if (text2 == null || text2.isEmpty()) {
            return;
        }
        int physicalOffset = this.displayToPhysical(displayOffset);
        final PsiElement psiElement = this.findElementAt(physicalOffset);
        IElementType iElementType = elementType = psiElement != null ? psiElement.getNode().getElementType() : null;
        if (elementType == XmlTokenType.XML_DATA_CHARACTERS) {
            int insertOffset = physicalOffset - psiElement.getStartOffsetInParent();
            String oldElementText = psiElement.getText();
            final String newElementText = oldElementText.substring(0, insertOffset) + text2 + oldElementText.substring(insertOffset);
            final PomModel model = PomManager.getModel(this.getProject());
            XmlAspect aspect = model.getModelAspect(XmlAspect.class);
            model.runTransaction(new PomTransactionBase(this, aspect){

                @Override
                public PomModelEvent runInner() {
                    String oldText = XmlTextImpl.this.getText();
                    ASTNode e = XmlTextImpl.this.getPolicy().encodeXmlTextContents(newElementText, XmlTextImpl.this);
                    ASTNode node = psiElement.getNode();
                    ASTNode treeNext = node.getTreeNext();
                    XmlTextImpl.this.addChildren(e, null, treeNext);
                    XmlTextImpl.this.deleteChildInternal(node);
                    XmlTextImpl.this.clearCaches();
                    return XmlTextChangedImpl.createXmlTextChanged(model, XmlTextImpl.this, oldText);
                }
            });
        } else {
            this.setValue(new StringBuffer(this.getValue()).insert(displayOffset, text2).toString());
        }
    }

    @Override
    public void removeText(int displayStart, int displayEnd) throws IncorrectOperationException {
        String value = this.getValue();
        int physicalStart = this.displayToPhysical(displayStart);
        final PsiElement psiElement = this.findElementAt(physicalStart);
        if (psiElement != null) {
            IElementType elementType = psiElement.getNode().getElementType();
            int elementDisplayEnd = this.physicalToDisplay(psiElement.getStartOffsetInParent() + psiElement.getTextLength());
            int elementDisplayStart = this.physicalToDisplay(psiElement.getStartOffsetInParent());
            if ((elementType == XmlTokenType.XML_DATA_CHARACTERS || elementType == TokenType.WHITE_SPACE) && elementDisplayEnd >= displayEnd && elementDisplayStart <= displayStart) {
                int physicalEnd;
                for (physicalEnd = physicalStart; physicalEnd < this.getTextRange().getLength() && this.physicalToDisplay(physicalEnd) != displayEnd; ++physicalEnd) {
                }
                int removeStart = physicalStart - psiElement.getStartOffsetInParent();
                int removeEnd = physicalEnd - psiElement.getStartOffsetInParent();
                String oldElementText = psiElement.getText();
                final String newElementText = oldElementText.substring(0, removeStart) + oldElementText.substring(removeEnd);
                final PomModel model = PomManager.getModel(this.getProject());
                XmlAspect aspect = model.getModelAspect(XmlAspect.class);
                model.runTransaction(new PomTransactionBase(this, aspect){

                    @Override
                    public PomModelEvent runInner() throws IncorrectOperationException {
                        String oldText = XmlTextImpl.this.getText();
                        if (!newElementText.isEmpty()) {
                            ASTNode e = XmlTextImpl.this.getPolicy().encodeXmlTextContents(newElementText, XmlTextImpl.this);
                            XmlTextImpl.this.replaceChild(psiElement.getNode(), e);
                        } else {
                            psiElement.delete();
                        }
                        XmlTextImpl.this.clearCaches();
                        return XmlTextChangedImpl.createXmlTextChanged(model, XmlTextImpl.this, oldText);
                    }
                });
                return;
            }
        }
        if (displayStart == 0 && displayEnd == value.length()) {
            this.delete();
        } else {
            this.setValue(new StringBuffer(this.getValue()).replace(displayStart, displayEnd, "").toString());
        }
    }

    @Override
    public XmlTag getParentTag() {
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof XmlTag) {
            return (XmlTag)parent2;
        }
        return null;
    }

    @Override
    public XmlTagChild getNextSiblingInTag() {
        PsiElement nextSibling = this.getNextSibling();
        if (nextSibling instanceof XmlTagChild) {
            return (XmlTagChild)nextSibling;
        }
        return null;
    }

    @Override
    public XmlTagChild getPrevSiblingInTag() {
        PsiElement prevSibling = this.getPrevSibling();
        if (prevSibling instanceof XmlTagChild) {
            return (XmlTagChild)prevSibling;
        }
        return null;
    }

    @Override
    public TreeElement addInternal(TreeElement first2, ASTNode last2, ASTNode anchor2, Boolean before) {
        throw new RuntimeException("Clients must not use operations with direct children of XmlText!");
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            XmlTextImpl.$$$reportNull$$$0(0);
        }
        if (visitor2 instanceof XmlElementVisitor) {
            ((XmlElementVisitor)visitor2).visitXmlText(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.myDisplayText = null;
        this.myGapDisplayStarts = null;
        this.myGapPhysicalStarts = null;
    }

    public TextRange getCDATAInterior() {
        ASTNode startNode;
        ASTNode startNode2;
        PsiElement[] elements = this.getChildren();
        int start = 0;
        int first2 = 0;
        if (elements.length > 0 && elements[0] instanceof PsiWhiteSpace) {
            ++first2;
        }
        if (elements.length > first2 && elements[first2].getNode().getElementType() == XmlElementType.XML_CDATA && (startNode2 = elements[first2].getNode().findChildByType(XmlTokenType.XML_CDATA_START)) != null) {
            start = startNode2.getTextRange().getEndOffset() - this.getTextRange().getStartOffset();
        }
        int end = this.getTextLength();
        int last2 = elements.length - 1;
        if (last2 > 0 && elements[last2] instanceof PsiWhiteSpace) {
            --last2;
        }
        if (last2 >= 0 && elements[last2].getNode().getElementType() == XmlElementType.XML_CDATA && (startNode = elements[last2].getNode().findChildByType(XmlTokenType.XML_CDATA_END)) != null) {
            end = startNode.getTextRange().getStartOffset() - this.getTextRange().getStartOffset();
        }
        return new TextRange(start, end);
    }

    @Override
    public PsiLanguageInjectionHost updateText(@NotNull String text2) {
        if (text2 == null) {
            XmlTextImpl.$$$reportNull$$$0(1);
        }
        try {
            this.doSetValue(text2, new DefaultXmlPsiPolicy());
        }
        catch (IncorrectOperationException e) {
            LOG.error(e);
        }
        return this;
    }

    @Nullable
    private XmlText _splitText(final int displayOffset) throws IncorrectOperationException {
        final XmlTag xmlTag = (XmlTag)this.getParent();
        if (displayOffset == 0) {
            return this;
        }
        int length = this.getValue().length();
        if (displayOffset >= length) {
            return null;
        }
        PomModel model = PomManager.getModel(xmlTag.getProject());
        final XmlAspect aspect = model.getModelAspect(XmlAspect.class);
        class MyTransaction
        extends PomTransactionBase {
            private XmlTextImpl myRight;

            MyTransaction() {
                super(xmlTag2, xmlAspect);
            }

            @Override
            @Nullable
            public PomModelEvent runInner() throws IncorrectOperationException {
                String oldText = XmlTextImpl.this.getValue();
                int physicalOffset = XmlTextImpl.this.displayToPhysical(displayOffset);
                PsiElement childElement = XmlTextImpl.this.findElementAt(physicalOffset);
                if (childElement != null && childElement.getNode().getElementType() == XmlTokenType.XML_DATA_CHARACTERS) {
                    FileElement holder = DummyHolderFactory.createHolder(XmlTextImpl.this.getManager(), null).getTreeElement();
                    int splitOffset = physicalOffset - childElement.getStartOffsetInParent();
                    this.myRight = (XmlTextImpl)ASTFactory.composite(XmlElementType.XML_TEXT);
                    CodeEditUtil.setNodeGenerated(this.myRight, true);
                    holder.rawAddChildren(this.myRight);
                    for (PsiElement e = childElement; e != null; e = e.getNextSibling()) {
                        CodeEditUtil.setNodeGenerated(e.getNode(), true);
                    }
                    String leftText = childElement.getText().substring(0, splitOffset);
                    String rightText = childElement.getText().substring(splitOffset);
                    LeafElement rightElement = ASTFactory.leaf(XmlTokenType.XML_DATA_CHARACTERS, holder.getCharTable().intern(rightText));
                    CodeEditUtil.setNodeGenerated(rightElement, true);
                    LeafElement leftElement = ASTFactory.leaf(XmlTokenType.XML_DATA_CHARACTERS, holder.getCharTable().intern(leftText));
                    CodeEditUtil.setNodeGenerated(leftElement, true);
                    XmlTextImpl.this.rawInsertAfterMe(this.myRight);
                    this.myRight.rawAddChildren(rightElement);
                    if (childElement.getNextSibling() != null) {
                        this.myRight.rawAddChildren((TreeElement)((Object)childElement.getNextSibling()));
                    }
                    ((TreeElement)((Object)childElement)).rawRemove();
                    XmlTextImpl.this.rawAddChildren(leftElement);
                } else {
                    PsiFile containingFile = xmlTag.getContainingFile();
                    FileElement holder = DummyHolderFactory.createHolder(containingFile.getManager(), null, ((PsiFileImpl)containingFile).getTreeElement().getCharTable()).getTreeElement();
                    XmlTextImpl rightText = (XmlTextImpl)ASTFactory.composite(XmlElementType.XML_TEXT);
                    CodeEditUtil.setNodeGenerated(rightText, true);
                    holder.rawAddChildren(rightText);
                    ((ASTNode)((Object)xmlTag)).addChild(rightText, XmlTextImpl.this.getTreeNext());
                    String value = XmlTextImpl.this.getValue();
                    XmlTextImpl.this.setValue(value.substring(0, displayOffset));
                    rightText.setValue(value.substring(displayOffset));
                    CodeEditUtil.setNodeGenerated(rightText, true);
                    this.myRight = rightText;
                }
                XmlTextImpl.this.clearCaches();
                this.myRight.clearCaches();
                return XmlTextImpl.this.createEvent(new XmlChange[]{new XmlTextChangedImpl(XmlTextImpl.this, oldText), new XmlTagChildAddImpl(xmlTag, this.myRight)});
            }

            public XmlText getResult() {
                return this.myRight;
            }
        }
        MyTransaction transaction = new MyTransaction();
        model.runTransaction(transaction);
        return transaction.getResult();
    }

    private PomModelEvent createEvent(XmlChange ... events) {
        PomModelEvent event = new PomModelEvent(PomManager.getModel(this.getProject()));
        XmlAspectChangeSetImpl xmlAspectChangeSet = new XmlAspectChangeSetImpl(PomManager.getModel(this.getProject()), (XmlFile)this.getContainingFile());
        for (XmlChange xmlChange : events) {
            xmlAspectChangeSet.add(xmlChange);
        }
        event.registerChangeSet(PomManager.getModel(this.getProject()).getModelAspect(XmlAspect.class), xmlAspectChangeSet);
        return event;
    }

    @NotNull
    public LiteralTextEscaper<XmlTextImpl> createLiteralTextEscaper() {
        XmlTextLiteralEscaper xmlTextLiteralEscaper = new XmlTextLiteralEscaper(this);
        if (xmlTextLiteralEscaper == null) {
            XmlTextImpl.$$$reportNull$$$0(2);
        }
        return xmlTextLiteralEscaper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/xml/XmlTextImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/xml/XmlTextImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createLiteralTextEscaper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "updateText";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

