/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PatternBasedPackageSet;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePatternPackageSet
extends PatternBasedPackageSet {
    @NonNls
    public static final String SCOPE_FILE = "file";
    private Pattern myModulePattern;
    private Pattern myModuleGroupPattern;
    private final String myPathPattern;
    private final Pattern myFilePattern;
    private final String myModulePatternText;
    private static final Logger LOG = Logger.getInstance("com.intellij.psi.search.scope.packageSet.FilePatternPackageSet");

    public FilePatternPackageSet(@NonNls String modulePattern, @NonNls String filePattern) {
        this.myPathPattern = filePattern;
        this.myModulePatternText = modulePattern;
        if (modulePattern == null || modulePattern.isEmpty()) {
            this.myModulePattern = null;
        } else if (modulePattern.startsWith("group:")) {
            int idx = modulePattern.indexOf(58, 6);
            if (idx == -1) {
                idx = modulePattern.length();
            }
            this.myModuleGroupPattern = Pattern.compile(StringUtil.replace(FilePatternPackageSet.escapeToRegexp(modulePattern.substring(6, idx)), "*", ".*"));
            if (idx < modulePattern.length() - 1) {
                this.myModulePattern = Pattern.compile(StringUtil.replace(FilePatternPackageSet.escapeToRegexp(modulePattern.substring(idx + 1)), "*", ".*"));
            }
        } else {
            this.myModulePattern = Pattern.compile(StringUtil.replace(FilePatternPackageSet.escapeToRegexp(modulePattern), "*", ".*"));
        }
        this.myFilePattern = filePattern != null ? Pattern.compile(FilePatternPackageSet.convertToRegexp(filePattern, '/')) : null;
    }

    @Override
    public boolean contains(VirtualFile file2, @NotNull NamedScopesHolder holder) {
        if (holder == null) {
            FilePatternPackageSet.$$$reportNull$$$0(0);
        }
        return this.contains(file2, holder.getProject(), holder);
    }

    @Override
    public boolean contains(VirtualFile file2, @NotNull Project project, @Nullable NamedScopesHolder holder) {
        if (project == null) {
            FilePatternPackageSet.$$$reportNull$$$0(1);
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance(project).getFileIndex();
        return file2 != null && this.fileMatcher(file2, fileIndex, holder != null ? holder.getProjectBaseDir() : project.getBaseDir()) && FilePatternPackageSet.matchesModule(this.myModuleGroupPattern, this.myModulePattern, file2, fileIndex);
    }

    private boolean fileMatcher(@NotNull VirtualFile virtualFile2, ProjectFileIndex fileIndex, VirtualFile projectBaseDir) {
        String relativePath;
        if (virtualFile2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(2);
        }
        if (virtualFile2 instanceof VirtualFileWindow) {
            virtualFile2 = ((VirtualFileWindow)((Object)virtualFile2)).getDelegate();
        }
        if ((relativePath = FilePatternPackageSet.getRelativePath(virtualFile2, fileIndex, true, projectBaseDir)) == null) {
            LOG.error("vFile: " + virtualFile2 + "; projectBaseDir: " + projectBaseDir + "; content File: " + fileIndex.getContentRootForFile(virtualFile2));
        }
        if (StringUtil.isEmptyOrSpaces(relativePath) && !virtualFile2.equals(projectBaseDir)) {
            return false;
        }
        return this.myFilePattern.matcher(relativePath).matches();
    }

    public static boolean matchesModule(Pattern moduleGroupPattern, Pattern modulePattern, VirtualFile file2, ProjectFileIndex fileIndex) {
        Module module2 = fileIndex.getModuleForFile(file2);
        if (module2 != null) {
            String[] groupPath;
            if (modulePattern != null && modulePattern.matcher(module2.getName()).matches()) {
                return true;
            }
            if (moduleGroupPattern != null && (groupPath = ModuleManager.getInstance(module2.getProject()).getModuleGroupPath(module2)) != null) {
                for (String node : groupPath) {
                    if (!moduleGroupPattern.matcher(node).matches()) continue;
                    return true;
                }
            }
        }
        return modulePattern == null && moduleGroupPattern == null;
    }

    @NotNull
    private static String escapeToRegexp(@NotNull CharSequence text2) {
        if (text2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(3);
        }
        StringBuilder builder = new StringBuilder(text2.length());
        for (int i = 0; i < text2.length(); ++i) {
            char c = text2.charAt(i);
            if (c == ' ' || Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '*') {
                builder.append(c);
                continue;
            }
            builder.append('\\').append(c);
        }
        String string = builder.toString();
        if (string == null) {
            FilePatternPackageSet.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static String convertToRegexp(String aspectsntx, char separator) {
        StringBuilder buf = new StringBuilder(aspectsntx.length());
        boolean isAfterSeparator = false;
        boolean isAfterAsterix = false;
        for (int cur = 0; cur < aspectsntx.length(); ++cur) {
            char curChar = aspectsntx.charAt(cur);
            if (curChar != separator && isAfterSeparator) {
                buf.append("\\" + separator);
                isAfterSeparator = false;
            }
            if (curChar != '*' && isAfterAsterix) {
                buf.append(".*");
                isAfterAsterix = false;
            }
            if (curChar == '*') {
                if (!isAfterAsterix) {
                    isAfterAsterix = true;
                    continue;
                }
                buf.append("[^\\" + separator + "]*");
                isAfterAsterix = false;
                continue;
            }
            if (curChar == separator) {
                if (isAfterSeparator) {
                    buf.append("\\" + separator + "(.*\\" + separator + ")?");
                    isAfterSeparator = false;
                    continue;
                }
                isAfterSeparator = true;
                continue;
            }
            if (curChar == '.') {
                buf.append("\\");
            }
            buf.append(curChar);
        }
        if (isAfterAsterix) {
            buf.append("[^\\" + separator + "]*");
        }
        return buf.toString();
    }

    @Override
    @NotNull
    public PackageSet createCopy() {
        FilePatternPackageSet filePatternPackageSet = new FilePatternPackageSet(this.myModulePatternText, this.myPathPattern);
        if (filePatternPackageSet == null) {
            FilePatternPackageSet.$$$reportNull$$$0(5);
        }
        return filePatternPackageSet;
    }

    @Override
    public int getNodePriority() {
        return 0;
    }

    @Override
    @NotNull
    public String getText() {
        StringBuffer buf = new StringBuffer(SCOPE_FILE);
        if (this.myModulePattern != null || this.myModuleGroupPattern != null) {
            buf.append("[").append(this.myModulePatternText).append("]");
        }
        if (buf.length() > 0) {
            buf.append(':');
        }
        buf.append(this.myPathPattern);
        String string = buf.toString();
        if (string == null) {
            FilePatternPackageSet.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public String getPattern() {
        return this.myPathPattern;
    }

    @Override
    public String getModulePattern() {
        return this.myModulePatternText;
    }

    @Override
    public boolean isOn(String oldQName) {
        return Comparing.strEqual(this.myPathPattern, oldQName) || Comparing.strEqual(oldQName + "//*", this.myPathPattern) || Comparing.strEqual(oldQName + "/*", this.myPathPattern);
    }

    @Nullable
    public static String getRelativePath(@NotNull VirtualFile virtualFile2, @NotNull ProjectFileIndex index2, boolean useFQName, VirtualFile projectBaseDir) {
        VirtualFile contentRootForFile;
        if (virtualFile2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(7);
        }
        if (index2 == null) {
            FilePatternPackageSet.$$$reportNull$$$0(8);
        }
        if ((contentRootForFile = index2.getContentRootForFile(virtualFile2)) != null) {
            return VfsUtilCore.getRelativePath(virtualFile2, contentRootForFile, '/');
        }
        Module module2 = index2.getModuleForFile(virtualFile2);
        if (module2 != null) {
            if (projectBaseDir != null && VfsUtilCore.isAncestor(projectBaseDir, virtualFile2, false)) {
                String projectRelativePath = VfsUtilCore.getRelativePath(virtualFile2, projectBaseDir, '/');
                return useFQName ? projectRelativePath : projectRelativePath.substring(projectRelativePath.indexOf(47) + 1);
            }
            return virtualFile2.getPath();
        }
        return FilePatternPackageSet.getLibRelativePath(virtualFile2, index2);
    }

    public static String getLibRelativePath(VirtualFile virtualFile2, ProjectFileIndex index2) {
        StringBuilder relativePath = new StringBuilder(100);
        for (VirtualFile directory = virtualFile2; directory != null && index2.isInLibraryClasses(directory); directory = directory.getParent()) {
            relativePath.insert(0, '/');
            relativePath.insert(0, directory.getName());
        }
        return relativePath.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/packageSet/FilePatternPackageSet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeToRegexp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopy";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fileMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "escapeToRegexp";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

